/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.migration;

import com.ibm.team.enterprise.zos.systemdefinition.common.migration.IMigrator;
import com.ibm.team.enterprise.zos.systemdefinition.common.migration.nls.Messages;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class MigratorFactory {
    private Map<Class, IMigrator> migratorMap;
    private static MigratorFactory instance;

    public static MigratorFactory getInstance() {
        if (instance == null) {
            instance = new MigratorFactory();
        }
        return instance;
    }

    private MigratorFactory() {
    }

    public IMigrator getMigrator(Class aClass) throws NullPointerException {
        IMigrator migrator = null;
        Class interfaceClass = this.getInterface(aClass);
        if (interfaceClass != null) {
            migrator = this.migratorMap.get(interfaceClass);
        }
        if (migrator == null) {
            throw new NullPointerException(NLS.bind((String)Messages.ERROR_NO_MIGRATOR_FOUND, (Object)aClass.getName()));
        }
        return migrator;
    }

    public IMigrator getMigrator(Object object) throws NullPointerException {
        return this.getMigrator(object.getClass());
    }

    private Class getInterface(Class aClass) {
        for (Class nextClass : this.migratorMap.keySet()) {
            if (!nextClass.isAssignableFrom(aClass)) continue;
            return nextClass;
        }
        return null;
    }
}

