/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.internal.common.common.model.CodePage;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.MPCharacteristicsUtils;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.MPNameValidationUtil;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.MappingException;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.DatasetAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingConstants;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.nls.Messages;
import java.util.HashMap;
import org.eclipse.osgi.util.NLS;

public class MappingValidation {
    private static String[] typeListValues = new String[]{"library", "seq", "vsam", "pds", "library,1", "library,2", "undefined"};
    private final MPNameValidationUtil nameValidator = new MPNameValidationUtil();
    private final MPCharacteristicsUtils attribValidator = new MPCharacteristicsUtils();
    private CodePage codePage;
    private String nationalCharacters;
    private MappingException cvException = null;

    public MappingValidation() {
        this(null);
    }

    public MappingValidation(IEnterpriseConfiguration configuration) {
        if (configuration == null) {
            this.codePage = IEnterpriseConfiguration.EC_DEFAULT_CODEPAGE;
            this.nationalCharacters = "@$#";
        } else {
            this.codePage = configuration.getCodePage();
            this.nationalCharacters = configuration.getNationalCharacters();
        }
    }

    public int isValidDSName(String dsName) {
        int rc = this.nameValidator.validateDataSetName(dsName);
        return rc;
    }

    public int isValidDSName(String dsName, String codeVariants) {
        int rc = this.nameValidator.validateDataSetName(dsName, codeVariants);
        return rc;
    }

    public int isValidMemberName(String mbrName) {
        return this.isValidMemberName(mbrName, this.nationalCharacters);
    }

    public int isValidMemberName(String mbrName, String nationals) {
        int rc = this.nameValidator.validateMemberName(mbrName, nationals);
        return rc;
    }

    public int isValidDDName(String ddName) {
        return this.isValidMemberName(ddName, this.nationalCharacters);
    }

    public int isValidTempoDSName(String dsName) {
        int rc = this.nameValidator.validateTempoDSName(dsName);
        return rc;
    }

    public int isValidDSName(String dsName, boolean isTemporary) {
        int rc = 0;
        rc = isTemporary ? this.nameValidator.validateTempoDSName(dsName) : this.nameValidator.validateDataSetName(dsName);
        return rc;
    }

    public int isValidDSName(String dsName, boolean isTemporary, boolean isPrefix) {
        return this.isValidDSName(dsName, isTemporary, isPrefix, false);
    }

    public int isValidDSName(String dsName, boolean isTemporary, boolean isPrefix, boolean isPropertyAllowed) {
        int rc = 0;
        if (isTemporary) {
            rc = this.nameValidator.validateTempoDSName(dsName);
        } else {
            String pseudoDSN = dsName;
            if (isPropertyAllowed) {
                pseudoDSN = MappingValidation.validateAndSubstituteBuildPropertiesBeforeValidation(dsName);
            }
            pseudoDSN = MappingValidation.substituteSystemsymbols(pseudoDSN);
            rc = this.nameValidator.validateDataSetName(pseudoDSN, isPrefix);
        }
        return rc;
    }

    public int isValidStorageClass(String stoCls) {
        int rc = this.attribValidator.validateAttribClass(stoCls, 8);
        return rc;
    }

    public int isValidDataClass(String dataCls) {
        int rc = this.attribValidator.validateAttribClass(dataCls, 8);
        return rc;
    }

    public int isValidMngtClass(String mgtCls) {
        int rc = this.attribValidator.validateAttribClass(mgtCls, 8);
        return rc;
    }

    public int isValidVolumeSerial(String volume) {
        int rc = this.attribValidator.validateAttribClass(volume, 6);
        return rc;
    }

    public int isValidGenericUnit(String generic) {
        int rc = this.attribValidator.validateGenericUnits(generic);
        return rc;
    }

    public boolean isValidSpaceUnit(String spaUnit) {
        boolean result = true;
        String[] unitLstValues = this.getSpaceUnitList();
        result = this.attribValidator.validateListValue(spaUnit, unitLstValues);
        return result;
    }

    public int isValidPrimary(String primary) {
        int rc = this.attribValidator.validateAttribQuant(primary, 0xFFFFFF);
        return rc;
    }

    public int isValidSecondary(String secondary) {
        int rc = this.attribValidator.validateBoundedAttribNumValue(secondary, 0, 0xFFFFFF);
        return rc;
    }

    public int isValidDirBlock(String dir) {
        int rc = this.attribValidator.validateAttribBlock(dir);
        return rc;
    }

    public int isValidRcdLength(String lrecl) {
        int rc = this.attribValidator.validateBoundedAttribNumValue(lrecl, 0, 32760);
        return rc;
    }

    public boolean isValidRcdFormat(String recfm) {
        boolean result = true;
        String[] recfmLstValues = this.getRecfmList();
        result = this.attribValidator.validateListValue(recfm, recfmLstValues);
        return result;
    }

    public int isValidBlockSize(String blksize) {
        int rc = this.attribValidator.validateBoundedAttribNumValue(blksize, 0, 32760);
        return rc;
    }

    public boolean isValidDSType(String dsntype) {
        boolean result = true;
        String[] lstTypeValues = this.getDsnameTypeList();
        result = this.attribValidator.validateListValue(dsntype, lstTypeValues);
        return result;
    }

    public int isValidMultiVolumes(String multvol) {
        int rc = this.attribValidator.validateMultiVol(multvol);
        return rc;
    }

    public String getNamingErrorMessage(int retCode) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidQlfChar;
                break;
            }
            case 2: {
                errMsg = Messages.Mapping_invalidQlfLength;
                break;
            }
            case 3: {
                errMsg = Messages.Mapping_invalidQualifier;
                break;
            }
            case 4: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidDSNameLength, (Object)44);
                break;
            }
            case 5: {
                errMsg = Messages.Mapping_emptyQualifier;
                break;
            }
        }
        return errMsg;
    }

    public String getDSNameErrorMessage(int retCode) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidQlfChar;
                break;
            }
            case 2: {
                errMsg = Messages.Mapping_invalidQlfLength;
                break;
            }
            case 3: {
                errMsg = Messages.Mapping_invalidQualifier;
                break;
            }
            case 4: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidDSNameLength, (Object)44);
                break;
            }
            case 5: {
                errMsg = Messages.Mapping_emptyQualifier;
                break;
            }
            case 6: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidPrfDSNLength, (Object)42);
                break;
            }
            case 7: {
                errMsg = Messages.Mapping_invalidPrfQlfNbr;
                break;
            }
        }
        return errMsg;
    }

    public String getMemberErrorMessage(int retCode) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidMbrChar;
                break;
            }
            case 2: {
                errMsg = Messages.Mapping_invalidMbrLength;
                break;
            }
        }
        return errMsg;
    }

    public String getTempoDSErrorMessage(int retCode) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidChar;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidDSNameLength, (Object)8);
                break;
            }
            case 3: {
                errMsg = Messages.Mapping_invalidTempoName;
                break;
            }
        }
        return errMsg;
    }

    public String getMultiVolErrorMessage(int retCode, String length) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidAlphaNumeric;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidAtrLength, (Object)length);
                break;
            }
            case 3: {
                errMsg = Messages.Mapping_invalidVolNbr;
                break;
            }
        }
        return errMsg;
    }

    public String getGenericUnitErrorMessage(int retCode, String length, String argNum) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidAlphaNumeric;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidAtrLength, (Object)length);
                break;
            }
            case 3: {
                errMsg = Messages.Mapping_invalidArgNumber;
                break;
            }
            case 4: {
                errMsg = Messages.Mapping_invalidVolNbr;
                break;
            }
            case 5: {
                errMsg = Messages.Mapping_invalidNumeric;
                break;
            }
        }
        return errMsg;
    }

    public String getAtrClsErrorMessage(int retCode, String length) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidAlphaNumeric;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_invalidAtrLength, (Object)length);
                break;
            }
        }
        return errMsg;
    }

    public String getAtrQuantErrorMessage(int retCode, String maxBound) {
        return this.getAtrQuantErrorMessage(retCode, "1", maxBound);
    }

    public String getAtrQuantErrorMessage(int retCode, String minBound, String maxBound) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidNumeric;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_outOfBounds, (Object)minBound, (Object)maxBound);
                break;
            }
        }
        return errMsg;
    }

    public String getAtrBlockErrorMessage(int retCode) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidNumeric;
                break;
            }
        }
        return errMsg;
    }

    public String getAtrBlockErrorMessage(int retCode, String min, String max) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidNumeric;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_outOfBounds, (Object)min, (Object)max);
                break;
            }
        }
        return errMsg;
    }

    public MappingException getCVException() {
        return this.cvException;
    }

    public String getSpaceValueErrorMessage() {
        return Messages.Mapping_invalidSpaceValue;
    }

    public String getRcdFormatValueErrorMessage() {
        return Messages.Mapping_invalidRecfmValue;
    }

    public String getDSTypeValueErrorMessage() {
        return Messages.Mapping_invalidDSTypeValue;
    }

    public String getBoundedAtrErrorMessage(int retCode, String minBound, String maxBound) {
        String errMsg = null;
        switch (retCode) {
            case 1: {
                errMsg = Messages.Mapping_invalidNumeric;
                break;
            }
            case 2: {
                errMsg = NLS.bind((String)Messages.Mapping_outOfBounds, (Object)minBound, (Object)maxBound);
                break;
            }
        }
        return errMsg;
    }

    public void crossValidation(HashMap<String, String> datas) throws MappingException {
        int tokenizerIndex;
        String recfm = datas.get("record.format");
        String lrecl = datas.get("record.length");
        String blkSize = datas.get("block.size");
        String dsnType = datas.get("dataset.nametype");
        String dirb = datas.get("directory.blocks");
        String volumes = datas.get("allocation.volumes");
        String volume = datas.get("volume.unit");
        String unit = datas.get("space.units");
        String genUnit = datas.get("generic.unit");
        boolean lreclProperty = MPCharacteristicsUtils.isProperty(lrecl);
        boolean blkSizeProperty = MPCharacteristicsUtils.isProperty(blkSize);
        boolean dirbProperty = MPCharacteristicsUtils.isProperty(dirb);
        boolean volumeProperty = MPCharacteristicsUtils.isProperty(volume);
        boolean genUnitProperty = MPCharacteristicsUtils.isProperty(genUnit);
        String msg = "";
        String field = "";
        if (recfm != null) {
            int length;
            if (!(MappingConstants.RECORD_FORMAT_U.equals(recfm) || MappingConstants.RECORD_FORMAT_UA.equals(recfm) || MappingConstants.RECORD_FORMAT_US.equals(recfm) || lreclProperty)) {
                if (lrecl == null) {
                    field = Messages.Mapping_invalidRcdLength;
                    msg = Messages.Mapping_emptyRcdLength;
                    throw new MappingException(this.getExceptionMsg(field, msg), "record.length");
                }
                if ("0".equals(lrecl)) {
                    field = Messages.Mapping_invalidRcdLength;
                    msg = Messages.Mapping_emptyRcdLength;
                    throw new MappingException(this.getExceptionMsg(field, msg), "record.length");
                }
            }
            if (MappingConstants.RECORD_FORMAT_F.equals(recfm) || MappingConstants.RECORD_FORMAT_FA.equals(recfm) || MappingConstants.RECORD_FORMAT_FM.equals(recfm) || MappingConstants.RECORD_FORMAT_FS.equals(recfm) || MappingConstants.RECORD_FORMAT_FSA.equals(recfm) || MappingConstants.RECORD_FORMAT_FSM.equals(recfm)) {
                if (!(lreclProperty || blkSizeProperty || lrecl == null || blkSize == null || lrecl.equals(blkSize))) {
                    field = Messages.Mapping_invalidBlockSize;
                    msg = Messages.Mapping_nonEqualRcdLength;
                    throw new MappingException(this.getExceptionMsg(field, msg), "block.size");
                }
            } else if (MappingConstants.RECORD_FORMAT_FB.equals(recfm) || MappingConstants.RECORD_FORMAT_FBA.equals(recfm) || MappingConstants.RECORD_FORMAT_FBM.equals(recfm) || MappingConstants.RECORD_FORMAT_FBS.equals(recfm) || MappingConstants.RECORD_FORMAT_FBSA.equals(recfm) || MappingConstants.RECORD_FORMAT_FBSM.equals(recfm)) {
                int block;
                int rest;
                if (!lreclProperty && !blkSizeProperty && lrecl != null && blkSize != null && (length = Integer.parseInt(lrecl)) != 0 && (rest = (block = Integer.parseInt(blkSize)) % length) != 0) {
                    field = Messages.Mapping_invalidBlockSize;
                    msg = Messages.Mapping_nomultiBlockSize;
                    throw new MappingException(this.getExceptionMsg(field, msg), "block.size");
                }
            } else if (recfm.startsWith(MappingConstants.RECORD_FORMAT_V)) {
                if (!lreclProperty && lrecl != null && (length = Integer.parseInt(lrecl)) < 5) {
                    field = Messages.Mapping_invalidRcdLength;
                    msg = Messages.Mapping_lessfourRcdLength;
                    throw new MappingException(this.getExceptionMsg(field, msg), "record.length");
                }
                if (!lreclProperty && !blkSizeProperty && lrecl != null && blkSize != null) {
                    length = Integer.parseInt(lrecl);
                    int block = Integer.parseInt(blkSize);
                    if (block < length + 4) {
                        field = Messages.Mapping_invalidBlockSize;
                        msg = Messages.Mapping_fourmoreBlockSize;
                        throw new MappingException(this.getExceptionMsg(field, msg), "block.size");
                    }
                }
            }
        }
        if ("library".equals(dsnType) && !dirbProperty && dirb != null && !"0".equals(dirb)) {
            field = Messages.Mapping_invalidDirBlock;
            msg = Messages.Mapping_zeroDirBlock;
            throw new MappingException(this.getExceptionMsg(field, msg), "directory.blocks");
        }
        if ("pds".equals(dsnType) && !dirbProperty && (dirb == null || dirb != null && "0".equals(dirb)) && recfm != null && !MappingConstants.RECORD_FORMAT_UNDEFINED.equals(recfm)) {
            field = Messages.Mapping_invalidDirBlock;
            msg = Messages.Mapping_InvalidPdsDirBlock;
            throw new MappingException(this.getExceptionMsg(field, msg), "directory.blocks");
        }
        if (volumes != null) {
            if (!dirbProperty && dirb != null && !"0".equals(dirb)) {
                field = Messages.Mapping_invalidDirBlock;
                msg = Messages.Mapping_zeroDirBlock;
                throw new MappingException(this.getExceptionMsg(field, msg), "directory.blocks");
            }
            if (!volumeProperty && volume != null && !"".equals(volume)) {
                field = Messages.Mapping_invalidVolume;
                msg = Messages.Mapping_nonEmptyVolume;
                throw new MappingException(this.getExceptionMsg(field, msg), "volume.unit");
            }
        }
        if (!volumeProperty && !genUnitProperty && volume != null && genUnit != null && (tokenizerIndex = genUnit.indexOf(44)) != -1 && genUnit.length() > tokenizerIndex + 1) {
            field = Messages.Mapping_invalidVolume;
            msg = Messages.Mapping_mutualExclusionVolume;
            throw new MappingException(this.getExceptionMsg(field, msg), "volume.unit");
        }
        if (recfm == null && "blks".equals(unit) && !blkSizeProperty) {
            if (blkSize == null) {
                field = Messages.Mapping_invalidBlockSize;
                msg = Messages.Mapping_nonNullBlockSize;
                throw new MappingException(this.getExceptionMsg(field, msg), "block.size");
            }
            if ("0".equals(blkSize)) {
                field = Messages.Mapping_invalidBlockSize;
                msg = Messages.Mapping_nonNullBlockSize;
                throw new MappingException(this.getExceptionMsg(field, msg), "block.size");
            }
        }
    }

    public boolean crossValidateDefinition(IDataSetDefinition dsdef) {
        boolean result;
        DatasetAllocation dsa = new DatasetAllocation();
        HashMap<String, String> datas = dsa.getDataSetDefinition(dsdef);
        this.cvException = null;
        try {
            this.crossValidation(datas);
            result = true;
        }
        catch (MappingException e) {
            result = false;
            this.cvException = e;
        }
        return result;
    }

    public void crossValidationTesting(IDataSetDefinition dsdef) throws MappingException {
        DatasetAllocation dsa = new DatasetAllocation();
        HashMap<String, String> datas = dsa.getDataSetDefinition(dsdef);
        this.crossValidation(datas);
    }

    private String getExceptionMsg(String field, String msg) {
        StringBuffer bf = new StringBuffer();
        bf.append(field);
        bf.append(": ");
        bf.append(msg);
        return bf.toString();
    }

    private String[] getRecfmList() {
        return IDataSetDefinition.RECORD_FORMATS;
    }

    private String[] getSpaceUnitList() {
        String[] unitListValues = new String[]{"trks", "cyls", "blks"};
        return unitListValues;
    }

    private String[] getDsnameTypeList() {
        return typeListValues;
    }

    protected static String validateAndSubstituteBuildPropertiesBeforeValidation(String dsName) {
        if (dsName == null || dsName.indexOf(36) == -1) {
            return dsName;
        }
        try {
            return MappingValidation.replaceProperties(dsName, "", "X");
        }
        catch (RuntimeException e) {
            return dsName;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String replaceProperties(String dsName, String sReplaceBuildProperty, String sReplaceEmptyQualifier) {
        sb = new StringBuffer();
        prev = 0;
        v0 = bEmptyQualifier = MappingValidation.validatePDSName(dsName) == false;
        if (!bEmptyQualifier) ** GOTO lbl25
        return dsName;
lbl-1000:
        // 1 sources

        {
            if (pos > 0) {
                sb.append(dsName.substring(prev, pos));
            }
            if (pos == dsName.length() - 1) {
                sb.append("$");
                prev = pos + 1;
                continue;
            }
            if (dsName.charAt(pos + 1) != '{') {
                sb.append(dsName.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            endName = dsName.indexOf(125, pos);
            if (endName < 0 || endName - pos == 2) {
                return dsName;
            }
            sb.append(sReplaceBuildProperty);
            prev = endName + 1;
lbl25:
            // 4 sources

            ** while ((pos = dsName.indexOf((String)"$", (int)prev)) >= 0)
        }
lbl26:
        // 1 sources

        if (prev < dsName.length()) {
            sb.append(dsName.substring(prev));
        }
        if (!MappingValidation.validatePDSName(ret = sb.toString())) {
            ret = MappingValidation.replaceQualifierInPDSName(ret, sReplaceEmptyQualifier);
        }
        return ret;
    }

    protected static String replaceQualifierInPDSName(String mvsName, String sReplaceEmptyQualifier) {
        if (mvsName == null || mvsName.length() == 0) {
            return mvsName;
        }
        String inputStr = mvsName;
        StringBuffer sb = new StringBuffer();
        boolean bDotFound = true;
        char[] cArray = inputStr.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (bDotFound) {
                if (c == '.') {
                    sb.append(sReplaceEmptyQualifier);
                    sb.append('.');
                    bDotFound = true;
                } else {
                    sb.append(c);
                    bDotFound = false;
                }
            } else {
                sb.append(c);
                if (c == '.') {
                    bDotFound = true;
                }
            }
            ++n2;
        }
        if (bDotFound) {
            sb.append(sReplaceEmptyQualifier);
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean validatePDSName(String mvsName) {
        inputStr = mvsName;
        periodIndex = inputStr.indexOf(".");
        lastPeriodIndex = inputStr.lastIndexOf(".");
        if (inputStr.length() == lastPeriodIndex + 1) {
            return false;
        }
        if (periodIndex != 0) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            newPeriodIndex = (inputStr = inputStr.substring(periodIndex + 1)).indexOf(".");
            if (newPeriodIndex == 0) {
                return false;
            }
            periodIndex = newPeriodIndex;
lbl12:
            // 2 sources

            ** while (periodIndex > -1)
        }
lbl13:
        // 1 sources

        return true;
    }

    private static String substituteSystemsymbols(String inputStr) {
        int ampIndex = inputStr.indexOf("&");
        if (ampIndex < 0) {
            return inputStr;
        }
        int rightParenIndex = -1;
        int dotIndex = -1;
        int nextAmpIndex = -1;
        StringBuilder result = new StringBuilder();
        result.append(inputStr.substring(0, ampIndex));
        while (ampIndex > -1) {
            int endOfString = inputStr.length() - 1;
            if (rightParenIndex < ampIndex) {
                rightParenIndex = inputStr.indexOf(41, ampIndex + 1);
            }
            if (dotIndex < ampIndex) {
                dotIndex = inputStr.indexOf(46, ampIndex + 1);
            }
            if (nextAmpIndex <= ampIndex) {
                nextAmpIndex = inputStr.indexOf(38, ampIndex + 1);
            }
            if (dotIndex > ampIndex && dotIndex < endOfString) {
                endOfString = dotIndex;
            }
            if (rightParenIndex > ampIndex && rightParenIndex < endOfString && rightParenIndex + 1 != dotIndex) {
                endOfString = rightParenIndex;
            }
            if (nextAmpIndex > ampIndex && nextAmpIndex - 1 < endOfString) {
                endOfString = nextAmpIndex - 1;
            }
            result.append("X");
            if (endOfString < inputStr.length() - 1) {
                if (nextAmpIndex > -1) {
                    result.append(inputStr.substring(endOfString + 1, nextAmpIndex));
                } else {
                    result.append(inputStr.substring(endOfString + 1, inputStr.length()));
                }
            }
            ampIndex = nextAmpIndex;
        }
        return result.toString();
    }
}

