/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.BuildPropertyTable;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import java.util.HashMap;

public class DatasetAllocation {
    private static final String cls = DatasetAllocation.class.getSimpleName();
    private static final String AllocText = "alloc dsn(";
    private static final String CloseParen = ") ";
    private static final String DispNew = "new";
    private static final String DispShare = "shr";
    private static final String NewCatalog = "new catalog";
    private static final String ModReplace = " ModmustBeReplacedByAnt";
    private final HashMap<String, String> datas = new HashMap();
    private final IDebugger dbg;

    public DatasetAllocation() {
        this((IDebugger)new Debugger(DatasetAllocation.class));
    }

    public DatasetAllocation(IDebugger dbg) {
        this.dbg = dbg;
    }

    public HashMap<String, String> getDataSetDefinition(IDataSetDefinition dsdef) {
        String volumes;
        String additionalParm;
        String blksize;
        String lrecl;
        String recfm;
        String dirb;
        String sQty;
        String pQty;
        String unit;
        String generic;
        String volume;
        String dataCls;
        String mngt;
        String storage;
        String dsName = dsdef.getDsName();
        if (dsName != null && !"".equals(dsName)) {
            this.datas.put("name.pds", dsName);
        }
        if ((storage = dsdef.getStorageClass()) != null && !"".equals(storage)) {
            this.datas.put("storage.class", storage);
        }
        if ((mngt = dsdef.getManagementClass()) != null && !"".equals(mngt)) {
            this.datas.put("management.class", mngt);
        }
        if ((dataCls = dsdef.getDataClass()) != null && !"".equals(dataCls)) {
            this.datas.put("data.class", dataCls);
        }
        if ((volume = dsdef.getVolumeSerial()) != null && !"".equals(volume)) {
            this.datas.put("volume.unit", volume);
        }
        if ((generic = dsdef.getGenericUnit()) != null && !"".equals(generic)) {
            this.datas.put("generic.unit", generic);
        }
        if ((unit = dsdef.getSpaceUnits()) != null && !"".equals(unit)) {
            this.datas.put("space.units", unit);
        }
        if ((pQty = dsdef.getPrimaryQuantity()) != null && !"".equals(pQty)) {
            this.datas.put("primary.quantity", pQty);
        }
        if ((sQty = dsdef.getSecondaryQuantity()) != null && !"".equals(sQty)) {
            this.datas.put("secondary.quantity", sQty);
        }
        if ((dirb = dsdef.getDirectoryBlocks()) != null && !"".equals(dirb)) {
            this.datas.put("directory.blocks", dirb);
        }
        if ((recfm = dsdef.getRecordFormat()) != null && !"".equals(recfm)) {
            this.datas.put("record.format", recfm);
        }
        if ((lrecl = dsdef.getRecordLength()) != null && !"".equals(lrecl)) {
            this.datas.put("record.length", lrecl);
        }
        if ((blksize = dsdef.getBlockSize()) != null && !"".equals(blksize)) {
            this.datas.put("block.size", blksize);
        }
        if ((additionalParm = dsdef.getAdditionalParm()) != null) {
            this.datas.put("additional.parameters", additionalParm);
        }
        if ((volumes = dsdef.getAllocationMultipleVolumes()) != null && !"".equals(volumes)) {
            this.datas.put("allocation.volumes", volumes);
        }
        int type = dsdef.getDsType();
        String dsnType = "undefined";
        if (type == 0) {
            dsnType = "library";
        } else if (type == 1) {
            dsnType = "seq";
        } else if (type == 2) {
            dsnType = "vsam";
        } else if (type == 3) {
            dsnType = "pds";
        } else if (type == 4) {
            dsnType = "library,1";
        } else if (type == 5) {
            dsnType = "library,2";
        }
        this.datas.put("dataset.nametype", dsnType);
        String usageType = String.valueOf(dsdef.getUsageType());
        this.datas.put("usage.type", usageType);
        return this.datas;
    }

    public String generateAllocCmdFromDef(IDataSetDefinition dsdef) {
        return this.generateAllocCmdFromDef(dsdef, false);
    }

    public String generateAllocCmdFromDef(IDataSetDefinition dsdef, boolean isMod) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        HashMap<String, String> attributes = this.getDataSetDefinition(dsdef);
        int usage = dsdef.getUsageType();
        String cmd = "";
        if (usage == 1) {
            cmd = this.generateAllocCmd(this.datas, isMod);
        } else if (usage == 2) {
            cmd = this.generateTemporaryAllocCmd(attributes, isMod);
        }
        String result = cmd.toString();
        if (result.contains("${")) {
            result = BuildPropertyTable.getInstance().replaceProperties(cmd.toString());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }

    public String generateAllocCmd(HashMap<String, String> attribs) {
        return this.generateAllocCmd(attribs, false);
    }

    public String generateAllocCmd(HashMap<String, String> attribs, boolean isMod) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String dsName = attribs.get("name.pds");
        StringBuffer cmd = new StringBuffer();
        cmd.append(AllocText);
        cmd.append(dsName);
        cmd.append(CloseParen);
        this.appendArguments(attribs, cmd);
        if (isMod) {
            cmd.append(ModReplace);
        } else {
            cmd.append(NewCatalog);
        }
        String result = cmd.toString();
        if (result.contains("${")) {
            result = BuildPropertyTable.getInstance().replaceProperties(cmd.toString());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }

    public String generateAllocDDNameCmd(String ddName, HashMap<String, String> attribs, boolean isNew) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String dsName = attribs.get("name.pds");
        String allocTxt = "alloc fi(" + ddName + ") da(";
        StringBuffer cmd = new StringBuffer();
        cmd.append(allocTxt);
        cmd.append(dsName);
        cmd.append(CloseParen);
        if (isNew) {
            this.appendArguments(attribs, cmd);
            cmd.append(NewCatalog);
        } else {
            cmd.append(DispShare);
        }
        String result = cmd.toString();
        if (result.contains("${")) {
            result = BuildPropertyTable.getInstance().replaceProperties(cmd.toString());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }

    public String generateTemporaryAllocCmd(HashMap<String, String> attribs, boolean isMod) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String dsName = attribs.get("name.pds");
        StringBuffer cmd = new StringBuffer();
        if (dsName != null) {
            cmd.append("da(");
            cmd.append(dsName);
            cmd.append(CloseParen);
        }
        this.appendArguments(attribs, cmd);
        if (isMod) {
            cmd.append(ModReplace);
        } else {
            cmd.append(DispNew);
        }
        String result = cmd.toString();
        if (result.contains("${")) {
            result = BuildPropertyTable.getInstance().replaceProperties(cmd.toString());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }

    private void appendArguments(HashMap<String, String> attribs, StringBuffer cmd) {
        String additionalparm;
        String dataCls;
        String mngt;
        String storage;
        String recfm;
        String type;
        String lrecl;
        String blkSize;
        String generic;
        String volumes;
        String unit;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if ("cyls".equals(unit = attribs.get("space.units"))) {
            String cylTxt = "cyl ";
            cmd.append("cyl ");
        } else if ("trks".equals(unit)) {
            String trkTxt = "tracks ";
            cmd.append("tracks ");
        }
        String dirb = attribs.get("directory.blocks");
        if (dirb != null && !"0".equals(dirb)) {
            cmd.append("dir(");
            cmd.append(dirb);
            cmd.append(CloseParen);
        }
        String pQty = attribs.get("primary.quantity");
        cmd.append("space(");
        cmd.append(pQty);
        String sQty = attribs.get("secondary.quantity");
        if (sQty != null && !"0".endsWith(sQty)) {
            cmd.append(",");
            cmd.append(sQty);
        }
        cmd.append(CloseParen);
        String volume = attribs.get("volume.unit");
        if (volume != null && !"".equals(volume)) {
            cmd.append("vol(");
            cmd.append(volume);
            cmd.append(CloseParen);
        }
        if ((volumes = attribs.get("allocation.volumes")) != null && !"".equals(volumes)) {
            String[] vols = volumes.split(",");
            cmd.append("vol(");
            int i = 0;
            while (i < vols.length) {
                cmd.append(vols[i]);
                if (i < vols.length - 1) {
                    cmd.append(",");
                }
                ++i;
            }
            cmd.append(CloseParen);
        }
        if ((generic = attribs.get("generic.unit")) != null && !"".equals(generic)) {
            boolean ignoreGenericUnit;
            String maxVolValue = "";
            String unitValue = "";
            int commaIndex = generic.indexOf(44);
            if (commaIndex != -1) {
                unitValue = generic.substring(0, commaIndex);
                maxVolValue = generic.substring(commaIndex + 1, generic.length()).trim();
            } else {
                unitValue = generic;
            }
            boolean bl = ignoreGenericUnit = unitValue.equalsIgnoreCase("vio") && "library".equals(attribs.get("dataset.nametype"));
            if (!ignoreGenericUnit) {
                cmd.append("unit(");
                cmd.append(unitValue);
                cmd.append(CloseParen);
                if (!maxVolValue.equalsIgnoreCase("")) {
                    cmd.append("maxvol(");
                    cmd.append(maxVolValue);
                    cmd.append(CloseParen);
                }
            }
        }
        if ((blkSize = attribs.get("block.size")) != null && !"0".equals(blkSize)) {
            cmd.append("blksize(");
            cmd.append(blkSize);
            cmd.append(CloseParen);
        }
        if ((lrecl = attribs.get("record.length")) != null && !"0".equals(lrecl)) {
            cmd.append("lrecl(");
            cmd.append(lrecl);
            cmd.append(CloseParen);
        }
        if ((type = attribs.get("dataset.nametype")) != null && !"".equals(type)) {
            if ("library".equals(type) || "pds".equals(type)) {
                cmd.append("dsorg(PO) ");
            } else {
                cmd.append("dsorg(PS) ");
            }
        }
        if ((recfm = attribs.get("record.format")) != null && !"".equals(recfm)) {
            int length = recfm.length();
            StringBuffer bf = new StringBuffer();
            int i = 0;
            while (i < length) {
                char ch = recfm.charAt(i);
                bf.append(ch);
                if (i < length - 1) {
                    bf.append(",");
                }
                ++i;
            }
            cmd.append("recfm(");
            cmd.append(bf.toString());
            cmd.append(CloseParen);
        }
        if ((storage = attribs.get("storage.class")) != null && !"".equals(storage)) {
            cmd.append("storclas(");
            cmd.append(storage);
            cmd.append(CloseParen);
        }
        if ((mngt = attribs.get("management.class")) != null && !"".equals(mngt)) {
            cmd.append("mgmtclas(");
            cmd.append(mngt);
            cmd.append(CloseParen);
        }
        if ((dataCls = attribs.get("data.class")) != null && !"".equals(dataCls)) {
            cmd.append("dataclas(");
            cmd.append(dataCls);
            cmd.append(CloseParen);
        }
        if ("library".equals(type) || "pds".equals(type)) {
            cmd.append("dsntype(");
            cmd.append(type);
            cmd.append(CloseParen);
        }
        if ((additionalparm = attribs.get("additional.parameters")) != null) {
            cmd.append(additionalparm);
            cmd.append(" ");
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    public String generateFreeCmdFromDef(String dsname) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String cmd = "";
        StringBuffer bfCmd = new StringBuffer();
        String endWithBkt = ")";
        String startTxt = "free dsn(";
        bfCmd.append("free dsn(");
        bfCmd.append(dsname);
        bfCmd.append(")");
        cmd = bfCmd.toString();
        String result = cmd.toString();
        if (result.contains("${")) {
            result = BuildPropertyTable.getInstance().replaceProperties(cmd.toString());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }

    public String generateFreeDDNameCmdFromDef(String ddname) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String cmd = "";
        StringBuffer bfCmd = new StringBuffer();
        String endWithBkt = ")";
        String startTxt = "free fi(";
        bfCmd.append("free fi(");
        bfCmd.append(ddname);
        bfCmd.append(")");
        cmd = bfCmd.toString();
        String result = cmd.toString();
        if (result.contains("${")) {
            result = BuildPropertyTable.getInstance().replaceProperties(cmd.toString());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }
}

