/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent;

import com.ibm.jzos.ZUtil;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.MappingException;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.DatasetAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.nls.Messages;
import java.util.HashMap;

public class AgentMapping {
    private static final String cls = AgentMapping.class.getSimpleName();
    private static final boolean ZOS_ENVIRONMENT = "z/OS".equals(System.getProperty("os.name"));
    private static final boolean ZOS_SIMULATION = System.getProperty("scmee.simulate") != null;
    private final MappingValidation vld = new MappingValidation();
    private final IDebugger dbg;
    private String vDSName;

    public AgentMapping() {
        this((IDebugger)new Debugger(AgentMapping.class));
    }

    public AgentMapping(IDebugger dbg) {
        this.dbg = dbg;
    }

    public HashMap<String, String> allParamValidation(HashMap<String, String> attribs) throws MappingException {
        String type;
        String dataCls;
        String mngt;
        String storage;
        String recfm;
        String lrecl;
        String blkSize;
        String generic;
        String volumes;
        String volume;
        String sQty;
        String pQty;
        String dir;
        String unit;
        String dsName;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if ((dsName = attribs.get("name.pds")) != null) {
            String usageType = attribs.get("usage.type");
            boolean isTemporary = false;
            boolean isPropertyAllowed = false;
            boolean isPrefixed = false;
            if (usageType != null) {
                isTemporary = Integer.parseInt(usageType) == 2;
                isPropertyAllowed = Integer.parseInt(usageType) == 3 || Integer.parseInt(usageType) == 1;
                isPrefixed = Integer.parseInt(usageType) == 0;
            }
            dsName = this.substituteSystemSymbols(dsName);
            this.validateDataSetName(dsName, isTemporary, isPrefixed, isPropertyAllowed);
        }
        if ((unit = attribs.get("space.units")) != null) {
            this.validateSpaceUnit(unit);
        }
        if ((dir = attribs.get("directory.blocks")) != null) {
            this.validateDirBlock(dir);
        }
        if ((pQty = attribs.get("primary.quantity")) != null) {
            this.validatePrimary(pQty);
        }
        if ((sQty = attribs.get("secondary.quantity")) != null) {
            this.validateSecondary(sQty);
        }
        if ((volume = attribs.get("volume.unit")) != null) {
            this.validateOneVolume(volume);
        }
        if ((volumes = attribs.get("allocation.volumes")) != null) {
            this.validateMultiVolumes(volumes);
        }
        if ((generic = attribs.get("generic.unit")) != null) {
            this.validateGenericUnit(generic);
        }
        if ((blkSize = attribs.get("block.size")) != null) {
            this.validateBlkSize(blkSize);
        }
        if ((lrecl = attribs.get("record.length")) != null) {
            this.validateLrecl(lrecl);
        }
        if ((recfm = attribs.get("record.format")) != null) {
            this.validateRecfm(recfm);
            String value = recfm.replaceAll(",", "");
            attribs.put("record.format", value);
        }
        if ((storage = attribs.get("storage.class")) != null && !"".equals(storage)) {
            this.validateStorage(storage);
        }
        if ((mngt = attribs.get("management.class")) != null && !"".equals(mngt)) {
            this.validateManagement(mngt);
        }
        if ((dataCls = attribs.get("data.class")) != null && !"".equals(dataCls)) {
            this.validateDataCls(dataCls);
        }
        if ((type = attribs.get("dataset.nametype")) != null) {
            this.validateDSType(type);
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        return attribs;
    }

    public String pdsMapping(IDataSetDefinition dsdef, String prefix) throws MappingException {
        return this.pdsMapping(dsdef, prefix, true);
    }

    public String pdsMapping(IDataSetDefinition dsdef, String prefix, boolean performCrossValidation) throws MappingException {
        String allocCmd;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName()});
        }
        DatasetAllocation dsa = new DatasetAllocation(this.dbg);
        boolean isPrefix = dsdef.isPrefixDSN();
        HashMap<String, String> datas = dsa.getDataSetDefinition(dsdef);
        String folderName = datas.get("name.pds");
        String fullDSName = "";
        if (isPrefix) {
            StringBuffer bf = new StringBuffer();
            bf.append(prefix);
            bf.append(".");
            bf.append(folderName);
            fullDSName = bf.toString();
            datas.put("name.pds", fullDSName);
        } else {
            fullDSName = folderName;
        }
        fullDSName = this.substituteSystemSymbols(fullDSName);
        this.setDSName(fullDSName);
        try {
            datas = this.allParamValidation(datas);
            if (performCrossValidation) {
                this.vld.crossValidation(datas);
            }
        }
        catch (MappingException me) {
            if (this.dbg.isDebug()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), me.getLocalizedMessage()});
            }
            throw me;
        }
        String fullCmd = "";
        try {
            allocCmd = dsa.generateAllocCmd(datas, false);
        }
        catch (Exception e) {
            if (this.dbg.isDebug()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), e.getLocalizedMessage()});
            }
            if (this.dbg.isError()) {
                Debug.error((IDebugger)this.dbg, (Throwable)e, (String[])new String[]{cls, mnm, dsdef.getDsName()});
            }
            throw e;
        }
        catch (Throwable e) {
            if (this.dbg.isDebug()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), e.getLocalizedMessage()});
            }
            if (this.dbg.isError()) {
                Debug.error((IDebugger)this.dbg, (Throwable)e, (String[])new String[]{cls, mnm, dsdef.getDsName()});
            }
            throw e;
        }
        if (isPrefix) {
            String part1 = allocCmd.substring(0, 10);
            int indice = allocCmd.indexOf(")");
            String part2 = allocCmd.substring(indice);
            StringBuffer bf = new StringBuffer();
            bf.append(part1);
            bf.append(fullDSName);
            bf.append(part2);
            fullCmd = bf.toString();
        } else {
            fullCmd = allocCmd;
        }
        fullCmd = fullCmd.toLowerCase();
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), fullCmd});
        }
        return fullCmd;
    }

    public String pdsMappingDDName(String ddName, IDataSetDefinition dsdef, String prefix, boolean bNew) throws MappingException {
        String allocCmd;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName()});
        }
        DatasetAllocation dsa = new DatasetAllocation(this.dbg);
        boolean isPrefix = dsdef.isPrefixDSN();
        this.validateDDName(ddName);
        HashMap<String, String> datas = dsa.getDataSetDefinition(dsdef);
        String folderName = datas.get("name.pds");
        String fullDSName = "";
        if (isPrefix) {
            StringBuffer bf = new StringBuffer();
            bf.append(prefix);
            bf.append(".");
            bf.append(folderName);
            fullDSName = bf.toString();
            datas.put("name.pds", fullDSName);
        } else {
            fullDSName = folderName;
        }
        fullDSName = this.substituteSystemSymbols(fullDSName);
        this.setDSName(fullDSName);
        try {
            datas = this.allParamValidation(datas);
            this.vld.crossValidation(datas);
        }
        catch (MappingException me) {
            if (this.dbg.isDebug()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), me.getLocalizedMessage()});
            }
            throw me;
        }
        String fullCmd = "";
        try {
            allocCmd = dsa.generateAllocDDNameCmd(ddName, datas, bNew);
        }
        catch (Exception e) {
            if (this.dbg.isDebug()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), e.getLocalizedMessage()});
            }
            if (this.dbg.isError()) {
                Debug.error((IDebugger)this.dbg, (Throwable)e, (String[])new String[]{cls, mnm, dsdef.getDsName()});
            }
            throw e;
        }
        catch (Throwable e) {
            if (this.dbg.isDebug()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), e.getLocalizedMessage()});
            }
            if (this.dbg.isError()) {
                Debug.error((IDebugger)this.dbg, (Throwable)e, (String[])new String[]{cls, mnm, dsdef.getDsName()});
            }
            throw e;
        }
        if (isPrefix) {
            int ind = ("alloc fi(" + ddName + ") da(").length();
            String part1 = allocCmd.substring(0, ind);
            int indice = allocCmd.indexOf(")", ind);
            String part2 = allocCmd.substring(indice);
            StringBuffer bf = new StringBuffer();
            bf.append(part1);
            bf.append(fullDSName);
            bf.append(part2);
            fullCmd = bf.toString();
        } else {
            fullCmd = allocCmd;
        }
        fullCmd = fullCmd.toLowerCase();
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, dsdef.getDsName(), fullCmd});
        }
        return fullCmd;
    }

    public String pdsFree() throws MappingException {
        DatasetAllocation dsa = new DatasetAllocation();
        String freeCmd = dsa.generateFreeCmdFromDef(this.getDSName());
        String fullCmd = freeCmd.toLowerCase();
        return fullCmd;
    }

    public MappingValidation getVld() {
        return this.vld;
    }

    public void setDSName(String name) {
        this.vDSName = name;
    }

    public String getDSName() {
        return this.vDSName;
    }

    private String getExceptionMsg(String header, String foot) {
        StringBuffer bf = new StringBuffer();
        bf.append(header);
        bf.append(": ");
        bf.append(foot);
        return bf.toString();
    }

    private void validateDataSetName(String dsName, boolean isTemporary, boolean isPrefixed, boolean isPropertyAllowed) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidDSName(dsName, isTemporary, isPrefixed, isPropertyAllowed);
        if (rc > 0) {
            field = Messages.Mapping_invalidDataSetName;
            msg = isTemporary ? this.vld.getTempoDSErrorMessage(rc) : this.vld.getNamingErrorMessage(rc);
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateDDName(String ddName) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidDDName(ddName);
        if (rc > 0) {
            field = Messages.Mapping_invalidDDName;
            msg = this.vld.getNamingErrorMessage(rc);
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateDirBlock(String dir) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidDirBlock(dir);
        if (rc != 0) {
            field = Messages.Mapping_invalidDirBlock;
            msg = this.vld.getAtrBlockErrorMessage(rc);
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validatePrimary(String pQty) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidPrimary(pQty);
        if (rc != 0) {
            field = Messages.Mapping_invalidPrimaryQty;
            msg = this.vld.getAtrQuantErrorMessage(rc, "16777215");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateSecondary(String sQty) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidSecondary(sQty);
        if (rc != 0) {
            field = Messages.Mapping_invalidSecondaryQty;
            msg = this.vld.getBoundedAtrErrorMessage(rc, "0", "16777215");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateOneVolume(String volume) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidVolumeSerial(volume);
        if (rc != 0) {
            field = Messages.Mapping_invalidVolume;
            msg = this.vld.getAtrClsErrorMessage(rc, "6");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateMultiVolumes(String volumes) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidMultiVolumes(volumes);
        if (rc != 0) {
            field = Messages.Mapping_invalidMultiVolumes;
            msg = this.vld.getMultiVolErrorMessage(rc, "8");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateGenericUnit(String generic) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidGenericUnit(generic);
        if (rc != 0) {
            field = Messages.Mapping_invalidGenericUnit;
            msg = this.vld.getAtrClsErrorMessage(rc, "8");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateBlkSize(String blkSize) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidBlockSize(blkSize);
        if (rc != 0) {
            field = Messages.Mapping_invalidBlockSize;
            msg = this.vld.getAtrBlockErrorMessage(rc);
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateLrecl(String lrecl) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidRcdLength(lrecl);
        if (rc != 0) {
            field = Messages.Mapping_invalidRcdLength;
            msg = this.vld.getBoundedAtrErrorMessage(rc, "0", "32760");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateStorage(String storage) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidStorageClass(storage);
        if (rc != 0) {
            field = Messages.Mapping_invalidStorageClass;
            msg = this.vld.getAtrClsErrorMessage(rc, "8");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateManagement(String mgtCls) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidMngtClass(mgtCls);
        if (rc != 0) {
            field = Messages.Mapping_invalidManagementClass;
            msg = this.vld.getAtrClsErrorMessage(rc, "8");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateDataCls(String dataCls) throws MappingException {
        String msg = "";
        String field = "";
        int rc = this.vld.isValidDataClass(dataCls);
        if (rc != 0) {
            field = Messages.Mapping_invalidDataClass;
            msg = this.vld.getAtrClsErrorMessage(rc, "8");
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateSpaceUnit(String unit) throws MappingException {
        String msg = "";
        String field = "";
        boolean result = this.vld.isValidSpaceUnit(unit);
        if (!result) {
            field = Messages.Mapping_invalidSpaceUnit;
            msg = this.vld.getSpaceValueErrorMessage();
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateRecfm(String recfm) throws MappingException {
        String msg = "";
        String field = "";
        boolean result = this.vld.isValidRcdFormat(recfm);
        if (!result) {
            field = Messages.Mapping_invalidRcdFormat;
            msg = this.vld.getRcdFormatValueErrorMessage();
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private void validateDSType(String type) throws MappingException {
        String msg = "";
        String field = "";
        boolean result = this.vld.isValidDSType(type);
        if (!result) {
            field = Messages.Mapping_invalidDSNType;
            msg = this.vld.getDSTypeValueErrorMessage();
            throw new MappingException(this.getExceptionMsg(field, msg));
        }
    }

    private String substituteSystemSymbols(String s) {
        String ss;
        if (ZOS_ENVIRONMENT && !ZOS_SIMULATION && s != null && !s.isEmpty() && s.indexOf(38) != -1 && (ss = ZUtil.substituteSystemSymbols((String)s)) != null && !ss.isEmpty()) {
            return ss;
        }
        return s;
    }
}

