/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.mapping;

import java.util.StringTokenizer;

public class MPNameValidationUtil {
    private static final String UC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LC = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUMBERS = "0123456789";
    private static final String Member1st = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String MemberRest = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static MPNameValidationUtil instance = null;

    public static MPNameValidationUtil getInstance() {
        if (instance == null) {
            instance = new MPNameValidationUtil();
        }
        return instance;
    }

    public int validateDataSetName(String testString) {
        return this.validateDataSetName(testString, "#@$-");
    }

    public int validateDataSetName(String testString, String codeVariants) {
        boolean result1 = true;
        boolean result2 = true;
        boolean result3 = true;
        boolean result4 = true;
        boolean result5 = true;
        String curTextStr = testString;
        int rc = 0;
        result5 = this.validatePDSName(curTextStr);
        if (!result5) {
            rc = 5;
        } else {
            if (codeVariants != null) {
                result2 = this.validateMvsChars(curTextStr, codeVariants, false);
            }
            if (!result2) {
                rc = 1;
            } else {
                result1 = this.validateMvsNames(curTextStr);
                if (!result1) {
                    rc = 2;
                } else {
                    result3 = this.validateMvsQualifiers(curTextStr);
                    if (!result3) {
                        rc = 3;
                    } else {
                        result4 = this.validatePdsNameLength(curTextStr);
                        if (!result4) {
                            rc = 4;
                        }
                    }
                }
            }
        }
        return rc;
    }

    public int validateDataSetName(String testString, boolean isPrefix) {
        boolean result1 = true;
        boolean result2 = true;
        boolean result3 = true;
        boolean result4 = true;
        boolean result5 = true;
        boolean result6 = true;
        boolean result7 = true;
        String codeVariants = "#@$-";
        String curTextStr = testString;
        int rc = 0;
        result5 = this.validatePDSName(curTextStr);
        if (!result5) {
            rc = 5;
        } else {
            result2 = this.validateMvsChars(curTextStr, "#@$-", false);
            if (!result2) {
                rc = 1;
            } else {
                result1 = this.validateMvsNames(curTextStr);
                if (!result1) {
                    rc = 2;
                } else {
                    result3 = this.validateMvsQualifiers(curTextStr);
                    if (!result3) {
                        rc = 3;
                    } else {
                        result4 = this.validatePdsNameLength(curTextStr);
                        if (!result4) {
                            rc = 4;
                        } else {
                            result6 = this.validatePdsNameLength(curTextStr, isPrefix);
                            if (!result6) {
                                rc = 6;
                            } else {
                                result7 = this.validateNbrQualifiers(curTextStr, isPrefix);
                                if (!result7) {
                                    rc = 7;
                                }
                            }
                        }
                    }
                }
            }
        }
        return rc;
    }

    public boolean validateMvsNames(String mvsName) {
        StringTokenizer nameTokens = new StringTokenizer(mvsName, ".");
        while (nameTokens.hasMoreTokens()) {
            String token = nameTokens.nextToken();
            if (token.length() >= 1 && token.length() <= 8) continue;
            return false;
        }
        return true;
    }

    public boolean validateMvsQualifiers(String mvsName) {
        StringTokenizer nameTokens = new StringTokenizer(mvsName, ".");
        while (nameTokens.hasMoreTokens()) {
            String token = nameTokens.nextToken();
            char ch = token.charAt(0);
            if (NUMBERS.indexOf(ch) > -1) {
                return false;
            }
            int hyphenIndex = token.indexOf("-");
            if (hyphenIndex != 0) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean validatePDSName(String mvsName) {
        inputStr = mvsName;
        periodIndex = inputStr.indexOf(".");
        lastPeriodIndex = inputStr.lastIndexOf(".");
        if (inputStr.length() == lastPeriodIndex + 1) {
            return false;
        }
        if (periodIndex != 0) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            newPeriodIndex = (inputStr = inputStr.substring(periodIndex + 1)).indexOf(".");
            if (newPeriodIndex == 0) {
                return false;
            }
            periodIndex = newPeriodIndex;
lbl12:
            // 2 sources

            ** while (periodIndex > -1)
        }
lbl13:
        // 1 sources

        return true;
    }

    public boolean validateNbrQualifiers(String dsname, boolean isPrefix) {
        boolean result = true;
        String inputStr = dsname;
        int periodIndex = inputStr.indexOf(".");
        if (!isPrefix && periodIndex == -1 && !"NULLFILE".equals(dsname)) {
            result = false;
        }
        return result;
    }

    private boolean validatePdsNameLength(String pdsName) {
        boolean result = true;
        if (pdsName.length() > 44) {
            result = false;
        }
        return result;
    }

    private boolean validatePdsNameLength(String pdsName, boolean isPrefix) {
        boolean result = true;
        if (isPrefix && pdsName.length() > 42) {
            result = false;
        }
        return result;
    }

    public boolean validateMvsChars(String testString, String codeVariants, boolean sysWizard) {
        boolean flag = false;
        int length = testString.length();
        int i = 0;
        while (i < length) {
            char ch = testString.charAt(i);
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(ch) > -1 || LC.indexOf(ch) > -1) {
                flag = true;
            } else if (NUMBERS.indexOf(ch) > -1) {
                if (i == 0) {
                    return false;
                }
                flag = true;
            } else if (codeVariants == null || codeVariants.indexOf(ch) > -1) {
                flag = true;
            } else {
                switch (ch) {
                    case '.': {
                        if (i == 0) {
                            return false;
                        }
                        flag = true;
                        break;
                    }
                    case ' ': {
                        flag = false;
                        return false;
                    }
                    case '<': {
                        if (sysWizard) {
                            flag = true;
                            break;
                        }
                        return false;
                    }
                    case '>': {
                        if (sysWizard) {
                            flag = true;
                            break;
                        }
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++i;
        }
        return flag;
    }

    public boolean validateMemberChars(String mbrName, String nationals) {
        String valid = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + nationals;
        String other = MemberRest + nationals;
        String value = mbrName.toUpperCase();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (valid.indexOf(ch) == -1) {
                return false;
            }
            valid = other;
            ++i;
        }
        return true;
    }

    public int validateMemberName(String mbrName) {
        return this.validateMemberName(mbrName, "@$#");
    }

    public int validateMemberName(String mbrName, String nationals) {
        int rc = 0;
        if (!this.validateMemberChars(mbrName, nationals)) {
            rc = 1;
        } else if (mbrName.length() > 8) {
            rc = 2;
        }
        return rc;
    }

    public int validateTempoDSName(String tempoName) {
        int rc1 = 0;
        boolean result1 = true;
        String codeVariants = "#@$";
        boolean isAmpersand = tempoName.startsWith("&&");
        String extractName = "";
        if (isAmpersand) {
            extractName = tempoName.substring(2);
            result1 = this.validateMemberChars(extractName, "#@$");
            if (!result1) {
                rc1 = 1;
            } else if (extractName.length() > 8) {
                rc1 = 2;
            }
        } else if (!"".equals(tempoName)) {
            rc1 = 3;
        }
        return rc1;
    }
}

