/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.mapping;

import java.util.StringTokenizer;

public class MPCharacteristicsUtils {
    private static final String UC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LC = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUMBERS = "0123456789";
    private static final String BUILD_PROPERTY_START = "${";
    private static final String BUILD_PROPERTY_END = "}";
    private String fLenientCodeVariants;

    public String getLenientCodeVariants() {
        return this.fLenientCodeVariants;
    }

    public int validateAttribClass(String value, int length) {
        if (value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END)) {
            return 0;
        }
        int rc = 0;
        boolean result1 = true;
        boolean result2 = true;
        result1 = MPCharacteristicsUtils.isAlphaOrNumeric(value, true, true);
        if (!result1) {
            rc = 1;
        } else {
            result2 = this.validateAttrLength(value, length);
            if (!result2) {
                rc = 2;
            }
        }
        return rc;
    }

    public int validateGenericUnits(String value) {
        if (value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END)) {
            return 0;
        }
        StringTokenizer genericTokens = new StringTokenizer(value, ",");
        int numTokens = genericTokens.countTokens();
        if (numTokens > 2 || value.endsWith(",")) {
            return 3;
        }
        String firstParm = genericTokens.nextToken();
        String secondParm = numTokens == 2 ? genericTokens.nextToken().trim() : null;
        int rc = this.validateAttribClass(firstParm, 8);
        if (rc != 0) {
            return rc;
        }
        if (secondParm != null) {
            int secondParmRC = this.validateAttribQuant(secondParm, 59);
            if (secondParmRC == 1) {
                return 5;
            }
            if (secondParmRC == 2) {
                return 4;
            }
        }
        return rc;
    }

    public int validateAttribQuant(String value, int maximum) {
        if (value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END)) {
            return 0;
        }
        int rc = 0;
        boolean result1 = true;
        boolean result2 = true;
        result1 = MPCharacteristicsUtils.isAlphaOrNumeric(value, false, true);
        if (!result1) {
            rc = 1;
        } else {
            result2 = "".equals(value) ? false : this.validateAttrMaxValue(value, maximum);
            if (!result2) {
                rc = 2;
            }
        }
        return rc;
    }

    public int validateBoundedAttribNumValue(String value, int minimum, int maximum) {
        if (value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END)) {
            return 0;
        }
        int rc = 0;
        boolean result1 = true;
        boolean result2 = true;
        if (!"".equals(value)) {
            result1 = MPCharacteristicsUtils.isAlphaOrNumeric(value, false, true);
            if (!result1) {
                rc = 1;
            } else {
                result2 = this.validateAttrMinMaxValue(value, minimum, maximum);
                if (!result2) {
                    rc = 2;
                }
            }
        }
        return rc;
    }

    public int validateAttribBlock(String value) {
        if (value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END)) {
            return 0;
        }
        int rc = 0;
        boolean result1 = true;
        result1 = MPCharacteristicsUtils.isAlphaOrNumeric(value, false, true);
        if (!result1) {
            rc = 1;
        }
        return rc;
    }

    public boolean validateListValue(String value, String[] liste) {
        String[] listvalues = liste;
        return this.validateValue(listvalues, value);
    }

    /*
     * Unable to fully structure code
     */
    public int validateMultiVol(String value) {
        if (value.startsWith("${") && value.endsWith("}")) {
            return 0;
        }
        rc = 0;
        volumeTokens = new StringTokenizer(value, ",");
        if (volumeTokens.countTokens() <= 59) ** GOTO lbl12
        rc = 3;
        return rc;
lbl-1000:
        // 1 sources

        {
            token = volumeTokens.nextToken().trim();
            rc = this.validateAttribClass(token, 6);
            if (rc == 0) continue;
            return rc;
lbl12:
            // 2 sources

            ** while (volumeTokens.hasMoreTokens())
        }
lbl13:
        // 1 sources

        return rc;
    }

    public static boolean isAlphaOrNumeric(String value, boolean alphaAllowed, boolean numericAllowed) {
        if (value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END)) {
            return true;
        }
        boolean rc = true;
        int i = -1;
        int length = value.length();
        i = 0;
        while (i < length) {
            char ch = value.charAt(i);
            if (UC.indexOf(ch) > -1 || LC.indexOf(ch) > -1) {
                if (!alphaAllowed) {
                    return false;
                }
            } else if (NUMBERS.indexOf(ch) > -1) {
                if (!numericAllowed) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return rc;
    }

    public static boolean isProperty(String value) {
        return value != null && value.startsWith(BUILD_PROPERTY_START) && value.endsWith(BUILD_PROPERTY_END);
    }

    private boolean validateAttrLength(String testString, int maxLength) {
        boolean result = true;
        if (testString.length() < 1 || testString.length() > maxLength) {
            result = false;
        }
        return result;
    }

    private boolean validateAttrMaxValue(String testString, int maxValue) {
        boolean result = true;
        int i = Integer.parseInt(testString);
        if (i < 1 || i > maxValue) {
            result = false;
        }
        return result;
    }

    private boolean validateAttrMinMaxValue(String testString, int minValue, int maxValue) {
        boolean result = true;
        int i = Integer.parseInt(testString);
        if (i < minValue || i > maxValue) {
            result = false;
        }
        return result;
    }

    private boolean validateValue(String[] listvalues, String attrvalue) {
        boolean result = false;
        int i = 0;
        while (i < listvalues.length) {
            if (attrvalue.equals(listvalues[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }
}

