/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.enterprise.systemdefinition.common.AbstractTranslator;
import com.ibm.team.enterprise.systemdefinition.common.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.HFSOutput;
import com.ibm.team.enterprise.zos.systemdefinition.common.IConcatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.IZosTranslator;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.Concatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.DDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.DataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.util.ZosTranslatorUtil;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class ZosTranslator
extends AbstractTranslator
implements IZosTranslator {
    private int callMethod = 0;
    private String commandMember = "";
    private final List<IConcatenation> concatenations = new ArrayList<IConcatenation>();
    private final List<IDDAllocation> dDAllocations = new ArrayList<IDDAllocation>();
    private final List<IHFSOutput> hfsOutputs = new ArrayList<IHFSOutput>();
    private UUID dataDefinitionUuid;
    private String defaultOptions = "";
    private int maxRC = 0;
    private final List<String> specialTypes = new ArrayList<String>();
    private String ddnamelist = "";
    private boolean isLinkEdit = false;
    private int fISPFLogPublishType = 1;
    private int fISPFLogConsolidate = 0;
    private boolean fISPFLogCompact;

    @Override
    public String getPlatform() {
        return ISystemDefinition.Platform.zos.name();
    }

    @Override
    public UUID getDataDefinitionUuid() {
        return this.dataDefinitionUuid;
    }

    @Override
    public void setDataDefinitionUuid(UUID dataDefinitionUuid) {
        this.dataDefinitionUuid = dataDefinitionUuid;
    }

    @Override
    public String getDefaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public void setDefaultOptions(String defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    @Override
    public int getCallMethod() {
        return this.callMethod;
    }

    @Override
    public void setCallMethod(int callMethod) {
        this.callMethod = callMethod;
    }

    @Override
    public String getCommandMember() {
        return this.commandMember;
    }

    @Override
    public void setCommandMember(String commandMember) {
        this.commandMember = commandMember;
    }

    @Override
    public int getMaxRC() {
        return this.maxRC;
    }

    @Override
    public void setMaxRC(int maxRC) {
        this.maxRC = maxRC;
    }

    @Override
    public List<IConcatenation> getConcatenations() {
        return this.concatenations;
    }

    @Override
    public List<IDDAllocation> getDDAllocations() {
        return this.dDAllocations;
    }

    @Override
    public List<IHFSOutput> getHFSOutputs() {
        return this.hfsOutputs;
    }

    @Override
    public List<String> getSpecialTypes() {
        return this.specialTypes;
    }

    @Override
    public String getDdnamelist() {
        return this.ddnamelist;
    }

    @Override
    public void setDdnamelist(String ddnamelist) {
        this.ddnamelist = ddnamelist;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        return super.getAdapter(adapterClass);
    }

    @Override
    protected ISystemDefinition newInstance() {
        return new ZosTranslator();
    }

    @Override
    public ISystemDefinition newCopy() {
        IZosTranslator newCopy = (IZosTranslator)super.newCopy();
        newCopy.setDataDefinitionUuid(this.getDataDefinitionUuid());
        newCopy.setDefaultOptions(this.getDefaultOptions());
        newCopy.setCallMethod(this.getCallMethod());
        newCopy.setDdnamelist(this.getDdnamelist());
        newCopy.setCommandMember(this.getCommandMember());
        newCopy.setMaxRC(this.getMaxRC());
        newCopy.setLinkEdit(this.isLinkEdit);
        for (IConcatenation c : this.getConcatenations()) {
            Concatenation newC = new Concatenation();
            newC.setName(c.getName());
            newC.setCondition(c.getCondition());
            for (IDataDefinitionEntry dde : c.getDataDefinitionEntries()) {
                DataDefinitionEntry newDDE = new DataDefinitionEntry();
                newDDE.setKind(dde.getKind());
                newDDE.setMember(dde.isMember());
                newDDE.setValue(dde.getValue());
                newC.getDataDefinitionEntries().add(newDDE);
            }
            newCopy.getConcatenations().add(newC);
        }
        for (IDDAllocation dda : this.getDDAllocations()) {
            DDAllocation newDDA = new DDAllocation();
            DataDefinitionEntry newDDE = new DataDefinitionEntry();
            newDDE.setKind(dda.getDataDefinitionEntry().getKind());
            newDDE.setMember(dda.getDataDefinitionEntry().isMember());
            newDDE.setValue(dda.getDataDefinitionEntry().getValue());
            newDDA.setDataDefinitionEntry(newDDE);
            newDDA.setKeep(dda.isKeep());
            newDDA.setMember(dda.isMember());
            newDDA.setName(dda.getName());
            newDDA.setOutput(dda.isOutput());
            newDDA.setPublish(dda.isPublish());
            newDDA.setPublishType(dda.getPublishType());
            newDDA.setConsolidateLog(dda.getConsolidateLog());
            newDDA.setOutputNameKind(dda.getOutputNameKind());
            newDDA.setOutputName(dda.getOutputName());
            newDDA.setCondition(dda.getCondition());
            newDDA.setSequential(dda.isSequential());
            newDDA.setUsedAsInput(dda.isUsedAsInput());
            newDDA.setDeployType(dda.getDeployType());
            newDDA.setCompact(dda.getCompact());
            newCopy.getDDAllocations().add(newDDA);
        }
        for (IHFSOutput output : this.getHFSOutputs()) {
            HFSOutput newOutput = new HFSOutput();
            newOutput.setPath(output.getPath());
            newOutput.setDeployType(output.getDeployType());
            newOutput.setCondition(output.getCondition());
            newCopy.getHFSOutputs().add(newOutput);
        }
        newCopy.getSpecialTypes().addAll(this.getSpecialTypes());
        newCopy.setISPFLogPublishType(this.getISPFLogPublishType());
        newCopy.setISPFLogConsolidate(this.getISPFLogConsolidate());
        newCopy.setISPFLogCompact(this.isISPFLogCompact());
        return newCopy;
    }

    @Override
    public void copyOutputNameInfo(ITranslator source) {
        if (!source.getPlatform().equals(ISystemDefinition.Platform.zos.name())) {
            return;
        }
        List<IDDAllocation> sourceDDAllocs = ((IZosTranslator)source).getDDAllocations();
        for (IDDAllocation ddAlloc : this.getDDAllocations()) {
            IDDAllocation sourceDDAlloc;
            if (!ZosTranslatorUtil.isMemberRenamed(ddAlloc) || (sourceDDAlloc = this.getDDAllocation(sourceDDAllocs, ddAlloc.getName())) == null) continue;
            ddAlloc.setOutputNameKind(sourceDDAlloc.getOutputNameKind());
            ddAlloc.setOutputName(sourceDDAlloc.getOutputName());
        }
    }

    @Override
    public void copyPublishInfo(ITranslator source) {
        if (!source.getPlatform().equals(ISystemDefinition.Platform.zos.name())) {
            return;
        }
        IZosTranslator zosTranslator = (IZosTranslator)source;
        List<IDDAllocation> sourceDDAllocs = zosTranslator.getDDAllocations();
        for (IDDAllocation ddAlloc : this.getDDAllocations()) {
            IDDAllocation sourceDDAlloc = this.getDDAllocation(sourceDDAllocs, ddAlloc.getName());
            if (sourceDDAlloc == null) continue;
            ddAlloc.setPublishType(sourceDDAlloc.getPublishType());
            ddAlloc.setConsolidateLog(sourceDDAlloc.getConsolidateLog());
            ddAlloc.setCompact(sourceDDAlloc.getCompact());
        }
        this.setISPFLogPublishType(zosTranslator.getISPFLogPublishType());
        this.setISPFLogConsolidate(zosTranslator.getISPFLogConsolidate());
        this.setISPFLogCompact(zosTranslator.isISPFLogCompact());
    }

    private IDDAllocation getDDAllocation(List<IDDAllocation> ddAllocs, String name) {
        if (name != null) {
            for (IDDAllocation ddAlloc : ddAllocs) {
                if (!name.equals(ddAlloc.getName())) continue;
                return ddAlloc;
            }
        }
        return null;
    }

    @Override
    public boolean isLinkEdit() {
        return this.isLinkEdit;
    }

    @Override
    public void setLinkEdit(boolean isLinkEdit) {
        this.isLinkEdit = isLinkEdit;
    }

    @Override
    public String getAntSnippet() {
        return this.commandMember;
    }

    @Override
    public boolean isISPFLogCompact() {
        return this.fISPFLogCompact;
    }

    @Override
    public void setISPFLogCompact(boolean compact) {
        this.fISPFLogCompact = compact;
    }

    @Override
    public int getISPFLogPublishType() {
        return this.fISPFLogPublishType;
    }

    @Override
    public void setISPFLogPublishType(int type) {
        this.fISPFLogPublishType = type;
    }

    @Override
    public int getISPFLogConsolidate() {
        return this.fISPFLogConsolidate;
    }

    @Override
    public void setISPFLogConsolidate(int type) {
        this.fISPFLogConsolidate = type;
    }
}

