/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.TranslatorType;
import com.ibm.team.enterprise.zos.systemdefinition.common.nls.Messages;
import com.ibm.team.repository.common.LogFactory;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class TranslatorTypeExtensionManager {
    public static final String EXTENSION_POINT_ID_TRANSLATOR_TYPES = "com.ibm.team.enterprise.zos.systemdefinition.common.translatorTypes";
    protected static TranslatorTypeExtensionManager fManager = null;

    protected TranslatorTypeExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TranslatorTypeExtensionManager getInstance() {
        Class<TranslatorTypeExtensionManager> clazz = TranslatorTypeExtensionManager.class;
        synchronized (TranslatorTypeExtensionManager.class) {
            if (fManager == null) {
                fManager = new TranslatorTypeExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public TranslatorType[] getTranslatorTypes() {
        return this.loadTranslatorTypeExtensions();
    }

    public TranslatorType getTranslatorType(String translatorId) {
        TranslatorType[] extensions;
        TranslatorType[] translatorTypeArray = extensions = this.loadTranslatorTypeExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            TranslatorType extension = translatorTypeArray[n2];
            if (extension.getIdAttribute().equals(translatorId)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private TranslatorType[] loadTranslatorTypeExtensions() {
        LinkedList<TranslatorType> extensions = new LinkedList<TranslatorType>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_TRANSLATOR_TYPES);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    TranslatorType extension = new TranslatorType(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions.toArray(new TranslatorType[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.TranslatorTypeExtensionManager_DUPLICATE_EXTENSION, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.enterprise.zos.systemdefinition.common").error((Object)message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.TranslatorTypeExtensionManager_ILLEGAL_OR_MISSING_ATTRIBUTE, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.enterprise.zos.systemdefinition.common").error((Object)(String.valueOf(message) + " " + exception.getMessage()));
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

