/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.AbstractSystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingElements;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingFmidItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingVersion;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingFmidItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.validation.VersionDefinitionDuplicateIdValidator;
import com.ibm.team.enterprise.zos.systemdefinition.common.validation.VersionDefinitionDuplicateNameValidator;
import java.util.ArrayList;
import java.util.List;

public class PackagingVersion
extends AbstractSystemDefinition
implements IPackagingVersion {
    private final IDebugger dbg;
    private final String simpleName;
    private final ISystemDefinitionValidator[] validators = new ISystemDefinitionValidator[]{new VersionDefinitionDuplicateNameValidator(), new VersionDefinitionDuplicateIdValidator()};
    private boolean extendedService;
    private boolean generallyAvailable;
    private boolean outOfService;
    private boolean saveRequired;
    private boolean singleFunction;
    private String baseFmid;
    private String componentId;
    private String componentPrefix;
    private String copyright;
    private String defaultFmid;
    private String id;
    private String systemRelease;
    private String usermodPrefix;
    private final List<IPackagingFmidItem> packagingFmidItems;
    private final List<IScopedProperty> scopedProperties;

    public PackagingVersion() {
        this.dbg = new Debugger(PackagingVersion.class);
        this.simpleName = this.getClass().getSimpleName();
        this.packagingFmidItems = new ArrayList<IPackagingFmidItem>();
        this.scopedProperties = new ArrayList<IScopedProperty>();
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingVersion(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.packagingFmidItems = new ArrayList<IPackagingFmidItem>();
        this.scopedProperties = new ArrayList<IScopedProperty>();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingVersion(IPackagingVersion packagingVersion) {
        this.dbg = new Debugger(PackagingVersion.class);
        this.simpleName = this.getClass().getSimpleName();
        this.packagingFmidItems = new ArrayList<IPackagingFmidItem>();
        this.scopedProperties = new ArrayList<IScopedProperty>();
        this.copy(packagingVersion);
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingVersion(IPackagingVersion packagingVersion, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.packagingFmidItems = new ArrayList<IPackagingFmidItem>();
        this.scopedProperties = new ArrayList<IScopedProperty>();
        this.copy(packagingVersion);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final PackagingVersion copy(IPackagingVersion original) {
        if (original == null) {
            this.setArchived(false);
            this.setDescription("");
            this.setIgnoredOnceForBuild(false);
            this.setIsNew(false);
            this.setMigrated(false);
            this.setName("");
            this.setNonImpacting(false);
            this.setProjectAreaUuid("");
            this.setStateId("");
            this.setUuid("");
            this.setBaseFmid("");
            this.setComponentId("");
            this.setComponentPrefix("");
            this.setCopyright("");
            this.setDefaultFmid("");
            this.setExtendedService(Boolean.parseBoolean("false"));
            this.setGenerallyAvailable(Boolean.parseBoolean("false"));
            this.setId("");
            this.setOutOfService(Boolean.parseBoolean("false"));
            this.setSingleFunction(Boolean.parseBoolean("false"));
            this.setSystemRelease("");
            this.setUsermodPrefix("XX");
        } else {
            this.setArchived(original.isArchived());
            this.setDescription(original.getDescription());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setIsNew(original.isNew());
            this.setMigrated(original.isMigrated());
            this.setName(original.getName());
            this.setNonImpacting(original.isNonImpacting());
            this.setProjectAreaUuid(original.getProjectAreaUuid());
            this.setStateId(original.getStateId());
            this.setUuid(original.getUuid());
            this.setBaseFmid(original.getBaseFmid());
            this.setComponentId(original.getComponentId());
            this.setComponentPrefix(original.getComponentPrefix());
            this.setCopyright(original.getCopyright());
            this.setDefaultFmid(original.getDefaultFmid());
            this.setExtendedService(original.isExtendedService());
            this.setGenerallyAvailable(original.isGenerallyAvailable());
            this.setId(original.getId());
            this.setOutOfService(original.isOutOfService());
            this.setSingleFunction(original.isSingleFunction());
            this.setSystemRelease(original.getSystemRelease());
            this.setUsermodPrefix(original.getUsermodPrefix());
            this.getPackagingFmidItems().addAll(original.getPackagingFmidItems());
            this.getScopedProperties().addAll(original.getScopedProperties());
        }
        return this;
    }

    @Override
    public ISystemDefinition newCopy() {
        IPackagingVersion newCopy = (IPackagingVersion)super.newCopy();
        newCopy.setBaseFmid(this.getBaseFmid());
        newCopy.setComponentId(this.getComponentId());
        newCopy.setComponentPrefix(this.getComponentPrefix());
        newCopy.setCopyright(this.getCopyright());
        newCopy.setDefaultFmid(this.getDefaultFmid());
        newCopy.setExtendedService(this.isExtendedService());
        newCopy.setGenerallyAvailable(this.isGenerallyAvailable());
        newCopy.setId(this.getId());
        newCopy.setOutOfService(this.isOutOfService());
        newCopy.setSingleFunction(this.isSingleFunction());
        newCopy.setSystemRelease(this.getSystemRelease());
        newCopy.setUsermodPrefix(this.getUsermodPrefix());
        newCopy.getPackagingFmidItems().addAll(this.getPackagingFmidItems());
        newCopy.getScopedProperties().addAll(this.getScopedProperties());
        return newCopy;
    }

    public final PackagingVersion update(IPackagingVersion updated) {
        this.setArchived(updated.isArchived());
        this.setDescription(updated.getDescription());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setIsNew(updated.isNew());
        this.setMigrated(updated.isMigrated());
        this.setName(updated.getName());
        this.setNonImpacting(updated.isNonImpacting());
        this.setProjectAreaUuid(updated.getProjectAreaUuid());
        this.setStateId(updated.getStateId());
        this.setUuid(updated.getUuid());
        this.setBaseFmid(updated.getBaseFmid());
        this.setComponentId(updated.getComponentId());
        this.setComponentPrefix(updated.getComponentPrefix());
        this.setCopyright(updated.getCopyright());
        this.setDefaultFmid(updated.getDefaultFmid());
        this.setExtendedService(updated.isExtendedService());
        this.setGenerallyAvailable(updated.isGenerallyAvailable());
        this.setId(updated.getId());
        this.setOutOfService(updated.isOutOfService());
        this.setSingleFunction(updated.isSingleFunction());
        this.setSystemRelease(updated.getSystemRelease());
        this.setUsermodPrefix(updated.getUsermodPrefix());
        this.getPackagingFmidItems().clear();
        this.getPackagingFmidItems().addAll(updated.getPackagingFmidItems());
        this.getScopedProperties().clear();
        this.getScopedProperties().addAll(updated.getScopedProperties());
        return this;
    }

    @Override
    public ISystemDefinitionValidator[] getValidators() {
        return this.validators;
    }

    @Override
    protected ISystemDefinition newInstance() {
        return new PackagingVersion();
    }

    @Override
    public String getType() {
        return "versiondefinition";
    }

    @Override
    public String getPlatform() {
        return ISystemDefinition.Platform.zos.name();
    }

    @Override
    public String getBaseFmid() {
        return this.baseFmid;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public String getComponentPrefix() {
        return this.componentPrefix;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getDefaultFmid() {
        return this.defaultFmid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSystemRelease() {
        return this.systemRelease;
    }

    @Override
    public String getUsermodPrefix() {
        return this.usermodPrefix;
    }

    @Override
    public IPackagingFmidItem getPackagingFmidItem(IPackagingFmidItem item) {
        if (Verification.isNonEmpty(this.packagingFmidItems)) {
            for (IPackagingFmidItem packagingFmidItem : this.packagingFmidItems) {
                if (!packagingFmidItem.getFunction().getUuid().equals(item.getFunction().getUuid())) continue;
                return packagingFmidItem;
            }
        }
        return null;
    }

    @Override
    public IPackagingFmidItem getPackagingFmidItem(String uuid) {
        if (Verification.isNonEmpty(this.packagingFmidItems)) {
            for (IPackagingFmidItem packagingFmidItem : this.packagingFmidItems) {
                if (!packagingFmidItem.getFunction().getUuid().equals(uuid)) continue;
                return packagingFmidItem;
            }
        }
        return null;
    }

    @Override
    public List<IPackagingFmidItem> getPackagingFmidItems() {
        return this.packagingFmidItems;
    }

    @Override
    public List<IScopedProperty> getScopedProperties() {
        return this.scopedProperties;
    }

    @Override
    public boolean isExtendedService() {
        return this.extendedService;
    }

    @Override
    public boolean isGenerallyAvailable() {
        return this.generallyAvailable;
    }

    @Override
    public boolean isOutOfService() {
        return this.outOfService;
    }

    @Override
    public boolean isSaveRequired() {
        return this.saveRequired;
    }

    @Override
    public boolean isSingleFunction() {
        return this.singleFunction;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.getDescription());
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.getName());
    }

    @Override
    public boolean hasBaseFmid() {
        return Verification.isNonBlank((String)this.baseFmid);
    }

    @Override
    public boolean hasComponentId() {
        return Verification.isNonBlank((String)this.componentId);
    }

    @Override
    public boolean hasComponentPrefix() {
        return Verification.isNonBlank((String)this.componentPrefix);
    }

    @Override
    public boolean hasCopyright() {
        return Verification.isNonBlank((String)this.copyright);
    }

    @Override
    public boolean hasDefaultFmid() {
        return Verification.isNonBlank((String)this.defaultFmid);
    }

    @Override
    public boolean hasId() {
        return Verification.isNonBlank((String)this.id);
    }

    @Override
    public boolean hasSystemRelease() {
        return Verification.isNonBlank((String)this.systemRelease);
    }

    @Override
    public boolean hasUsermodPrefix() {
        return Verification.isNonBlank((String)this.usermodPrefix);
    }

    @Override
    public boolean hasPackagingFmidItems() {
        return Verification.isNonEmpty(this.packagingFmidItems);
    }

    @Override
    public boolean hasScopedProperties() {
        return Verification.isNonEmpty(this.scopedProperties);
    }

    @Override
    public void setExtendedService(boolean extendedService) {
        this.extendedService = extendedService;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.extendedService)});
        }
    }

    @Override
    public void setGenerallyAvailable(boolean generallyAvailable) {
        this.generallyAvailable = generallyAvailable;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.generallyAvailable)});
        }
    }

    @Override
    public void setOutOfService(boolean outOfService) {
        this.outOfService = outOfService;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.outOfService)});
        }
    }

    @Override
    public void setSaveRequired(boolean saveRequired) {
        this.saveRequired = saveRequired;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.saveRequired)});
        }
    }

    @Override
    public void setSingleFunction(boolean singleFunction) {
        this.singleFunction = singleFunction;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.singleFunction)});
        }
    }

    @Override
    public void setBaseFmid(String baseFmid) {
        this.baseFmid = baseFmid;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.baseFmid)});
        }
    }

    @Override
    public void setComponentId(String componentId) {
        this.componentId = componentId;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.componentId)});
        }
    }

    @Override
    public void setComponentPrefix(String componentPrefix) {
        this.componentPrefix = componentPrefix;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.componentPrefix)});
        }
    }

    @Override
    public void setCopyright(String copyright) {
        this.copyright = copyright;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.copyright)});
        }
    }

    @Override
    public void setDefaultFmid(String defaultFmid) {
        this.defaultFmid = defaultFmid;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.defaultFmid)});
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.id)});
        }
    }

    @Override
    public void setSystemRelease(String systemRelease) {
        this.systemRelease = systemRelease;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.systemRelease)});
        }
    }

    @Override
    public void setUsermodPrefix(String usermodPrefix) {
        this.usermodPrefix = usermodPrefix;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.usermodPrefix)});
        }
    }

    protected void addOtherChangeLogDeltas(ISystemDefinition old, ChangeLogDTO changelog) {
        PackagingVersion oldThis = null;
        boolean isNew = old == null;
        String archived = null;
        String migrated = null;
        String type = null;
        String uuid = null;
        String baseFmid = null;
        String componentId = null;
        String componentPrefix = null;
        String copyright = null;
        String defaultFmid = null;
        String extendedService = null;
        String generallyAvailable = null;
        String id = null;
        String outOfService = null;
        String singleFunction = null;
        String systemRelease = null;
        String usermodPrefix = null;
        List<IPackagingFmidItem> packagingFmidItems = null;
        List<IScopedProperty> scopedProperties = null;
        if (old != null && old instanceof PackagingVersion) {
            oldThis = (PackagingVersion)old;
            archived = Boolean.toString(oldThis.isArchived());
            migrated = Boolean.toString(oldThis.isMigrated());
            type = oldThis.getType();
            uuid = oldThis.getUuid();
            baseFmid = oldThis.getBaseFmid();
            componentId = oldThis.getComponentId();
            componentPrefix = oldThis.getComponentPrefix();
            copyright = oldThis.getCopyright();
            defaultFmid = oldThis.getDefaultFmid();
            extendedService = Boolean.toString(oldThis.isExtendedService());
            generallyAvailable = Boolean.toString(oldThis.isGenerallyAvailable());
            id = oldThis.getId();
            outOfService = Boolean.toString(oldThis.isOutOfService());
            singleFunction = Boolean.toString(oldThis.isSingleFunction());
            systemRelease = oldThis.getSystemRelease();
            usermodPrefix = oldThis.getUsermodPrefix();
            packagingFmidItems = oldThis.getPackagingFmidItems();
            scopedProperties = oldThis.getScopedProperties();
        }
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_ARCHIVED_TAG.getWholeTagName(), archived, Boolean.toString(this.isArchived()), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_MIGRATED_TAG.getWholeTagName(), migrated, Boolean.toString(this.isMigrated()), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_TYPE_TAG.getWholeTagName(), type, this.getType(), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_UUID_TAG.getWholeTagName(), uuid, this.getUuid(), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_BASEFMID_TAG.getWholeTagName(), baseFmid, this.baseFmid, false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_COMPONENTID_TAG.getWholeTagName(), componentId, this.componentId, true, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_COMPONENTPREFIX_TAG.getWholeTagName(), componentPrefix, this.componentPrefix, true, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_COPYRIGHT_TAG.getWholeTagName(), copyright, this.copyright, true, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_DEFAULTFMID_TAG.getWholeTagName(), defaultFmid, this.defaultFmid, false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_EXTENDEDSERVICE_TAG.getWholeTagName(), extendedService, Boolean.toString(this.extendedService), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_GENERALLYAVAILABLE_TAG.getWholeTagName(), generallyAvailable, Boolean.toString(this.generallyAvailable), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_ID_TAG.getWholeTagName(), id, this.id, true, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_OUTOFSERVICE_TAG.getWholeTagName(), outOfService, Boolean.toString(this.outOfService), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_SINGLEFUNCTION_TAG.getWholeTagName(), singleFunction, Boolean.toString(this.singleFunction), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_SYSTEMRELEASE_TAG.getWholeTagName(), systemRelease, this.systemRelease, true, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_VERSION_USERMODPREFIX_TAG.getWholeTagName(), usermodPrefix, this.usermodPrefix, true, isNew);
        int i = 0;
        while (i < this.packagingFmidItems.size()) {
            PackagingFmidItem packagingFmidItem = (PackagingFmidItem)this.packagingFmidItems.get(i);
            PackagingFmidItem oldPackagingFmidItem = (PackagingFmidItem)(packagingFmidItems == null ? null : (packagingFmidItems.size() <= i ? null : packagingFmidItems.get(i)));
            packagingFmidItem.addEmbeddedChangeLogDeltas(oldPackagingFmidItem, changelog);
            ++i;
        }
    }
}

