/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.AbstractSystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingElements;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingFunction;
import com.ibm.team.enterprise.zos.systemdefinition.common.validation.FunctionDefinitionDuplicateIdValidator;
import com.ibm.team.enterprise.zos.systemdefinition.common.validation.FunctionDefinitionDuplicateNameValidator;

public class PackagingFunction
extends AbstractSystemDefinition
implements IPackagingFunction {
    private final IDebugger dbg;
    private final String simpleName;
    private final ISystemDefinitionValidator[] validators = new ISystemDefinitionValidator[]{new FunctionDefinitionDuplicateNameValidator(), new FunctionDefinitionDuplicateIdValidator()};
    private String id;

    public PackagingFunction() {
        this.dbg = new Debugger(PackagingFunction.class);
        this.simpleName = this.getClass().getSimpleName();
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFunction(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFunction(IPackagingFunction packagingFunction) {
        this.dbg = new Debugger(PackagingFunction.class);
        this.simpleName = this.getClass().getSimpleName();
        this.copy(packagingFunction);
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFunction(PackagingFunction packagingFunction, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.copy(packagingFunction);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final PackagingFunction copy(IPackagingFunction original) {
        if (original == null) {
            this.setArchived(false);
            this.setDescription("");
            this.setIgnoredOnceForBuild(false);
            this.setIsNew(false);
            this.setMigrated(false);
            this.setName("");
            this.setNonImpacting(false);
            this.setProjectAreaUuid("");
            this.setStateId("");
            this.setUuid("");
            this.setId("");
        } else {
            this.setArchived(original.isArchived());
            this.setDescription(original.getDescription());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setIsNew(original.isNew());
            this.setMigrated(original.isMigrated());
            this.setName(original.getName());
            this.setNonImpacting(original.isNonImpacting());
            this.setProjectAreaUuid(original.getProjectAreaUuid());
            this.setStateId(original.getStateId());
            this.setUuid(original.getUuid());
            this.setId(original.getId());
        }
        return this;
    }

    @Override
    public ISystemDefinition newCopy() {
        IPackagingFunction newCopy = (IPackagingFunction)super.newCopy();
        newCopy.setId(this.getId());
        return newCopy;
    }

    public final PackagingFunction update(PackagingFunction updated) {
        this.setArchived(updated.isArchived());
        this.setDescription(updated.getDescription());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setIsNew(updated.isNew());
        this.setMigrated(updated.isMigrated());
        this.setName(updated.getName());
        this.setNonImpacting(updated.isNonImpacting());
        this.setProjectAreaUuid(updated.getProjectAreaUuid());
        this.setStateId(updated.getStateId());
        this.setUuid(updated.getUuid());
        this.setId(updated.getId());
        return this;
    }

    @Override
    public ISystemDefinitionValidator[] getValidators() {
        return this.validators;
    }

    @Override
    protected ISystemDefinition newInstance() {
        return new PackagingFunction();
    }

    @Override
    public String getType() {
        return "functiondefinition";
    }

    @Override
    public String getPlatform() {
        return ISystemDefinition.Platform.zos.name();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.getDescription());
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.getName());
    }

    @Override
    public boolean hasId() {
        return Verification.isNonBlank((String)this.id);
    }

    @Override
    public void setId(String id) {
        this.id = id;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.id)});
        }
    }

    protected void addOtherChangeLogDeltas(ISystemDefinition old, ChangeLogDTO changelog) {
        PackagingFunction oldThis = null;
        boolean isNew = old == null;
        String archived = null;
        String migrated = null;
        String type = null;
        String uuid = null;
        String id = null;
        if (old != null && old instanceof PackagingFunction) {
            oldThis = (PackagingFunction)old;
            archived = Boolean.toString(oldThis.isArchived());
            migrated = Boolean.toString(oldThis.isMigrated());
            type = oldThis.getType();
            uuid = oldThis.getUuid();
            id = oldThis.getId();
        }
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_ARCHIVED_TAG.getWholeTagName(), archived, Boolean.toString(this.isArchived()), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_MIGRATED_TAG.getWholeTagName(), migrated, Boolean.toString(this.isMigrated()), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_TYPE_TAG.getWholeTagName(), type, this.getType(), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_UUID_TAG.getWholeTagName(), uuid, this.getUuid(), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changelog.getChanges(), IPackagingElements.ELEMENT_FUNCTION_ID_TAG.getWholeTagName(), id, this.getId(), true, isNew);
    }
}

