/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.AbstractPackagingItemCommon;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingFolderDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingFolderItemDefaults;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingLanguageDetail;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import java.util.ArrayList;
import java.util.List;

public class PackagingFolderItem
extends AbstractPackagingItemCommon {
    private final IDebugger dbg;
    private final String simpleName;
    private final IPackagingItem folderItem;
    private final IPackagingItem packagingItem;
    private IComponentHandle componentHandle = null;
    private IVersionable folderVersionable = null;
    private String folderName = null;
    private String folderNameExtended = null;

    public PackagingFolderItem(IPackagingItem packagingItem) {
        super(packagingItem, new PackagingFolderItemDefaults());
        this.dbg = super.getDbg();
        this.simpleName = this.getClass().getSimpleName();
        this.folderItem = this;
        this.packagingItem = packagingItem;
        this.setUuid(packagingItem.getUuid());
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFolderItem(IPackagingItem packagingItem, IDebugger dbg) {
        super(packagingItem, new PackagingFolderItemDefaults());
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.folderItem = this;
        this.packagingItem = packagingItem;
        this.setUuid(packagingItem.getUuid());
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingItem copy() {
        return this.copy(this);
    }

    @Override
    public final IPackagingItem copy(IPackagingItem original) {
        if (original != null && original instanceof PackagingFolderItem) {
            PackagingFolderItem oldItem = (PackagingFolderItem)original;
            PackagingFolderItem newItem = (PackagingFolderItem)oldItem.newInstance();
            newItem.setArchived(oldItem.isArchived());
            newItem.setIsNew(oldItem.isNew());
            newItem.setMigrated(oldItem.isMigrated());
            newItem.setNonImpacting(oldItem.isNonImpacting());
            newItem.setArchived(oldItem.isArchived(true));
            newItem.setDescription(oldItem.getDescription(true));
            newItem.setIsNew(oldItem.isNew(true));
            newItem.setMigrated(oldItem.isMigrated(true));
            newItem.setName(oldItem.getName(true));
            newItem.setNonImpacting(oldItem.isNonImpacting(true));
            newItem.setProjectAreaUuid(oldItem.getProjectAreaUuid(true));
            newItem.setStateId(oldItem.getStateId(true));
            newItem.setUuid(oldItem.getUuid(true));
            newItem.setDescription = oldItem.setDescription;
            newItem.setName = oldItem.setName;
            newItem.setComponentHandle(oldItem.getComponentHandle(true));
            newItem.setFolderVersionable(oldItem.getFolderVersionable(true));
            newItem.setFolderName(oldItem.getFolderName(true));
            newItem.setFolderNameExtended(oldItem.getFolderNameExtended(true));
            newItem.setIgnore = oldItem.setIgnore;
            newItem.ignore = oldItem.ignore;
            newItem.setAlias = oldItem.setAlias;
            newItem.setClazz = oldItem.setClazz;
            newItem.setCsect = oldItem.setCsect;
            newItem.setDeleted = oldItem.setDeleted;
            newItem.setDisttype = oldItem.setDisttype;
            newItem.setFmid = oldItem.setFmid;
            newItem.setHfsdata = oldItem.setHfsdata;
            newItem.setHfspath = oldItem.setHfspath;
            newItem.setLeparm = oldItem.setLeparm;
            newItem.setModule = oldItem.setModule;
            newItem.setUpdated = oldItem.setUpdated;
            newItem.setTransform = oldItem.setTransform;
            newItem.setVpl = oldItem.setVpl;
            newItem.alias = oldItem.alias;
            newItem.clazz = oldItem.clazz;
            newItem.csect = oldItem.csect;
            newItem.deleted = oldItem.deleted;
            newItem.disttype = oldItem.disttype;
            newItem.fmid = oldItem.fmid;
            newItem.hfsdata = oldItem.hfsdata;
            newItem.hfspath = oldItem.hfspath;
            newItem.leparm = oldItem.leparm;
            newItem.module = oldItem.module;
            newItem.updated = oldItem.updated;
            newItem.transform = oldItem.transform;
            newItem.vpl = oldItem.vpl;
            newItem.packagingDetails.clear();
            newItem.packagingDetails.addAll(oldItem.getPackagingDetails(true));
            return newItem;
        }
        return null;
    }

    @Override
    public final void init() {
        List<IPackagingDetail> packagingDetails = super.getPackagingDetails();
        if (packagingDetails != null) {
            this.packagingDetails = new ArrayList();
            for (IPackagingDetail superItem : packagingDetails) {
                PackagingFolderDetail localItem = new PackagingFolderDetail(superItem);
                localItem.setIsNew(false);
                this.packagingDetails.add(localItem);
            }
        }
    }

    @Override
    public final void init(List<String> add, List<String> remove, List<String> order) {
        this.init();
        if (add != null) {
            for (String uuid : add) {
                if (uuid == null) continue;
                IPackagingDetail localItem = this.newInstanceDetail();
                localItem.setUuid(uuid);
                localItem.setIsNew(true);
                this.packagingDetails.add(localItem);
            }
        }
        if (remove != null) {
            block1: for (String uuid : remove) {
                if (uuid == null) continue;
                int i = 0;
                while (i < this.packagingDetails.size()) {
                    if (this.packagingDetails.get(i) != null && uuid.equals(((IPackagingDetail)this.packagingDetails.get(i)).getUuid())) {
                        this.packagingDetails.remove(i);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        if (order != null) {
            ArrayList<IPackagingDetail> orderedDetails = new ArrayList<IPackagingDetail>();
            block3: for (String uuid : order) {
                if (uuid == null) continue;
                int i = 0;
                while (i < this.packagingDetails.size()) {
                    if (this.packagingDetails.get(i) != null && uuid.equals(((IPackagingDetail)this.packagingDetails.get(i)).getUuid())) {
                        orderedDetails.add((IPackagingDetail)this.packagingDetails.get(i));
                        continue block3;
                    }
                    ++i;
                }
            }
            this.packagingDetails = orderedDetails;
        }
    }

    @Override
    public final IPackagingItem update(IPackagingItem updated) {
        if (updated != null && updated instanceof PackagingFolderItem) {
            PackagingFolderItem updatedItem = (PackagingFolderItem)updated;
            this.setArchived(updatedItem.isArchived());
            this.setIsNew(updatedItem.isNew());
            this.setMigrated(updatedItem.isMigrated());
            this.setNonImpacting(updatedItem.isNonImpacting());
            this.setArchived(updatedItem.isArchived(true));
            this.setDescription(updatedItem.getDescription(true));
            this.setIsNew(updatedItem.isNew(true));
            this.setMigrated(updatedItem.isMigrated(true));
            this.setName(updatedItem.getName(true));
            this.setNonImpacting(updatedItem.isNonImpacting(true));
            this.setProjectAreaUuid(updatedItem.getProjectAreaUuid(true));
            this.setStateId(updatedItem.getStateId(true));
            this.setUuid(updatedItem.getUuid(true));
            this.setDescription = updatedItem.setDescription;
            this.setName = updatedItem.setName;
            this.setComponentHandle(updatedItem.getComponentHandle(true));
            this.setFolderVersionable(updatedItem.getFolderVersionable(true));
            this.setFolderName(updatedItem.getFolderName(true));
            this.setFolderNameExtended(updatedItem.getFolderNameExtended(true));
            this.setIgnore = updatedItem.setIgnore;
            this.ignore = updatedItem.ignore;
            this.setAlias = updatedItem.setAlias;
            this.setClazz = updatedItem.setClazz;
            this.setCsect = updatedItem.setCsect;
            this.setDeleted = updatedItem.setDeleted;
            this.setDisttype = updatedItem.setDisttype;
            this.setFmid = updatedItem.setFmid;
            this.setHfsdata = updatedItem.setHfsdata;
            this.setHfspath = updatedItem.setHfspath;
            this.setLeparm = updatedItem.setLeparm;
            this.setModule = updatedItem.setModule;
            this.setUpdated = updatedItem.setUpdated;
            this.setTransform = updatedItem.setTransform;
            this.setVpl = updatedItem.setVpl;
            this.alias = updatedItem.alias;
            this.clazz = updatedItem.clazz;
            this.csect = updatedItem.csect;
            this.deleted = updatedItem.deleted;
            this.disttype = updatedItem.disttype;
            this.fmid = updatedItem.fmid;
            this.hfsdata = updatedItem.hfsdata;
            this.hfspath = updatedItem.hfspath;
            this.leparm = updatedItem.leparm;
            this.module = updatedItem.module;
            this.updated = updatedItem.updated;
            this.transform = updatedItem.transform;
            this.vpl = updatedItem.vpl;
            this.packagingDetails.clear();
            this.packagingDetails.addAll(updatedItem.getPackagingDetails(true));
        }
        return this;
    }

    @Override
    protected final ISystemDefinition newInstance() {
        return new PackagingFolderItem(this.packagingItem);
    }

    @Override
    protected final IPackagingDetail newInstanceDetail() {
        PackagingLanguageDetail higher = new PackagingLanguageDetail();
        PackagingFolderDetail result = new PackagingFolderDetail(higher);
        return result;
    }

    @Override
    protected final IPackagingDetail newInstanceDetail(int index) {
        IPackagingDetail higher = super.getPackagingDetail(index);
        PackagingFolderDetail result = new PackagingFolderDetail(higher);
        return result;
    }

    @Override
    public final String getItemLabel() {
        return Packaging.getLabel(this.folderItem);
    }

    @Override
    public final IComponentHandle getComponentHandle() {
        return this.componentHandle == null ? super.getComponentHandle() : this.componentHandle;
    }

    @Override
    public final IComponentHandle getComponentHandle(boolean local) {
        if (local) {
            return this.componentHandle;
        }
        return this.getComponentHandle();
    }

    @Override
    public final IVersionable getFolderVersionable() {
        return this.folderVersionable == null ? super.getFolderVersionable() : this.folderVersionable;
    }

    @Override
    public final IVersionable getFolderVersionable(boolean local) {
        if (local) {
            return this.folderVersionable;
        }
        return this.getFolderVersionable();
    }

    @Override
    public final IPackagingItem getFolderItem() {
        return this.folderItem == null ? super.getFolderItem() : this.folderItem;
    }

    @Override
    public final IPackagingItem getFolderItem(boolean local) {
        if (local) {
            return this.folderItem;
        }
        return this.getFolderItem();
    }

    @Override
    public final String getFolderName() {
        return this.folderName == null ? super.getFolderName() : this.folderName;
    }

    @Override
    public final String getFolderName(boolean local) {
        if (local) {
            return this.folderName;
        }
        return this.getFolderName();
    }

    @Override
    public final String getFolderNameExtended() {
        return this.folderNameExtended == null ? super.getFolderNameExtended() : this.folderNameExtended;
    }

    @Override
    public final String getFolderNameExtended(boolean local) {
        if (local) {
            return this.folderNameExtended;
        }
        return this.getFolderNameExtended();
    }

    @Override
    public final boolean hasComponentHandle() {
        return Verification.isNonNull((Object)this.getComponentHandle());
    }

    @Override
    public final boolean hasComponentHandle(boolean local) {
        return Verification.isNonNull((Object)this.getComponentHandle(local));
    }

    @Override
    public final boolean hasFolderVersionable() {
        return Verification.isNonNull((Object)this.getFolderVersionable());
    }

    @Override
    public final boolean hasFolderVersionable(boolean local) {
        return Verification.isNonNull((Object)this.getFolderVersionable(local));
    }

    @Override
    public final boolean hasFolderItem() {
        return Verification.isNonNull((Object)this.getFolderItem());
    }

    @Override
    public final boolean hasFolderItem(boolean local) {
        return Verification.isNonNull((Object)this.getFolderItem(local));
    }

    @Override
    public final boolean hasFolderName() {
        return Verification.isNonBlank((String)this.getFolderName());
    }

    @Override
    public final boolean hasFolderName(boolean local) {
        return Verification.isNonBlank((String)this.getFolderName(local));
    }

    @Override
    public final boolean hasFolderNameExtended() {
        return Verification.isNonBlank((String)this.getFolderNameExtended());
    }

    @Override
    public final boolean hasFolderNameExtended(boolean local) {
        return Verification.isNonBlank((String)this.getFolderNameExtended(local));
    }

    @Override
    public final void setComponentHandle(IComponentHandle iComponentHandle) {
        this.componentHandle = iComponentHandle;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)this.componentHandle)});
        }
    }

    @Override
    public final void setFolderVersionable(IVersionable iFolderVersionable) {
        this.folderVersionable = iFolderVersionable;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItem)this.folderVersionable)});
        }
    }

    @Override
    public final void setFolderName(String folderName) {
        this.folderName = folderName;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.folderName)});
        }
    }

    @Override
    public final void setFolderNameExtended(String folderNameExtended) {
        this.folderNameExtended = folderNameExtended;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.folderNameExtended)});
        }
    }
}

