/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.AbstractPackagingItemCommon;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingFileDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingFileItemDefaults;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingLanguageDetail;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.scm.common.IVersionable;
import java.util.ArrayList;
import java.util.List;

public class PackagingFileItem
extends AbstractPackagingItemCommon {
    private final IDebugger dbg;
    private final String simpleName;
    private final IPackagingItem fileItem;
    private final IPackagingItem packagingItem;
    private IVersionable fileVersionable = null;
    private String fileName = null;
    private Boolean jclin = Verification.toBoolean((String)"false");

    public PackagingFileItem(IPackagingItem packagingItem) {
        super(packagingItem, new PackagingFileItemDefaults());
        this.dbg = super.getDbg();
        this.simpleName = this.getClass().getSimpleName();
        this.fileItem = this;
        this.packagingItem = packagingItem;
        this.setUuid(packagingItem.getUuid());
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFileItem(IPackagingItem packagingItem, IDebugger dbg) {
        super(packagingItem, new PackagingFileItemDefaults());
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.fileItem = this;
        this.packagingItem = packagingItem;
        this.setUuid(packagingItem.getUuid());
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingItem copy() {
        return this.copy(this);
    }

    @Override
    public final IPackagingItem copy(IPackagingItem original) {
        if (original != null && original instanceof PackagingFileItem) {
            PackagingFileItem oldItem = (PackagingFileItem)original;
            PackagingFileItem newItem = (PackagingFileItem)oldItem.newInstance();
            newItem.setArchived(oldItem.isArchived());
            newItem.setIsNew(oldItem.isNew());
            newItem.setMigrated(oldItem.isMigrated());
            newItem.setNonImpacting(oldItem.isNonImpacting());
            newItem.setArchived(oldItem.isArchived(true));
            newItem.setDescription(oldItem.getDescription(true));
            newItem.setIsNew(oldItem.isNew(true));
            newItem.setMigrated(oldItem.isMigrated(true));
            newItem.setName(oldItem.getName(true));
            newItem.setNonImpacting(oldItem.isNonImpacting(true));
            newItem.setProjectAreaUuid(oldItem.getProjectAreaUuid(true));
            newItem.setStateId(oldItem.getStateId(true));
            newItem.setUuid(oldItem.getUuid(true));
            newItem.setDescription = oldItem.setDescription;
            newItem.setName = oldItem.setName;
            newItem.setFileVersionable(oldItem.getFileVersionable(true));
            newItem.setFileName(oldItem.getFileName(true));
            newItem.setJclin(oldItem.getJclin(true));
            newItem.setIgnore = oldItem.setIgnore;
            newItem.ignore = oldItem.ignore;
            newItem.setAlias = oldItem.setAlias;
            newItem.setClazz = oldItem.setClazz;
            newItem.setCsect = oldItem.setCsect;
            newItem.setDeleted = oldItem.setDeleted;
            newItem.setDisttype = oldItem.setDisttype;
            newItem.setFmid = oldItem.setFmid;
            newItem.setHfsdata = oldItem.setHfsdata;
            newItem.setHfspath = oldItem.setHfspath;
            newItem.setLeparm = oldItem.setLeparm;
            newItem.setModule = oldItem.setModule;
            newItem.setUpdated = oldItem.setUpdated;
            newItem.setTransform = oldItem.setTransform;
            newItem.setVpl = oldItem.setVpl;
            newItem.alias = oldItem.alias;
            newItem.clazz = oldItem.clazz;
            newItem.csect = oldItem.csect;
            newItem.deleted = oldItem.deleted;
            newItem.disttype = oldItem.disttype;
            newItem.fmid = oldItem.fmid;
            newItem.hfsdata = oldItem.hfsdata;
            newItem.hfspath = oldItem.hfspath;
            newItem.leparm = oldItem.leparm;
            newItem.module = oldItem.module;
            newItem.updated = oldItem.updated;
            newItem.transform = oldItem.transform;
            newItem.vpl = oldItem.vpl;
            newItem.packagingDetails.clear();
            newItem.packagingDetails.addAll(oldItem.getPackagingDetails(true));
            return newItem;
        }
        return null;
    }

    @Override
    public final void init() {
        List<IPackagingDetail> packagingDetails = super.getPackagingDetails();
        if (packagingDetails != null) {
            this.packagingDetails = new ArrayList();
            for (IPackagingDetail superItem : packagingDetails) {
                PackagingFileDetail localItem = new PackagingFileDetail(superItem);
                localItem.setIsNew(false);
                this.packagingDetails.add(localItem);
            }
        }
    }

    @Override
    public final void init(List<String> add, List<String> remove, List<String> order) {
        this.init();
        if (add != null) {
            for (String uuid : add) {
                if (uuid == null) continue;
                IPackagingDetail localItem = this.newInstanceDetail();
                localItem.setUuid(uuid);
                localItem.setIsNew(true);
                this.packagingDetails.add(localItem);
            }
        }
        if (remove != null) {
            block1: for (String uuid : remove) {
                if (uuid == null) continue;
                int i = 0;
                while (i < this.packagingDetails.size()) {
                    if (this.packagingDetails.get(i) != null && uuid.equals(((IPackagingDetail)this.packagingDetails.get(i)).getUuid())) {
                        this.packagingDetails.remove(i);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        if (order != null) {
            ArrayList<IPackagingDetail> orderedDetails = new ArrayList<IPackagingDetail>();
            block3: for (String uuid : order) {
                if (uuid == null) continue;
                int i = 0;
                while (i < this.packagingDetails.size()) {
                    if (this.packagingDetails.get(i) != null && uuid.equals(((IPackagingDetail)this.packagingDetails.get(i)).getUuid())) {
                        orderedDetails.add((IPackagingDetail)this.packagingDetails.get(i));
                        continue block3;
                    }
                    ++i;
                }
            }
            this.packagingDetails = orderedDetails;
        }
    }

    @Override
    public final IPackagingItem update(IPackagingItem updated) {
        if (updated != null && updated instanceof PackagingFileItem) {
            PackagingFileItem updatedItem = (PackagingFileItem)updated;
            this.setArchived(updatedItem.isArchived());
            this.setIsNew(updatedItem.isNew());
            this.setMigrated(updatedItem.isMigrated());
            this.setNonImpacting(updatedItem.isNonImpacting());
            this.setArchived(updatedItem.isArchived(true));
            this.setDescription(updatedItem.getDescription(true));
            this.setIsNew(updatedItem.isNew(true));
            this.setMigrated(updatedItem.isMigrated(true));
            this.setName(updatedItem.getName(true));
            this.setNonImpacting(updatedItem.isNonImpacting(true));
            this.setProjectAreaUuid(updatedItem.getProjectAreaUuid(true));
            this.setStateId(updatedItem.getStateId(true));
            this.setUuid(updatedItem.getUuid(true));
            this.setDescription = updatedItem.setDescription;
            this.setName = updatedItem.setName;
            this.setFileVersionable(updatedItem.getFileVersionable(true));
            this.setFileName(updatedItem.getFileName(true));
            this.setJclin(updatedItem.getJclin(true));
            this.setIgnore = updatedItem.setIgnore;
            this.ignore = updatedItem.ignore;
            this.setAlias = updatedItem.setAlias;
            this.setClazz = updatedItem.setClazz;
            this.setCsect = updatedItem.setCsect;
            this.setDeleted = updatedItem.setDeleted;
            this.setDisttype = updatedItem.setDisttype;
            this.setFmid = updatedItem.setFmid;
            this.setHfsdata = updatedItem.setHfsdata;
            this.setHfspath = updatedItem.setHfspath;
            this.setLeparm = updatedItem.setLeparm;
            this.setModule = updatedItem.setModule;
            this.setUpdated = updatedItem.setUpdated;
            this.setTransform = updatedItem.setTransform;
            this.setVpl = updatedItem.setVpl;
            this.alias = updatedItem.alias;
            this.clazz = updatedItem.clazz;
            this.csect = updatedItem.csect;
            this.deleted = updatedItem.deleted;
            this.disttype = updatedItem.disttype;
            this.fmid = updatedItem.fmid;
            this.hfsdata = updatedItem.hfsdata;
            this.hfspath = updatedItem.hfspath;
            this.leparm = updatedItem.leparm;
            this.module = updatedItem.module;
            this.updated = updatedItem.updated;
            this.transform = updatedItem.transform;
            this.vpl = updatedItem.vpl;
            this.packagingDetails.clear();
            this.packagingDetails.addAll(updatedItem.getPackagingDetails(true));
        }
        return this;
    }

    @Override
    protected final ISystemDefinition newInstance() {
        return new PackagingFileItem(this.packagingItem);
    }

    @Override
    protected final IPackagingDetail newInstanceDetail() {
        PackagingLanguageDetail higher = new PackagingLanguageDetail();
        PackagingFileDetail result = new PackagingFileDetail(higher);
        return result;
    }

    @Override
    protected final IPackagingDetail newInstanceDetail(int index) {
        IPackagingDetail higher = super.getPackagingDetail(index);
        PackagingFileDetail result = new PackagingFileDetail(higher);
        return result;
    }

    @Override
    public final String getItemLabel() {
        return Packaging.getLabel(this.fileItem);
    }

    @Override
    public final IVersionable getFileVersionable() {
        return this.fileVersionable == null ? super.getFileVersionable() : this.fileVersionable;
    }

    @Override
    public final IVersionable getFileVersionable(boolean local) {
        if (local) {
            return this.fileVersionable;
        }
        return this.getFileVersionable();
    }

    @Override
    public final IPackagingItem getFileItem() {
        return this.fileItem == null ? super.getFileItem() : this.fileItem;
    }

    @Override
    public final IPackagingItem getFileItem(boolean local) {
        if (local) {
            return this.fileItem;
        }
        return this.getFileItem();
    }

    @Override
    public final String getFileName() {
        return this.fileName == null ? super.getFileName() : this.fileName;
    }

    @Override
    public final String getFileName(boolean local) {
        if (local) {
            return this.fileName;
        }
        return this.getFileName();
    }

    @Override
    public final Boolean getJclin() {
        return this.jclin == null ? super.getJclin() : this.jclin;
    }

    @Override
    public final Boolean getJclin(boolean local) {
        if (local) {
            return this.jclin;
        }
        return this.getJclin();
    }

    @Override
    public final boolean hasFileVersionable() {
        return Verification.isNonNull((Object)this.getFileVersionable());
    }

    @Override
    public final boolean hasFileVersionable(boolean local) {
        return Verification.isNonNull((Object)this.getFileVersionable(local));
    }

    @Override
    public final boolean hasFileItem() {
        return Verification.isNonNull((Object)this.getFileItem());
    }

    @Override
    public final boolean hasFileItem(boolean local) {
        return Verification.isNonNull((Object)this.getFileItem(local));
    }

    @Override
    public final boolean hasFileName() {
        return Verification.isNonBlank((String)this.getFileName());
    }

    @Override
    public final boolean hasFileName(boolean local) {
        return Verification.isNonBlank((String)this.getFileName(local));
    }

    @Override
    public final boolean hasJclin() {
        return Verification.isNonNull((Object)this.getJclin());
    }

    @Override
    public final boolean hasJclin(boolean local) {
        return Verification.isNonNull((Object)this.getJclin(local));
    }

    @Override
    public final boolean isJclin() {
        return this.getJclin();
    }

    @Override
    public final boolean isJclin(boolean local) {
        return this.getJclin(local);
    }

    @Override
    public final void setFileVersionable(IVersionable iFileVersionable) {
        this.fileVersionable = iFileVersionable;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItem)this.fileVersionable)});
        }
    }

    @Override
    public final void setFileName(String fileName) {
        this.fileName = fileName;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.fileName)});
        }
    }

    @Override
    public final void setJclin(Boolean jclin) {
        this.jclin = jclin;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Boolean)this.jclin)});
        }
    }

    @Override
    public final String toAncientFormat() {
        return this.getLeparm().replaceAll("REUS=(.*?)($|,)", "REUS($1)$2");
    }

    @Override
    public final String toName() {
        return this.hasFileName() ? this.getFileName().split("\\.")[0] : "";
    }

    @Override
    public final String toType() {
        return this.hasFileName() ? this.getFileName().split("\\.")[1] : "";
    }
}

