/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingEnumerations;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingItem;
import java.util.ArrayList;
import java.util.List;

public class PackagingDetails {
    private final IPackagingItem packagingItem;

    public PackagingDetails(IPackagingItem packagingItem) {
        this.packagingItem = packagingItem;
    }

    public final List<Boolean> getBinary() {
        return this.getCommand(new GetBinary());
    }

    public final List<String> getDescription() {
        return this.getCommand(new GetDescription());
    }

    public final List<String> getDistlib() {
        return this.getCommand(new GetDistlib());
    }

    public final List<String> getDistname() {
        return this.getCommand(new GetDistname());
    }

    public final List<String> getFmidoverride() {
        return this.getCommand(new GetFmidoverride());
    }

    public final List<IPackagingEnumerations.Id> getId() {
        return this.getCommand(new GetId());
    }

    public final List<String> getLocation() {
        return this.getCommand(new GetLocation());
    }

    public final List<String> getName() {
        return this.getCommand(new GetName());
    }

    public final List<IPackagingEnumerations.Mcstype> getMcstype() {
        return this.getCommand(new GetMcstype());
    }

    public final List<IPackagingEnumerations.Processor> getProcessor() {
        return this.getCommand(new GetProcessor());
    }

    public final List<String> getShipalias() {
        return this.getCommand(new GetShipalias());
    }

    public final List<String> getSyslib() {
        return this.getCommand(new GetSyslib());
    }

    public final List<String> getUuid() {
        return this.getCommand(new GetUuid());
    }

    public final List<Boolean> getBinary(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetBinary(), new RemoveBinary(), packagingDetail);
    }

    public final List<String> getDescription(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetDescription(), new RemoveDescription(), packagingDetail);
    }

    public final List<String> getDistlib(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetDistlib(), new RemoveDistlib(), packagingDetail);
    }

    public final List<String> getDistname(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetDistname(), new RemoveDistname(), packagingDetail);
    }

    public final List<String> getFmidoverride(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetFmidoverride(), new RemoveFmidoverride(), packagingDetail);
    }

    public final List<IPackagingEnumerations.Id> getId(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetId(), new RemoveId(), packagingDetail);
    }

    public final List<String> getLocation(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetLocation(), new RemoveLocation(), packagingDetail);
    }

    public final List<String> getName(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetName(), new RemoveName(), packagingDetail);
    }

    public final List<IPackagingEnumerations.Mcstype> getParttype(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetMcstype(), new RemoveMcstype(), packagingDetail);
    }

    public final List<IPackagingEnumerations.Processor> getProcessor(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetProcessor(), new RemoveProcessor(), packagingDetail);
    }

    public final List<String> getShipalias(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetShipalias(), new RemoveShipalias(), packagingDetail);
    }

    public final List<String> getSyslib(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetSyslib(), new RemoveSyslib(), packagingDetail);
    }

    public final List<String> getUuid(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetUuid(), new RemoveUuid(), packagingDetail);
    }

    private List<?> getCommand(GetCommand getCommand, RemoveCommand removeCommand, IPackagingDetail packagingDetail) {
        List<?> result = this.getCommand(getCommand);
        removeCommand.execute(result, packagingDetail);
        return result;
    }

    private List<?> getCommand(GetCommand getCommand) {
        ArrayList result = new ArrayList(this.packagingItem.getPackagingDetails().size());
        for (IPackagingDetail packagingDetail : this.packagingItem.getPackagingDetails()) {
            getCommand.execute(result, packagingDetail);
        }
        return result;
    }

    private class GetBinary
    implements GetCommand<Boolean> {
        private GetBinary() {
        }

        @Override
        public void execute(List<Boolean> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getBinary());
        }
    }

    private static interface GetCommand<L> {
        public void execute(List<L> var1, IPackagingDetail var2);
    }

    private class GetDescription
    implements GetCommand<String> {
        private GetDescription() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getDescription());
        }
    }

    private class GetDistlib
    implements GetCommand<String> {
        private GetDistlib() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getDistlib());
        }
    }

    private class GetDistname
    implements GetCommand<String> {
        private GetDistname() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getDistname());
        }
    }

    private class GetFmidoverride
    implements GetCommand<String> {
        private GetFmidoverride() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getFmidoverride());
        }
    }

    private class GetId
    implements GetCommand<IPackagingEnumerations.Id> {
        private GetId() {
        }

        @Override
        public void execute(List<IPackagingEnumerations.Id> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getId());
        }
    }

    private class GetLocation
    implements GetCommand<String> {
        private GetLocation() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getLocation());
        }
    }

    private class GetMcstype
    implements GetCommand<IPackagingEnumerations.Mcstype> {
        private GetMcstype() {
        }

        @Override
        public void execute(List<IPackagingEnumerations.Mcstype> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getMcstype());
        }
    }

    private class GetName
    implements GetCommand<String> {
        private GetName() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getName());
        }
    }

    private class GetProcessor
    implements GetCommand<IPackagingEnumerations.Processor> {
        private GetProcessor() {
        }

        @Override
        public void execute(List<IPackagingEnumerations.Processor> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getProcessor());
        }
    }

    private class GetShipalias
    implements GetCommand<String> {
        private GetShipalias() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getShipalias());
        }
    }

    private class GetSyslib
    implements GetCommand<String> {
        private GetSyslib() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getSyslib());
        }
    }

    private class GetUuid
    implements GetCommand<String> {
        private GetUuid() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getUuid());
        }
    }

    private class RemoveBinary
    implements RemoveCommand<Boolean> {
        private RemoveBinary() {
        }

        @Override
        public void execute(List<Boolean> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getBinary());
        }
    }

    private static interface RemoveCommand<L> {
        public void execute(List<L> var1, IPackagingDetail var2);
    }

    private class RemoveDescription
    implements RemoveCommand<String> {
        private RemoveDescription() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getDescription());
        }
    }

    private class RemoveDistlib
    implements RemoveCommand<String> {
        private RemoveDistlib() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getDistlib());
        }
    }

    private class RemoveDistname
    implements RemoveCommand<String> {
        private RemoveDistname() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getDistname());
        }
    }

    private class RemoveFmidoverride
    implements RemoveCommand<String> {
        private RemoveFmidoverride() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getFmidoverride());
        }
    }

    private class RemoveId
    implements RemoveCommand<IPackagingEnumerations.Id> {
        private RemoveId() {
        }

        @Override
        public void execute(List<IPackagingEnumerations.Id> result, IPackagingDetail packagingDetail) {
            result.remove((Object)packagingDetail.getId());
        }
    }

    private class RemoveLocation
    implements RemoveCommand<String> {
        private RemoveLocation() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getLocation());
        }
    }

    private class RemoveMcstype
    implements RemoveCommand<IPackagingEnumerations.Mcstype> {
        private RemoveMcstype() {
        }

        @Override
        public void execute(List<IPackagingEnumerations.Mcstype> result, IPackagingDetail packagingDetail) {
            result.remove((Object)packagingDetail.getMcstype());
        }
    }

    private class RemoveName
    implements RemoveCommand<String> {
        private RemoveName() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getName());
        }
    }

    private class RemoveProcessor
    implements RemoveCommand<IPackagingEnumerations.Processor> {
        private RemoveProcessor() {
        }

        @Override
        public void execute(List<IPackagingEnumerations.Processor> result, IPackagingDetail packagingDetail) {
            result.remove((Object)packagingDetail.getProcessor());
        }
    }

    private class RemoveShipalias
    implements RemoveCommand<String> {
        private RemoveShipalias() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getShipalias());
        }
    }

    private class RemoveSyslib
    implements RemoveCommand<String> {
        private RemoveSyslib() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getSyslib());
        }
    }

    private class RemoveUuid
    implements RemoveCommand<String> {
        private RemoveUuid() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getUuid());
        }
    }
}

