/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.AbstractDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDataset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PackagingDataset
extends AbstractDataSetDefinition
implements IDataSetDefinition,
IPackagingDataset {
    private final IDebugger dbg;
    private final String simpleName;
    private boolean dsDlibReference = false;
    private boolean dsTlibReference = false;
    private Set<String> dsDlibFmidList = new HashSet<String>();
    private Set<String> dsTlibFmidList = new HashSet<String>();

    public PackagingDataset() {
        this((IDebugger)new Debugger(PackagingDataset.class));
    }

    public PackagingDataset(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.init();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    private final void init() {
        super.setName("");
        super.setDescription("");
        super.setAdditionalParm("");
        super.setBlockSize("");
        super.setCompact(Boolean.parseBoolean("false"));
        super.setDataClass("");
        super.setDirectoryBlocks("");
        super.setDsMember("");
        super.setDsName("");
        super.setDsType(Integer.valueOf("0"));
        super.setExpirationDate("");
        super.setGenericUnit("");
        super.setManagementClass("");
        super.setPrefixDSN(Boolean.parseBoolean("true"));
        super.setPrimaryQuantity("");
        super.setRecordFormat("");
        super.setRecordLength("");
        super.setRecordUnit("0".charAt(0));
        super.setSecondaryQuantity("");
        super.setSpaceUnits("");
        super.setStorageClass("");
        super.setUsageType(Integer.valueOf("0"));
        super.setVolumeSerial("");
        this.dsDlibReference = false;
        this.dsTlibReference = false;
        this.dsDlibFmidList = new HashSet<String>();
        this.dsTlibFmidList = new HashSet<String>();
    }

    @Override
    protected ISystemDefinition newInstance() {
        return new PackagingDataset();
    }

    @Override
    public final boolean getCompact() {
        return this.isCompact();
    }

    @Override
    public final boolean getPrefixDSN() {
        return this.isPrefixDSN();
    }

    @Override
    public final Set<String> getDsDlibFmidList() {
        return this.dsDlibFmidList;
    }

    @Override
    public final boolean getDsDlibReference() {
        return this.dsDlibReference;
    }

    @Override
    public final Set<String> getDsTlibFmidList() {
        return this.dsTlibFmidList;
    }

    @Override
    public final boolean getDsTlibReference() {
        return this.dsTlibReference;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.getDescription());
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.getName());
    }

    @Override
    public final boolean hasAdditionalParm() {
        return Verification.isNonBlank((String)this.getAdditionalParm());
    }

    @Override
    public final boolean hasBlockSize() {
        return Verification.isNonBlank((String)this.getBlockSize());
    }

    @Override
    public final boolean hasDataClass() {
        return Verification.isNonBlank((String)this.getDataClass());
    }

    @Override
    public final boolean hasDirectoryBlocks() {
        return Verification.isNonBlank((String)this.getDirectoryBlocks());
    }

    @Override
    public final boolean hasDsMember() {
        return Verification.isNonBlank((String)this.getDsMember());
    }

    @Override
    public final boolean hasDsName() {
        return Verification.isNonBlank((String)this.getDsName());
    }

    @Override
    public final boolean hasExpirationDate() {
        return Verification.isNonBlank((String)this.getExpirationDate());
    }

    @Override
    public final boolean hasGenericUnit() {
        return Verification.isNonBlank((String)this.getGenericUnit());
    }

    @Override
    public final boolean hasManagementClass() {
        return Verification.isNonBlank((String)this.getManagementClass());
    }

    @Override
    public final boolean hasPrimaryQuantity() {
        return Verification.isNonBlank((String)this.getPrimaryQuantity());
    }

    @Override
    public final boolean hasRecordFormat() {
        return Verification.isNonBlank((String)this.getRecordFormat());
    }

    @Override
    public final boolean hasRecordLength() {
        return Verification.isNonBlank((String)this.getRecordLength());
    }

    @Override
    public final boolean hasSecondaryQuantity() {
        return Verification.isNonBlank((String)this.getSecondaryQuantity());
    }

    @Override
    public final boolean hasSpaceUnits() {
        return Verification.isNonBlank((String)this.getSpaceUnits());
    }

    @Override
    public final boolean hasStorageClass() {
        return Verification.isNonBlank((String)this.getStorageClass());
    }

    @Override
    public final boolean hasVolumeSerial() {
        return Verification.isNonBlank((String)this.getVolumeSerial());
    }

    @Override
    public final boolean hasDlibFmid(String fmid) {
        return this.dsDlibFmidList == null ? false : this.dsDlibFmidList.contains(fmid);
    }

    @Override
    public final boolean hasDsDlibFmidList() {
        return Verification.isNonEmpty((List)((List)((Object)this.dsDlibFmidList)));
    }

    @Override
    public final boolean hasTlibFmid(String fmid) {
        return this.dsTlibFmidList == null ? false : this.dsTlibFmidList.contains(fmid);
    }

    @Override
    public final boolean hasDsTlibFmidList() {
        return Verification.isNonEmpty((List)((List)((Object)this.dsTlibFmidList)));
    }

    @Override
    public final boolean isDlib() {
        return this.dsDlibReference;
    }

    @Override
    public final boolean isTlib() {
        return this.dsTlibReference;
    }

    @Override
    public final void setDescription(String description) {
        super.setDescription(description);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)description)});
        }
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)name)});
        }
    }

    @Override
    public final void setAdditionalParm(String additionalParm) {
        super.setAdditionalParm(additionalParm);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)additionalParm)});
        }
    }

    @Override
    public final void setBlockSize(String blockSize) {
        super.setBlockSize(blockSize);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)blockSize)});
        }
    }

    @Override
    public final void setCompact(boolean compact) {
        super.setCompact(compact);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)compact)});
        }
    }

    @Override
    public final void setDataClass(String dataClass) {
        super.setDataClass(dataClass);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)dataClass)});
        }
    }

    @Override
    public final void setDirectoryBlocks(String directoryBlocks) {
        super.setDirectoryBlocks(directoryBlocks);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)directoryBlocks)});
        }
    }

    @Override
    public final void setDsMember(String dsMember) {
        super.setDsMember(dsMember);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)dsMember)});
        }
    }

    @Override
    public final void setDsName(String dsName) {
        super.setDsName(dsName);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)dsName)});
        }
    }

    @Override
    public final void setDsType(int dsType) {
        super.setDsType(dsType);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)dsType)});
        }
    }

    @Override
    public final void setExpirationDate(String expirationDate) {
        super.setExpirationDate(expirationDate);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)expirationDate)});
        }
    }

    @Override
    public final void setGenericUnit(String genericUnit) {
        super.setGenericUnit(genericUnit);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)genericUnit)});
        }
    }

    @Override
    public final void setManagementClass(String managementClass) {
        super.setManagementClass(managementClass);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)managementClass)});
        }
    }

    @Override
    public final void setPrefixDSN(boolean prefixDSN) {
        super.setPrefixDSN(prefixDSN);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)prefixDSN)});
        }
    }

    @Override
    public final void setPrimaryQuantity(String primaryQuantity) {
        super.setPrimaryQuantity(primaryQuantity);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)primaryQuantity)});
        }
    }

    @Override
    public final void setRecordFormat(String recordFormat) {
        super.setRecordFormat(recordFormat);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)recordFormat)});
        }
    }

    @Override
    public final void setRecordLength(String recordLength) {
        super.setRecordLength(recordLength);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)recordLength)});
        }
    }

    @Override
    public final void setRecordUnit(char recordUnit) {
        super.setRecordUnit(recordUnit);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((char)recordUnit)});
        }
    }

    @Override
    public final void setSecondaryQuantity(String secondaryQuantity) {
        super.setSecondaryQuantity(secondaryQuantity);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)secondaryQuantity)});
        }
    }

    @Override
    public final void setSpaceUnits(String spaceUnits) {
        super.setSpaceUnits(spaceUnits);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)spaceUnits)});
        }
    }

    @Override
    public final void setStorageClass(String storageClass) {
        super.setStorageClass(storageClass);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)storageClass)});
        }
    }

    @Override
    public final void setUsageType(int usageType) {
        super.setUsageType(usageType);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)usageType)});
        }
    }

    @Override
    public final void setVolumeSerial(String volumeSerial) {
        super.setVolumeSerial(volumeSerial);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)volumeSerial)});
        }
    }

    @Override
    public final void setDsDlibFmidList(Set<String> dsDlibFmidList) {
        this.dsDlibFmidList = dsDlibFmidList;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)this.dsDlibFmidList.size())});
        }
    }

    @Override
    public final void setDsDlibReference(boolean dsDlibReference) {
        this.dsDlibReference = dsDlibReference;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.dsDlibReference)});
        }
    }

    @Override
    public final void setDsTlibFmidList(Set<String> dsTlibFmidList) {
        this.dsTlibFmidList = dsTlibFmidList;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)this.dsTlibFmidList.size())});
        }
    }

    @Override
    public final void setDsTlibReference(boolean dsTlibReference) {
        this.dsTlibReference = dsTlibReference;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.dsTlibReference)});
        }
    }

    @Override
    public final String toDsn(String prefix) {
        return this.isPrefixDSN() ? String.valueOf(prefix.toUpperCase()) + "." + this.getDsName().toUpperCase() : this.getDsName().toUpperCase();
    }

    @Override
    public final String toDsnMbr(String prefix, String member) {
        return this.isPrefixDSN() ? String.valueOf(prefix.toUpperCase()) + "." + this.getDsName().toUpperCase() + "(" + member.toUpperCase() + ")" : String.valueOf(this.getDsName().toUpperCase()) + "(" + member.toUpperCase() + ")";
    }

    @Override
    public final String toLibraryName() {
        return this.getDsName().split("\\.")[this.getDsName().split("\\.").length - 1].toUpperCase();
    }

    @Override
    public final String toQuotedDsn(String prefix) {
        return this.isPrefixDSN() ? "'" + prefix.toUpperCase() + "." + this.getDsName().toUpperCase() + "'" : "'" + this.getDsName().toUpperCase() + "'";
    }

    @Override
    public final String toQuotedDsnMbr(String prefix, String member) {
        return this.isPrefixDSN() ? "'" + prefix.toUpperCase() + "." + this.getDsName().toUpperCase() + "(" + member.toUpperCase() + ")" + "'" : "'" + this.getDsName().toUpperCase() + "(" + member.toUpperCase() + ")" + "'";
    }
}

