/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.enterprise.systemdefinition.common.IFunctionDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingFunction;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Packaging {
    public static final String className = Packaging.class.getSimpleName();

    public static final List<String> getArrayList(String s) {
        return new ArrayList<String>(Arrays.asList(s.split(",", s.contains(",") ? 1 + s.length() - s.replace(",", "").length() : 0)));
    }

    public static final String getLabel(IPackagingItem packagingItem) {
        if (packagingItem.getFolderNameExtended() == null) {
            return LogString.valueOf((Enum)packagingItem.getItemtype());
        }
        if (packagingItem.getFileName() == null) {
            return String.valueOf(LogString.valueOf((Enum)packagingItem.getItemtype())) + "/" + LogString.valueOf((String)packagingItem.getFolderNameExtended());
        }
        return String.valueOf(LogString.valueOf((Enum)packagingItem.getItemtype())) + ":" + LogString.valueOf((String)packagingItem.getFolderNameExtended()) + "/" + LogString.valueOf((String)packagingItem.getFileName());
    }

    public static final String[] getFmidArray(List functions) {
        String[] result = new String[functions.size() + 1];
        result[0] = "";
        int i = 1;
        while (i < functions.size() + 1) {
            result[i] = ((IPackagingFunction)functions.get(i - 1)).getId();
            ++i;
        }
        return result;
    }

    public static final int getFmidIndex(String[] functions, String item) {
        int i = 0;
        while (i < functions.length) {
            if (functions[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static final String[] getFmidItemArray(List functions) {
        String[] result = new String[functions.size() + 1];
        result[0] = "";
        int i = 1;
        while (i < functions.size() + 1) {
            result[i] = String.valueOf(((IPackagingFunction)functions.get(i - 1)).getId()) + " - " + ((IPackagingFunction)functions.get(i - 1)).getName();
            ++i;
        }
        return result;
    }

    public static final int getFmidItemIndex(String[] functions, String item) {
        int i = 0;
        while (i < functions.length) {
            if (functions[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static final String[] getFunctionArray(List<?> functions) {
        String[] result = new String[functions.size() + 1];
        result[0] = "";
        int i = 1;
        while (i < functions.size() + 1) {
            result[i] = ((IFunctionDefinition)functions.get(i - 1)).getName();
            ++i;
        }
        return result;
    }

    public static final int getFunctionIndex(List<?> functions, String uuid) {
        int i = 0;
        while (i < functions.size()) {
            if (((IFunctionDefinition)functions.get(i)).getUuid().equals(uuid)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public static final String getFunctionName(List<?> functions, String uuid) {
        for (Object o : functions) {
            IFunctionDefinition function = (IFunctionDefinition)o;
            if (!function.getUuid().equals(uuid)) continue;
            return function.getName();
        }
        return "";
    }

    public static final String getFunctionValue(List<?> functions, int i) {
        if (i > 0) {
            return ((IFunctionDefinition)functions.get(i - 1)).getUuid();
        }
        return null;
    }

    public static final boolean isFunction(List<?> functions, String uuid) {
        int i = 1;
        while (i < functions.size()) {
            if (((IFunctionDefinition)functions.get(i)).getUuid().equals(uuid)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

