/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.adapters;

import com.ibm.team.enterprise.systemdefinition.common.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.ITranslatorEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.IConcatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.ConcatenationAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.DDAllocationAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.DataDefinitionEntryAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.DataSetDefinitionAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.DependencyTypeAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.ISystemDefinitionAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.LanguageDefinitionAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.TranslatorAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.adapters.TranslatorEntryAdapter;
import com.ibm.team.enterprise.zos.systemdefinition.common.nls.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class SystemDefinitionAdapterFactory {
    private final Map<Class, ISystemDefinitionAdapter> adapterMap = new HashMap<Class, ISystemDefinitionAdapter>();
    private static SystemDefinitionAdapterFactory instance;

    public static SystemDefinitionAdapterFactory getInstance() {
        if (instance == null) {
            instance = new SystemDefinitionAdapterFactory();
        }
        return instance;
    }

    private SystemDefinitionAdapterFactory() {
        this.adapterMap.put(IConcatenation.class, new ConcatenationAdapter());
        this.adapterMap.put(IDataDefinitionEntry.class, new DataDefinitionEntryAdapter());
        this.adapterMap.put(IDataSetDefinition.class, new DataSetDefinitionAdapter());
        this.adapterMap.put(IDDAllocation.class, new DDAllocationAdapter());
        this.adapterMap.put(IDependencyType.class, new DependencyTypeAdapter());
        this.adapterMap.put(ILanguageDefinition.class, new LanguageDefinitionAdapter());
        this.adapterMap.put(ITranslatorEntry.class, new TranslatorEntryAdapter());
        this.adapterMap.put(ITranslator.class, new TranslatorAdapter());
    }

    public ISystemDefinitionAdapter getAdapter(Class aClass) throws NullPointerException {
        ISystemDefinitionAdapter adapter = null;
        Class interfaceClass = this.getInterface(aClass);
        if (interfaceClass != null) {
            adapter = this.adapterMap.get(interfaceClass);
        }
        if (adapter == null) {
            throw new NullPointerException(NLS.bind((String)Messages.ERROR_NO_ADAPTER_FOUND, (Object)aClass.getName()));
        }
        return adapter;
    }

    public ISystemDefinitionAdapter getAdapter(Object object) throws NullPointerException {
        return this.getAdapter(object.getClass());
    }

    private Class getInterface(Class aClass) {
        for (Class nextClass : this.adapterMap.keySet()) {
            try {
                if (!nextClass.isAssignableFrom(aClass)) continue;
                return nextClass;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

