/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.SystemDefinitionFactory;
import com.ibm.team.enterprise.zos.systemdefinition.common.IConcatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IHFSDD;
import com.ibm.team.enterprise.zos.systemdefinition.common.IZosLanguageDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IZosTranslator;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.Concatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.DDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.DataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.ExistingDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.HFSDD;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.OutputDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.SourceDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.TemporaryDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.ZosLanguageDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.ZosTranslator;

public class ZosSystemDefinitionFactory
extends SystemDefinitionFactory {
    public static IConcatenation createConcatenation() {
        return new Concatenation();
    }

    public static IDataDefinitionEntry createDataDefinitionEntry() {
        return new DataDefinitionEntry();
    }

    public static IDDAllocation createDDAllocation() {
        return new DDAllocation();
    }

    public static IHFSDD createHFSDD() {
        return new HFSDD();
    }

    public static IZosLanguageDefinition createLanguageDefinition() {
        return new ZosLanguageDefinition();
    }

    public static IDataSetDefinition createDataSetDefinition(int usageType) {
        switch (usageType) {
            case 0: {
                return ZosSystemDefinitionFactory.createSourceDataSetDefinition();
            }
            case 1: {
                return ZosSystemDefinitionFactory.createOutputDataSetDefinition();
            }
            case 2: {
                return ZosSystemDefinitionFactory.createTemporaryDataSetDefinition();
            }
            case 3: {
                return ZosSystemDefinitionFactory.createExistingDataSetDefinition();
            }
        }
        return ZosSystemDefinitionFactory.createSourceDataSetDefinition();
    }

    public static IDataSetDefinition createSourceDataSetDefinition() {
        return new SourceDataSetDefinition();
    }

    public static IDataSetDefinition createOutputDataSetDefinition() {
        return new OutputDataSetDefinition();
    }

    public static IDataSetDefinition createTemporaryDataSetDefinition() {
        return new TemporaryDataSetDefinition();
    }

    public static IDataSetDefinition createExistingDataSetDefinition() {
        return new ExistingDataSetDefinition();
    }

    public static IZosTranslator createTranslator() {
        return new ZosTranslator();
    }
}

