/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.validation;

import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.IProjectAreaNameRetriever;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionService;
import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionQueryGenerator;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.enterprise.systemdefinition.common.validation.SystemDefinitionValidationException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class DuplicateDefaultLanguageDefinitionValidator
implements ISystemDefinitionValidator {
    @Override
    public void validate(ISystemDefinition systemDefinition, ISystemDefinitionService systemDefinitionService, IProjectAreaNameRetriever projectAreaRetriever) throws SystemDefinitionValidationException, TeamRepositoryException {
        if (!systemDefinition.getType().equals("languagedefinition")) {
            return;
        }
        ILanguageDefinition languageDefinition = (ILanguageDefinition)systemDefinition;
        String defaultPatterns = languageDefinition.getDefaultPatterns();
        if (defaultPatterns == null || defaultPatterns.trim().equals("")) {
            return;
        }
        try {
            String[] patterns;
            String[] stringArray = patterns = defaultPatterns.trim().split(",");
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                String query = SystemDefinitionQueryGenerator.getSystemDefinitionsWithDefaultOptionsQuery(languageDefinition.getType(), pattern, false);
                String results = systemDefinitionService.runSelectQuery(query);
                SelectResultFeedParser parser = new SelectResultFeedParser();
                List selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
                for (SelectResult selectResult : selectResults) {
                    String[] foundPatternStrings;
                    String foundName = "";
                    String foundPatterns = null;
                    String foundUuid = null;
                    String foundProjectAreaUuid = "";
                    for (Binding binding : selectResult.getBindings()) {
                        if (binding.getName().equals("uuid")) {
                            foundUuid = binding.getValue();
                        }
                        if (binding.getName().equals("name")) {
                            foundName = binding.getValue();
                            continue;
                        }
                        if (binding.getName().equals("defaultPatterns")) {
                            foundPatterns = binding.getValue();
                            continue;
                        }
                        if (!binding.getName().equals("projectAreaUUID")) continue;
                        foundProjectAreaUuid = binding.getValue();
                    }
                    if (foundUuid == null || foundUuid.equals(systemDefinition.getUuid()) || foundPatterns == null) continue;
                    String[] stringArray2 = foundPatternStrings = foundPatterns.trim().split(",");
                    int n3 = foundPatternStrings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String foundPatternString = stringArray2[n4];
                        if (foundPatternString.equals(pattern)) {
                            throw new SystemDefinitionValidationException(NLS.bind((String)Messages.getCommonString("LanguageDefinitionError.7"), (Object[])new Object[]{foundName, projectAreaRetriever.getProjectAreaName(foundProjectAreaUuid), pattern}));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (SystemDefinitionValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TeamRepositoryException(e.getLocalizedMessage());
        }
    }
}

