/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.validation;

import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import java.util.ArrayList;
import java.util.List;

public class DefaultOptionsParser {
    private final List<OptionInfo> optionInfos = new ArrayList<OptionInfo>();
    private String optionStrings;

    public String getOptionStrings() {
        return this.optionStrings;
    }

    public void parseOptions(String optionStrings) {
        this.optionStrings = optionStrings;
        this.optionInfos.clear();
        for (String optionString : this.parseOptionAsStrings(optionStrings)) {
            this.optionInfos.add(this.parseOption(optionString));
        }
    }

    public OptionInfo getOption(String option) {
        OptionInfo testOptionInfo = this.parseOption(option);
        for (OptionInfo optionInfo : this.optionInfos) {
            if (!testOptionInfo.isSubset(optionInfo)) continue;
            return optionInfo;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private List<String> parseOptionAsStrings(String optionValues) {
        if (optionValues == null) {
            throw new IllegalArgumentException();
        }
        options = new ArrayList<String>();
        inClosedParen = false;
        inOpenParen = false;
        optionBuffer = new StringBuffer();
        var9_6 = optionValues.toCharArray();
        var8_7 = var9_6.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block6: {
                block5: {
                    ch = var9_6[var7_8];
                    if (ch != '(' || inOpenParen) break block5;
                    inOpenParen = true;
                    ** GOTO lbl-1000
                }
                if (ch != ')' || !inOpenParen || inClosedParen) break block6;
                inClosedParen = true;
                ** GOTO lbl-1000
            }
            if (ch == ',' && (inOpenParen && inClosedParen || !inOpenParen)) {
                options.add(optionBuffer.toString());
                optionBuffer = new StringBuffer();
                inOpenParen = false;
                inClosedParen = false;
            } else lbl-1000:
            // 3 sources

            {
                optionBuffer.append(ch);
            }
            ++var7_8;
        }
        if (optionBuffer.length() > 0) {
            options.add(optionBuffer.toString());
        }
        return options;
    }

    private OptionInfo parseOption(String optionString) {
        if (optionString == null || optionString.length() == 0) {
            throw new IllegalArgumentException(Messages.getCommonString("DefaultOptionsParser.Error.1"));
        }
        String temp = optionString.trim();
        int index = temp.indexOf("(");
        if (index == 0) {
            throw new IllegalArgumentException(Messages.getCommonString("DefaultOptionsParser.Error.2"));
        }
        if (index == -1) {
            if (temp.indexOf(41) > -1) {
                throw new IllegalArgumentException(Messages.getCommonString("DefaultOptionsParser.Error.3"));
            }
            return new OptionInfo(temp, new String[0]);
        }
        int index2 = temp.indexOf(")", index);
        if (index2 == -1) {
            throw new IllegalArgumentException(Messages.getCommonString("DefaultOptionsParser.Error.4"));
        }
        if (index2 < temp.length() - 1) {
            throw new IllegalArgumentException(Messages.getCommonString("DefaultOptionsParser.Error.5"));
        }
        if (index + 1 == index2) {
            return new OptionInfo(temp.substring(0, index), new String[0]);
        }
        String option = temp.substring(0, index);
        String subOptionValues = temp.substring(index + 1, index2);
        return new OptionInfo(option, subOptionValues.split(","));
    }

    public class OptionInfo {
        protected String option;
        protected String[] subOptions;

        public OptionInfo(String option, String[] subOptions) {
            this.option = option.toUpperCase();
            this.subOptions = new String[subOptions.length];
            int i = 0;
            while (i < subOptions.length) {
                this.subOptions[i] = subOptions[i].toUpperCase();
                ++i;
            }
        }

        public boolean isSubset(OptionInfo optionInfo) {
            if (optionInfo == this) {
                return true;
            }
            if (this.option.equalsIgnoreCase(optionInfo.option)) {
                String[] stringArray = this.subOptions;
                int n = this.subOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    String testSubOption = stringArray[n2];
                    if (!this.hasSubOption(testSubOption, optionInfo.subOptions)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        private boolean hasSubOption(String aSubOption, String[] subOptions) {
            String[] stringArray = subOptions;
            int n = subOptions.length;
            int n2 = 0;
            while (n2 < n) {
                String subOption = stringArray[n2];
                if (subOption.equalsIgnoreCase(aSubOption)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.option).append('(');
            int i = 0;
            while (i < this.subOptions.length) {
                buffer.append(this.subOptions[i]);
                if (i + 1 < this.subOptions.length) {
                    buffer.append(',');
                }
                ++i;
            }
            buffer.append(')');
            return buffer.toString();
        }

        public String getOption() {
            return this.option;
        }

        public String[] getSubOptions() {
            return this.subOptions;
        }

        public boolean hasSubOption(String aSubOption) {
            return this.hasSubOption(aSubOption, this.subOptions);
        }

        public int getSubOptionCount() {
            return this.subOptions.length;
        }
    }
}

