/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.validation;

import com.ibm.team.enterprise.systemdefinition.common.MemberNamePattern;
import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.util.VariableUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractTranslatorValidator {
    private List<String> errorMessages = null;
    private static final String PLUGIN_ID = "com.ibm.team.enterprise.systemdefinition.common";
    private static final Pattern antPropertyPattern = Pattern.compile("@|\\$\\{[^\\{\\}]+\\}");

    public IStatus validatePatternOrVariable(String pattern, List<IVariable> translatorVariables) {
        return this.validatePatternOrVariable(pattern, translatorVariables, false);
    }

    public IStatus validatePatternOrVariable(String pattern, List<IVariable> translatorVariables, Boolean isSequential) {
        IStatus validationStatus = null;
        this.clearErrorMessages();
        validationStatus = this.runCommonPatternOrVariableValidation(pattern, translatorVariables, isSequential);
        if (validationStatus.getSeverity() < 4 && !this.runPlatformValidation(pattern, translatorVariables)) {
            return new Status(4, PLUGIN_ID, this.getErrorMessages().get(0));
        }
        return validationStatus;
    }

    public String getErrorMsgVariableInDeployType(String deployType, List<IVariable> translatorVariables, boolean isIBMi) {
        String errorMsg = null;
        if (deployType != null && deployType.indexOf(38) > -1) {
            if (!VariableUtils.isValidVariableName(deployType, true)) {
                errorMsg = NLS.bind((String)Messages.getCommonString("TranslatorError_ErrorVariableCombined"), (Object)VariableUtils.getVariableNameWithoutPrefix(deployType));
            } else if (isIBMi && VariableUtils.isReservedVariableName(deployType)) {
                errorMsg = NLS.bind((String)Messages.getCommonString("TranslatorError_ReservedVariableUsedAsDeployType"), (Object)VariableUtils.getVariableNameWithoutPrefix(deployType));
            } else if (!VariableUtils.isDefinedVariable(deployType, translatorVariables)) {
                errorMsg = NLS.bind((String)Messages.getCommonString("TranslatorError_UndefinedVariableInDeployType"), (Object)VariableUtils.getVariableNameWithoutPrefix(deployType));
            }
        }
        return errorMsg;
    }

    public void clearErrorMessages() {
        this.errorMessages = null;
    }

    private IStatus runCommonPatternOrVariableValidation(String patternOrVariable, List<IVariable> translatorVariables, Boolean isSequential) {
        String errorMessage = "";
        String variableValue = null;
        if (patternOrVariable.indexOf("&") > -1) {
            if (VariableUtils.isValidVariableName(patternOrVariable, true)) {
                if (VariableUtils.isReservedVariableName(patternOrVariable)) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.getCommonString("TranslatorError_ReservedVariableUsedAsPattern"), (Object)VariableUtils.getVariableNameWithoutPrefix(patternOrVariable)));
                }
                if (!VariableUtils.isDefinedVariable(patternOrVariable, translatorVariables)) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.getCommonString("TranslatorError_UndefinedVariableInRename"), (Object)VariableUtils.getVariableNameWithoutPrefix(patternOrVariable)));
                }
                variableValue = VariableUtils.getVariableValue(patternOrVariable, translatorVariables);
            } else {
                return new Status(4, PLUGIN_ID, Messages.getCommonString("TranslatorError_ErrorVariableCombined"));
            }
        }
        try {
            if (variableValue != null) {
                errorMessage = String.valueOf(NLS.bind((String)Messages.getCommonString("TranslatorError_RenameVariableInvalidPattern"), (Object)VariableUtils.getVariableNameWithoutPrefix(patternOrVariable))) + " ";
                if (this.isAntPropertyOrAttribute(variableValue)) {
                    this.doPatternValidation(this.replaceAntPropertyOrAttribute(variableValue), true);
                    return new Status(1, PLUGIN_ID, Messages.getCommonString("TranslatorInfo_UsingAntProp"));
                }
                this.doPatternValidation(variableValue, false);
            } else if (!isSequential.booleanValue()) {
                if (this.isAntPropertyOrAttribute(patternOrVariable)) {
                    this.doPatternValidation(this.replaceAntPropertyOrAttribute(patternOrVariable), true);
                    return new Status(1, PLUGIN_ID, Messages.getCommonString("TranslatorInfo_UsingAntProp"));
                }
                this.doPatternValidation(patternOrVariable, false);
            }
        }
        catch (Exception e) {
            return new Status(4, PLUGIN_ID, String.valueOf(errorMessage) + e.getMessage());
        }
        return Status.OK_STATUS;
    }

    public boolean isAntPropertyOrAttribute(String string) {
        return string != null && antPropertyPattern.matcher(string).find();
    }

    public String replaceAntPropertyOrAttribute(String string) {
        Matcher m = antPropertyPattern.matcher(string);
        return m.replaceAll("");
    }

    private void doPatternValidation(String pattern, boolean allowShortStrings) throws Exception {
        if (pattern != null) {
            MemberNamePattern mnp = this.getMemberNamePatternObject();
            mnp.validate(pattern, allowShortStrings);
        }
    }

    protected abstract boolean runPlatformValidation(String var1, List<IVariable> var2);

    protected abstract MemberNamePattern getMemberNamePatternObject();

    protected void addErrorMessage(String newErrorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(newErrorMessage);
    }

    protected List<String> getErrorMessages() {
        return this.errorMessages;
    }
}

