/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.validation;

import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.enterprise.systemdefinition.common.IProjectAreaNameRetriever;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionService;
import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionQueryGenerator;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.enterprise.systemdefinition.common.validation.SystemDefinitionValidationException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDuplicateSystemDefinitionNameValidator
implements ISystemDefinitionValidator {
    @Override
    public void validate(ISystemDefinition systemDefinition, ISystemDefinitionService systemDefinitionService, IProjectAreaNameRetriever projectAreaRetriever) throws SystemDefinitionValidationException, TeamRepositoryException {
        if (this.isCorrectType(systemDefinition)) {
            String query = SystemDefinitionQueryGenerator.getSystemDefinitionUUIDQuery(systemDefinition.getName(), this.getType());
            try {
                String results = systemDefinitionService.runSelectQuery(query);
                SelectResultFeedParser parser = new SelectResultFeedParser();
                List selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
                Iterator iterator = selectResults.iterator();
                if (iterator.hasNext()) {
                    SelectResult selectResult = (SelectResult)iterator.next();
                    String foundUuid = null;
                    String foundProjectAreaUuid = "";
                    String foundProjectAreaName = "";
                    for (Binding binding : selectResult.getBindings()) {
                        if (binding.getName().equals("uuid")) {
                            foundUuid = binding.getValue();
                            continue;
                        }
                        if (!binding.getName().equals("projectAreaUUID") || projectAreaRetriever == null) continue;
                        foundProjectAreaUuid = binding.getValue();
                        foundProjectAreaName = projectAreaRetriever.getProjectAreaName(foundProjectAreaUuid);
                    }
                    if (foundUuid != null && !systemDefinition.isNew() && foundUuid.equals(systemDefinition.getUuid())) {
                        return;
                    }
                    throw new SystemDefinitionValidationException(this.getErrorMessage(systemDefinition, foundProjectAreaName));
                }
            }
            catch (SystemDefinitionValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isCorrectType(ISystemDefinition systemDefinition) {
        return systemDefinition.getType().equals(this.getType());
    }

    protected abstract String getType();

    protected String getErrorMessage(ISystemDefinition systemDefinition, String projectAreaName) {
        return NLS.bind((String)Messages.getCommonString("SystemDefinitionError.8"), (Object)systemDefinition.getName(), (Object)projectAreaName);
    }
}

