/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util.zos;

import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDelta;
import com.ibm.team.enterprise.systemdefinition.common.dto.DTOFactory;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.CompareListResult;
import com.ibm.team.enterprise.systemdefinition.common.util.zos.IZosSystemDefinitionUtil;
import java.util.ArrayList;
import java.util.List;

public class ZosChangeLogUtil
extends ChangeLogUtil {
    public static void generateCallMethodChangeLogDelta(ChangeLogDTO changeLog, IZosTranslator oldTranslator, IZosTranslator newTranslator) {
        if (newTranslator == null) {
            return;
        }
        Integer oldCallMethod = null;
        IDataSetDefinitionHandle oldDataUUID = null;
        String oldDefaultOptions = null;
        String oldDBNameList = null;
        String oldCommandM = null;
        Integer newCallMethod = newTranslator.getCallMethod();
        IDataSetDefinitionHandle newDataUUID = null;
        String newDefaultOptions = null;
        String newDBNameList = null;
        String newCommandM = null;
        boolean needDiffProgram = false;
        boolean needDiffCommand = false;
        if (oldTranslator != null) {
            oldCallMethod = oldTranslator.getCallMethod();
        }
        if (oldCallMethod != null) {
            if (oldCallMethod == 0) {
                oldDataUUID = oldTranslator.getDataSetDefinition();
                oldDefaultOptions = oldTranslator.getDefaultOptions();
                oldDBNameList = oldTranslator.getDdNameList();
            } else {
                oldCommandM = oldTranslator.getCommandMember();
            }
        }
        if (newCallMethod == 0) {
            newDataUUID = newTranslator.getDataSetDefinition();
            newDefaultOptions = newTranslator.getDefaultOptions();
            newDBNameList = newTranslator.getDdNameList();
            if (oldCallMethod != null && oldCallMethod == 0) {
                needDiffProgram = true;
            }
        } else {
            newCommandM = newTranslator.getCommandMember();
            if (oldCallMethod != null && oldCallMethod != 0) {
                needDiffCommand = true;
            }
        }
        ZosChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_CALL_METHOD_TAG.getWholeTagName(), oldCallMethod, newCallMethod, null, false, false);
        if (newCallMethod == 0) {
            ZosChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG.getWholeTagName(), oldDataUUID == null ? null : oldDataUUID.getItemId().getUuidValue(), newDataUUID == null ? null : newDataUUID.getItemId().getUuidValue(), DeltaType.UUID, false, false);
            ZosChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_DEFAULT_OPTIONS_TAG.getWholeTagName(), oldDefaultOptions, newDefaultOptions, needDiffProgram, oldTranslator == null);
            ZosChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_DDNAME_LIST_TAG.getWholeTagName(), oldDBNameList, newDBNameList, needDiffProgram, oldTranslator == null);
        } else if (3 == newCallMethod) {
            ZosChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_ANT_SCRIPT_TAG.getWholeTagName(), oldCommandM, newCommandM, needDiffCommand, oldTranslator == null);
        } else {
            ZosChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_COMMAND_MEMBER_TAG.getWholeTagName(), oldCommandM, newCommandM, needDiffCommand, oldTranslator == null);
        }
    }

    public static void generateDDConcantenationChangeLogDelta(ChangeLogDTO changeLog, String id, List<IConcatenation> oldConcats, List<IConcatenation> newConcats, boolean isNew) {
        if (changeLog == null || newConcats == null) {
            return;
        }
        CompareListResult<IConcatenation> ddConcatsResluts = new CompareListResult<IConcatenation>(){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IConcatenation oldOne, IConcatenation newOne, boolean isNew, DeltaType type) {
                if (newOne == null) {
                    return;
                }
                CompareListResult<IDataDefinitionEntry> ddConcatsResluts = new CompareListResult<IDataDefinitionEntry>(){

                    @Override
                    protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IDataDefinitionEntry oldOne, IDataDefinitionEntry newOne, boolean isNew, DeltaType type) {
                        if (newOne == null) {
                            return;
                        }
                        boolean isTextDiff = false;
                        String oldValue = null;
                        String oldKind = null;
                        Boolean oldIsMember = null;
                        if (oldOne != null) {
                            oldValue = oldOne.getValue();
                            oldKind = oldOne.getKind();
                            oldIsMember = oldOne.isMember();
                        }
                        String newValue = newOne.getValue();
                        String newKind = newOne.getKind();
                        boolean newIsMember = newOne.isMember();
                        if (DeltaType.CHANGE == type && newKind.equals(oldKind)) {
                            if (newValue.equals(oldValue)) {
                                oldValue = null;
                            } else {
                                isTextDiff = true;
                            }
                        }
                        ArrayList subChanges = new ArrayList();
                        ZosChangeLogUtil.generateDDEntryDeltas(subChanges, oldValue, newValue, oldKind, newKind, oldIsMember, newIsMember, isTextDiff, isNew);
                        if (subChanges.size() > 0) {
                            ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                            vChangeDelta.setId(IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG.getWholeTagName());
                            vChangeDelta.setType(type);
                            vChangeDelta.getSubChanges().addAll(subChanges);
                            resultDeltas.add(vChangeDelta);
                        }
                    }

                    @Override
                    protected void generateChangedLists(List<IDataDefinitionEntry> fromList, List<IDataDefinitionEntry> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                        if (fromList == null || checkList == null) {
                            return;
                        }
                        for (IDataDefinitionEntry from : fromList) {
                            String value = from.getValue();
                            IDataDefinitionEntry founded = null;
                            for (IDataDefinitionEntry check : checkList) {
                                if (value == null || !value.equals(check.getValue()) || from.equals(check)) continue;
                                founded = check;
                            }
                            if (founded == null) continue;
                            fromChangeList.add(from);
                            checkChangeList.add(founded);
                        }
                    }
                };
                ArrayList<ChangeLogDelta> subChanges = new ArrayList<ChangeLogDelta>();
                String newCondition = newOne.getCondition();
                String oldCondition = null;
                if (oldOne != null) {
                    oldCondition = oldOne.getCondition();
                }
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_CONDITION_TAG.getWholeTagName(), oldCondition, newCondition, null, false, false);
                ddConcatsResluts.generateListChangeLogDelta(subChanges, null, oldOne == null ? null : oldOne.getDataDefinitionEntries(), newOne.getDataDefinitionEntries(), isNew || DeltaType.ADD == type || DeltaType.DELETE == type, type);
                if (subChanges.size() > 0 || DeltaType.ADD == type || DeltaType.DELETE == type) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    ZosChangeLogUtil.generateChangeLogDelta(vChangeDelta.getSubChanges(), null, null, newOne.getName(), false, isNew);
                    vChangeDelta.getSubChanges().addAll(subChanges);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IConcatenation> fromList, List<IConcatenation> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromList == null || checkList == null) {
                    return;
                }
                ArrayList<IConcatenation> remainingCheckList = new ArrayList<IConcatenation>(checkList);
                for (IConcatenation from : fromList) {
                    String name = from.getName();
                    IConcatenation founded = null;
                    for (IConcatenation check : remainingCheckList) {
                        if (name == null || !name.equals(check.getName())) continue;
                        remainingCheckList.remove(check);
                        if (from.equals(check)) break;
                        founded = check;
                        break;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        ddConcatsResluts.generateListChangeLogDelta((List<ChangeLogDelta>)changeLog.getChanges(), id, oldConcats, newConcats, isNew, null);
    }

    private static void generateDDEntryDeltas(List<ChangeLogDelta> subChanges, String oldValue, String newValue, String oldKind, String newKind, Boolean oldIsMember, boolean newIsMember, boolean isTextDiff, boolean isNew) {
        if (newKind == null || subChanges == null) {
            return;
        }
        if (newKind.equals(oldKind)) {
            if ("com.ibm.teamz.langdef.entry.data_definition".equals(newKind)) {
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG.getWholeTagName(), oldValue, newValue, DeltaType.UUID, false, false);
            } else {
                ZosChangeLogUtil.generateChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG.getWholeTagName(), oldValue, newValue, isTextDiff, isNew);
            }
        } else {
            ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG.getWholeTagName(), oldValue, newValue, DeltaType.UUID, false, false);
        }
        ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TYPE_TAG.getWholeTagName(), oldKind, newKind, null, true, false);
        ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_MEMBER_TAG.getWholeTagName(), oldIsMember, newIsMember, null, false, false);
    }

    public static void generateDDAllocationChangeLogDelta(ChangeLogDTO changeLog, String id, List<IDDAllocation> oldAllocations, List<IDDAllocation> newAllocations, boolean isNew) {
        if (changeLog == null || newAllocations == null) {
            return;
        }
        CompareListResult<IDDAllocation> ddAllocationResluts = new CompareListResult<IDDAllocation>(){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IDDAllocation oldOne, IDDAllocation newOne, boolean isNew, DeltaType type) {
                ChangeLogDelta vChangeDelta;
                if (newOne == null) {
                    return;
                }
                String oldDDValue = null;
                String oldDDKind = null;
                Boolean oldIsMember = null;
                String oldOutName = null;
                String oldCondition = null;
                OutputNameKind oldOutKind = null;
                Boolean oldIsKeep = null;
                Boolean oldIsMod = null;
                Boolean oldIsOutput = null;
                String oldPublishType = null;
                String oldConsolidate = null;
                String oldCompact = null;
                Boolean oldIsSequential = null;
                Boolean oldUsedAsInput = null;
                if (oldOne != null) {
                    IDataDefinitionEntry oldDDEntry = oldOne.getDataDefinitionEntry();
                    if (oldDDEntry != null) {
                        oldDDValue = oldDDEntry.getValue();
                        oldDDKind = oldDDEntry.getKind();
                    }
                    oldIsMember = oldOne.isMember();
                    oldOutName = oldOne.getOutputName();
                    oldCondition = oldOne.getCondition();
                    oldOutKind = oldOne.getOutputNameKind();
                    oldIsKeep = oldOne.isKeep();
                    oldIsMod = oldOne.isMod();
                    oldIsOutput = oldOne.isOutput();
                    oldPublishType = String.valueOf(oldOne.getPublishType());
                    oldConsolidate = String.valueOf(oldOne.getConsolidateLog());
                    oldCompact = String.valueOf(oldOne.getCompact());
                    oldIsSequential = oldOne.isSequential();
                    oldUsedAsInput = oldOne.isUsedAsInput();
                }
                String newDDValue = null;
                String newDDKind = null;
                IDataDefinitionEntry newDDEntry = newOne.getDataDefinitionEntry();
                if (newDDEntry != null) {
                    newDDValue = newDDEntry.getValue();
                    newDDKind = newDDEntry.getKind();
                }
                boolean newIsMember = newOne.isMember();
                String newOutName = newOne.getOutputName();
                String newCondition = newOne.getCondition();
                OutputNameKind newOutKind = newOne.getOutputNameKind();
                boolean newIsKeep = newOne.isKeep();
                boolean newIsMod = newOne.isMod();
                boolean newIsOutput = newOne.isOutput();
                String newPublishType = String.valueOf(newOne.getPublishType());
                String newConsolidate = String.valueOf(newOne.getConsolidateLog());
                String newCompact = String.valueOf(newOne.getCompact());
                boolean newIsSequential = newOne.isSequential();
                boolean newUsedAsInput = newOne.isUsedAsInput();
                boolean isDDEntryDiff = false;
                if (DeltaType.CHANGE == type && newDDKind != null && newDDKind.equals(oldDDKind)) {
                    isDDEntryDiff = true;
                }
                ArrayList<ChangeLogDelta> subChanges = new ArrayList<ChangeLogDelta>();
                ArrayList ddChanges = new ArrayList();
                ZosChangeLogUtil.generateDDEntryDeltas(ddChanges, oldDDValue, newDDValue, oldDDKind, newDDKind, false, false, isDDEntryDiff, isNew);
                if (ddChanges.size() > 0) {
                    vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    vChangeDelta.getSubChanges().addAll(ddChanges);
                    subChanges.add(vChangeDelta);
                }
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MEMBER_TAG.getWholeTagName(), oldIsMember, newIsMember, null, false, false);
                ZosChangeLogUtil.generateChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_TAG.getWholeTagName(), oldOutName, newOutName, DeltaType.CHANGE == type, isNew);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_KIND_TAG.getWholeTagName(), (Object)oldOutKind, (Object)newOutKind, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONDITION_TAG.getWholeTagName(), oldCondition, newCondition, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_KEEP_TAG.getWholeTagName(), oldIsKeep, newIsKeep, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MOD_TAG.getWholeTagName(), oldIsMod, newIsMod, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_TAG.getWholeTagName(), oldIsOutput, newIsOutput, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TYPE_TAG.getWholeTagName(), oldPublishType, newPublishType, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONSOLIDATE_LOG_TAG.getWholeTagName(), oldConsolidate, newConsolidate, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_COMPACT_TAG.getWholeTagName(), oldCompact, newCompact, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_USEDASINPUT_TAG.getWholeTagName(), oldUsedAsInput, newUsedAsInput, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_SEQUENTIAL_TAG.getWholeTagName(), oldIsSequential, newIsSequential, null, false, false);
                ZosChangeLogUtil.addValuesChangeLogDelta(subChanges, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_DEPLOYTYPE_TAG.getWholeTagName(), oldIsOutput, newIsOutput, null, false, false);
                if (subChanges.size() > 0) {
                    vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    ZosChangeLogUtil.generateChangeLogDelta(vChangeDelta.getSubChanges(), null, null, newOne.getName(), false, isNew);
                    vChangeDelta.getSubChanges().addAll(subChanges);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IDDAllocation> fromList, List<IDDAllocation> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromChangeList == null || checkChangeList == null) {
                    return;
                }
                ArrayList<IDDAllocation> remainingCheckList = new ArrayList<IDDAllocation>(checkList);
                for (IDDAllocation from : fromList) {
                    String name = from.getName();
                    IDDAllocation founded = null;
                    for (IDDAllocation check : remainingCheckList) {
                        if (name == null || !name.equals(check.getName())) continue;
                        remainingCheckList.remove(check);
                        if (from.equals(check)) break;
                        founded = check;
                        break;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        ddAllocationResluts.generateListChangeLogDelta((List<ChangeLogDelta>)changeLog.getChanges(), id, oldAllocations, newAllocations, isNew, null);
    }
}

