/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.util.Constants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariableUtils {
    private static final char AMPERSAND = '&';

    public static String getVariableNameWithoutPrefix(String variableNameWithPrefix) {
        String variableName = VariableUtils.removeVariablePrefix(variableNameWithPrefix);
        if (variableName != null && !variableName.isEmpty()) {
            if (VariableUtils.isValidVariableName(variableName, false)) {
                return variableName.toUpperCase();
            }
            return null;
        }
        return null;
    }

    private static String removeVariablePrefix(String variableNameWithPrefix) {
        if (variableNameWithPrefix != null && !variableNameWithPrefix.isEmpty()) {
            if (variableNameWithPrefix.charAt(0) == '&') {
                return variableNameWithPrefix.substring(1).toUpperCase();
            }
            return variableNameWithPrefix.toUpperCase();
        }
        return null;
    }

    public static String getVariableNameWithPrefix(String variableName) {
        if (variableName != null && !variableName.isEmpty()) {
            if (variableName.charAt(0) == '&' && VariableUtils.isValidVariableName(variableName, true)) {
                return variableName.toUpperCase();
            }
            if (VariableUtils.isValidVariableName(variableName, false)) {
                return String.valueOf('&') + variableName.toUpperCase();
            }
            return null;
        }
        return null;
    }

    public static String getVariableValue(String variableName, List<IVariable> vars) {
        if ((variableName = VariableUtils.getVariableNameWithoutPrefix(variableName)) != null && vars != null) {
            for (IVariable v : vars) {
                if (!v.getName().equalsIgnoreCase(variableName)) continue;
                return v.getValue();
            }
        }
        return null;
    }

    public static boolean isDefinedVariable(String variableName, List<IVariable> vars) {
        if (vars != null & variableName != null && (variableName = VariableUtils.getVariableNameWithoutPrefix(variableName)) != null) {
            for (IVariable var : vars) {
                if (!variableName.equalsIgnoreCase(var.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList<String> getVariablesUsed(String command) {
        return VariableUtils.getVariablesUsed(command, true);
    }

    public static ArrayList<String> getVariablesUsed(String command, boolean includeReservedVariables) {
        ArrayList<String> varList = new ArrayList<String>();
        int commandLength = command.length();
        int i = 0;
        while (i < commandLength) {
            if (command.charAt(i) == '&') {
                String var = "";
                int j = i + 1;
                while (j < commandLength) {
                    char c = command.charAt(j);
                    if (Character.isLetterOrDigit(c) || c == '_') {
                        var = String.valueOf(var) + c;
                        if (j == commandLength - 1 && (!VariableUtils.isReservedVariableName(var) || includeReservedVariables)) {
                            varList.add(var);
                            i = j;
                        }
                    } else {
                        if (!(var.equals("") || VariableUtils.isReservedVariableName(var) && !includeReservedVariables)) {
                            varList.add(var);
                        }
                        if (c == '&') {
                            i = j - 1;
                            break;
                        }
                        i = j;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return varList;
    }

    public static ArrayList<String> undefinedVariablesUsed(String command, List<IVariable> vars) {
        ArrayList<String> varNames = new ArrayList<String>();
        ArrayList<String> undefinedVars = new ArrayList<String>();
        for (IVariable v : vars) {
            varNames.add(v.getName().toUpperCase());
        }
        ArrayList<String> varsInCommand = VariableUtils.getVariablesUsed(command, false);
        for (String var : varsInCommand) {
            if (VariableUtils.containsIgnoreCase(varNames, var)) continue;
            undefinedVars.add(var);
        }
        if (!undefinedVars.isEmpty()) {
            return undefinedVars;
        }
        return null;
    }

    public static ArrayList<String> reservedVariablesUsed(String command) {
        ArrayList<String> varsInCommand = VariableUtils.getVariablesUsed(command, true);
        ArrayList<String> reservedVarsUsed = new ArrayList<String>();
        for (String var : varsInCommand) {
            if (!VariableUtils.isReservedVariableName(var)) continue;
            reservedVarsUsed.add(var);
        }
        if (!reservedVarsUsed.isEmpty()) {
            return reservedVarsUsed;
        }
        return null;
    }

    public static boolean isReservedVariableName(String variableName) {
        String myVariableName = VariableUtils.removeVariablePrefix(variableName);
        if (myVariableName != null) {
            String[] stringArray = Constants.reservedVariableNames;
            int n = Constants.reservedVariableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String reservedVar = stringArray[n2];
                if (myVariableName.equalsIgnoreCase(reservedVar)) {
                    return true;
                }
                ++n2;
            }
            stringArray = Constants.reservedVariableSuffixes;
            n = Constants.reservedVariableSuffixes.length;
            n2 = 0;
            while (n2 < n) {
                String reservedSuffix = stringArray[n2];
                if (myVariableName.toUpperCase().endsWith(reservedSuffix.toUpperCase())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isValidVariableName(String varName, boolean prefixed) {
        boolean rc = true;
        if (!VariableUtils.isReservedVariableName(varName)) {
            if (varName != null && !varName.isEmpty()) {
                if (varName.indexOf(38) != varName.lastIndexOf(38)) {
                    rc = false;
                } else if (prefixed && varName.lastIndexOf(38) != 0) {
                    rc = false;
                } else if (VariableUtils.containsWhitespace(varName)) {
                    rc = false;
                } else if (!VariableUtils.isAlphanumeric(varName) && (!prefixed || prefixed && varName.charAt(0) != '&' || prefixed && varName.substring(1).isEmpty() || !VariableUtils.isAlphanumeric(varName.substring(1)))) {
                    rc = false;
                }
            } else {
                rc = false;
            }
        }
        return rc;
    }

    private static boolean containsIgnoreCase(ArrayList<String> list, String s) {
        if (list != null && s != null) {
            Iterator<String> i = list.iterator();
            while (i.hasNext()) {
                if (!i.next().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAlphanumeric(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsWhitespace(String str) {
        return str.contains(" ") || str.contains("\n") || str.contains("\t");
    }
}

