/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.Namespace;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;

public abstract class SystemDefinitionUtil {
    public static final Namespace SYSTEMDEFINITION_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/systemdefinition/", "systemdefinition");
    public static final Namespace LANGUAGEDEFINITION_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/languagedefinition/", "languagedefinition");
    public static final Namespace LANGUAGEEXTENSION_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/languageextension/", "languageextension");
    public static final Namespace TRANSLATOR_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/translator/", "translator");
    public static final Namespace RESOURCEDEFINITION_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/resourcedefinition/", "resourcedefinition");
    public static final Namespace SEARCHPATH_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/searchpath/", "searchpath");
    public static final Namespace FUNCTIONDEFINITION_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/functiondefinition/", "functiondefinition");
    public static final Namespace VERSIONDEFINITION_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/versiondefinition/", "versiondefinition");
    public static final Namespace XPATHFUNCTION_NAMESPACE = new Namespace("http://www.w3.org/2005/xpath-functions#", "fn");
    public static final Namespace RDF_NAMESPACE = new Namespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
    public static final String COLON = ":";
    public static final Namespace XMLNS_NAMESPACE = new Namespace("http://www.w3.org/2000/xmlns/", "xmlns");
    public static final TagWithNS RDF_RDF_TAG = new TagWithNS(RDF_NAMESPACE, "RDF");
    public static final TagWithNS RDF_DESCRIPTION_TAG = new TagWithNS(RDF_NAMESPACE, "Description");
    public static final TagWithNS RDF_ABOUT_TAG = new TagWithNS(RDF_NAMESPACE, "about");
    public static final TagWithNS RDF_PARSETYPE_TAG = new TagWithNS(RDF_NAMESPACE, "parseType");
    public static final TagWithNS RDF_NODEID_TAG = new TagWithNS(RDF_NAMESPACE, "nodeID");
    public static final String RESOURCE = "Resource";
    public static final String LITERAL = "Literal";
    public static final TagWithNS SYSTEM_DEF_PROJECT_AREA_UUID_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "projectAreaUUID");
    public static final TagWithNS SYSTEM_DEF_NAME_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "name");
    public static final TagWithNS SYSTEM_DEF_DESCRIPTION_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "description");
    public static final TagWithNS SYSTEM_DEF_TYPE_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "type");
    public static final TagWithNS SYSTEM_DEF_PLATFORM_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "platform");
    public static final TagWithNS SYSTEM_DEF_UUID_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "uuid");
    public static final TagWithNS SYSTEM_DEF_STATE_UUID_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "stateUUID");
    public static final TagWithNS SYSTEM_DEF_ARCHIVED_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "archived");
    public static final TagWithNS SYSTEM_DEF_MIGRATED_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "migrated");
    public static final TagWithNS SYSTEM_DEF_PROPERTIES_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "properties");
    public static final TagWithNS SYSTEM_DEF_PROPERTY_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "property");
    public static final TagWithNS SYSTEM_DEF_PROPERTY_NAME_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "name");
    public static final TagWithNS SYSTEM_DEF_PROPERTY_VALUE_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "value");
    public static final TagWithNS SYSTEM_DEF_NON_IMPACTING_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "nonImpacting");
    public static final TagWithNS SYSTEM_DEF_IGNOREONCE_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "ignoredOnceForBuild");
    public static final TagWithNS SYSTEM_DEF_MIGRATEDITEMID_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "migratedItemId");
    public static final TagWithNS SYSTEM_DEF_MIGRATEDSTATEID_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "migratedStateId");
    public static final TagWithNS LANGUAGE_DEF_CALCULATE_IMPACTS_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "calculateImpacts");
    public static final TagWithNS LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "consolidateLogs");
    public static final TagWithNS LANGUAGE_DEF_LANGUAGE_CODE_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "languageCode");
    public static final TagWithNS LANGUAGE_DEF_DEFAULT_PATTERNS_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "defaultPatterns");
    public static final TagWithNS LANGUAGE_DEF_TRANSLATORS_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "translators");
    public static final TagWithNS LANGUAGE_DEF_TRANSLATOR_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "translator");
    public static final TagWithNS LANGUAGE_DEF_TRANSLATOR_TYPE_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "type");
    public static final TagWithNS LANGUAGE_DEF_TRANSLATOR_VALUE_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "value");
    public static final TagWithNS LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "condition");
    public static final TagWithNS LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "stepname");
    public static final TagWithNS LANGUAGE_DEF_DEPENDENCY_TYPES_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "dependencyTypes");
    public static final TagWithNS LANGUAGE_DEF_DEPENDENCY_TYPE_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "dependencyType");
    public static final TagWithNS LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "name");
    public static final TagWithNS LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "level");
    public static final TagWithNS LANGUAGE_DEF_SCANNERS_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "scanners");
    public static final TagWithNS LANGUAGE_DEF_SCANNER_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "scanner");
    public static final TagWithNS LANGUAGE_DEF_SCOPED_PROPERTIES_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "scopedProperties");
    public static final TagWithNS LANGUAGE_DEF_SCOPED_PROPERTY_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "scopedProperty");
    public static final TagWithNS LANGUAGE_DEF_EXTENSIONS_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "languageExtensions");
    public static final TagWithNS LANGUAGE_DEF_EXTENSIONQUERIES_TAG = new TagWithNS(LANGUAGEDEFINITION_NAMESPACE, "languageExtensionQueries");
    public static final TagWithNS RESOURCE_DEF_RESOURCE_NAME_TAG = new TagWithNS(RESOURCEDEFINITION_NAMESPACE, "resourceName");
    public static final TagWithNS RESOURCE_DEF_USAGE_TYPE_TAG = new TagWithNS(RESOURCEDEFINITION_NAMESPACE, "usageType");
    public static final TagWithNS TRANSLATOR_ADDITIONAL_PATH_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "additionalPath");
    public static final TagWithNS TRANSLATOR_ADDITIONAL_PATH_ENTRY_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "additionalPathEntry");
    public static final TagWithNS TRANSLATOR_VARIABLES_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "variables");
    public static final TagWithNS TRANSLATOR_VARIABLE_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "variable");
    public static final TagWithNS TRANSLATOR_VARIABLE_NAME_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "name");
    public static final TagWithNS TRANSLATOR_VARIABLE_VALUE_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "value");
    public static final TagWithNS TRANSLATOR_VARIABLE_TYPE_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "type");
    public static final TagWithNS TRANSLATOR_OUTPUTS_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "hfsoutputs");
    public static final TagWithNS TRANSLATOR_OUTPUT_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "hfsoutput");
    public static final TagWithNS TRANSLATOR_OUTPUT_PATH_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "path");
    public static final TagWithNS TRANSLATOR_OUTPUT_CONDITION_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "condition");
    public static final TagWithNS TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG = new TagWithNS(TRANSLATOR_NAMESPACE, "deploytype");
    public static final TagWithNS SEARCH_PATH_PATH_TAG = new TagWithNS(SEARCHPATH_NAMESPACE, "path");
    public static final TagWithNS SEARCH_PATH_PATH_ENTRY_TAG = new TagWithNS(SEARCHPATH_NAMESPACE, "pathEntry");
    public static final String TRANSLATOR_VARIABLE_TYPE_PREDEFINED = "predefined";
    public static final String TRANSLATOR_VARIABLE_TYPE_FIXED = "fixed";
    public static final TagWithNS SYSTEM_DEF_PRELIST_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "preList");
    public static final TagWithNS SYSTEM_DEF_CURLIST_TAG = new TagWithNS(SYSTEMDEFINITION_NAMESPACE, "curList");
    protected static final String UTF_8 = "UTF-8";
    public static final String MESSAGE_ID_OPEN_LATEST = "OPEN_LATEST_SYS_DEF";
    private static String REVISION = "?revision=";

    protected SystemDefinitionUtil() {
    }

    public static String createSystemDefinitionSlug(ISystemDefinition systemDefinition) {
        return SystemDefinitionUtil.createSystemDefinitionSlug(systemDefinition.getUuid());
    }

    public static String createSystemDefinitionSlug(com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) {
        return SystemDefinitionUtil.createSystemDefinitionSlug(systemDefinition.getItemId().getUuidValue());
    }

    public static String createSystemDefinitionSlug(String uuid) {
        return SystemDefinitionUtil.createSystemDefinitionSlug(uuid, null);
    }

    public static String createSystemDefinitionSlug(String uuid, String revision) {
        StringBuffer systemDefinitionURI = new StringBuffer("_uuid=");
        systemDefinitionURI.append(uuid);
        if (revision != null) {
            systemDefinitionURI.append(REVISION);
            systemDefinitionURI.append(revision);
        }
        return systemDefinitionURI.toString();
    }

    public static ISystemDefinitionHandle createSystemDefinitionHandleFromSlug(String slug, String jfsType) {
        ISystemDefinitionHandle handle = null;
        IItemType type = SystemDefinitionUtil.convertToItemType(jfsType);
        if (slug.startsWith("_uuid=") && slug.length() > "_uuid=".length() && type != null) {
            UUID itemid = null;
            UUID stateid = null;
            String struuid = slug.substring("_uuid=".length());
            String strstateid = null;
            if (struuid.contains(REVISION) && struuid.length() > REVISION.length() + 1) {
                strstateid = struuid.substring(struuid.indexOf(REVISION) + REVISION.length() + 1);
                struuid = struuid.substring(0, struuid.indexOf(REVISION));
            }
            try {
                itemid = UUID.valueOf((String)struuid);
                if (strstateid != null && !strstateid.isEmpty()) {
                    stateid = UUID.valueOf((String)strstateid);
                }
            }
            catch (IllegalArgumentException e) {
                return handle;
            }
            handle = stateid != null ? (ISystemDefinitionHandle)type.createItemHandle(itemid, stateid) : (ISystemDefinitionHandle)type.createItemHandle(itemid, null);
        }
        return handle;
    }

    public static UUID[] computeIdsFromSlug(String slug) {
        UUID[] itemids = new UUID[2];
        UUID itemid = null;
        UUID stateid = null;
        String[] ids = SystemDefinitionUtil.parseIdsFromSlug(slug);
        if (ids[0] != null && !ids[0].isEmpty()) {
            try {
                itemid = UUID.valueOf((String)ids[0]);
                if (ids[1] != null && !ids[1].isEmpty()) {
                    stateid = UUID.valueOf((String)ids[1]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        itemids[0] = itemid;
        itemids[1] = stateid;
        return itemids;
    }

    public static String[] parseIdsFromSlug(String slug) {
        String[] ids = new String[2];
        if (slug.startsWith("_uuid=") && slug.length() > "_uuid=".length()) {
            ids[0] = slug.substring("_uuid=".length());
            if (ids[0].contains(REVISION) && ids[0].length() > REVISION.length() + 1) {
                ids[1] = ids[0].substring(ids[0].indexOf(REVISION) + REVISION.length() + 1);
                ids[0] = ids[0].substring(0, ids[0].indexOf(REVISION));
            }
        }
        return ids;
    }

    public static String getSystemDefinitionUuidsForProjectAreaQuery(String projectAreaUuid, String type, String platform) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?uuid \n");
        buffer.append("WHERE { \n  ");
        buffer.append("GRAPH ?g {?resource sd:projectAreaUUID \"" + projectAreaUuid + "\"" + ".\n");
        buffer.append("?resource sd:type \"" + type + "\"" + ".\n");
        buffer.append("?resource sd:platform \"" + platform + "\"" + ".\n");
        buffer.append("?resource sd:uuid ?uuid .\n");
        buffer.append("}\n}\n");
        return buffer.toString();
    }

    public static String createSystemDefinitionMappingSlug(String type) {
        StringBuffer buffer = new StringBuffer("_type=").append(type);
        return buffer.toString();
    }

    public static String createSystemDefinitionQueryCacheSlug(String type) {
        StringBuffer buffer = new StringBuffer("_cache").append("_type=").append(type);
        return buffer.toString();
    }

    public static boolean hasAntBuildProperty(String testString) {
        if (testString == null || testString.isEmpty()) {
            return false;
        }
        int start = testString.indexOf("${");
        if (start == -1) {
            return false;
        }
        int end = testString.indexOf("}", start);
        if (end == -1) {
            return false;
        }
        String propertyName = testString.substring(start + 2, end);
        return !propertyName.isEmpty() && !propertyName.contains(" ");
    }

    public static boolean isTypeOf(IItemType typeToCheck, IItemType targetType) {
        if (typeToCheck == null || targetType == null) {
            return false;
        }
        EClass eclass1 = (EClass)typeToCheck.getAdapter(EClass.class);
        if (eclass1 == null) {
            return false;
        }
        EClass eclass2 = (EClass)targetType.getAdapter(EClass.class);
        if (eclass2 == null) {
            return false;
        }
        return eclass1.equals(eclass2) || eclass2.isSuperTypeOf(eclass1);
    }

    public static boolean isExactType(IItemType typeToCheck, IItemType targetType) {
        EClass eclass1 = (EClass)typeToCheck.getAdapter(EClass.class);
        if (eclass1 == null) {
            return false;
        }
        EClass eclass2 = (EClass)targetType.getAdapter(EClass.class);
        if (eclass2 == null) {
            return false;
        }
        return eclass1.equals(eclass2);
    }

    public static <T> List<T> removeNulls(List<T> toFilter) {
        boolean hasNulls = false;
        Iterator<T> iter = toFilter.iterator();
        while (iter.hasNext() && !hasNulls) {
            T next = iter.next();
            if (next != null) continue;
            hasNulls = true;
        }
        if (!hasNulls) {
            return toFilter;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T next : toFilter) {
            if (next == null) continue;
            result.add(next);
        }
        return result;
    }

    public static String joinStringHelper(List<IStringHelper> strings, String delimiter) {
        return SystemDefinitionUtil.joinStringHelper(strings, delimiter, true);
    }

    public static String joinStringHelper(List<IStringHelper> strings, String delimiter, boolean removeStringSpaces) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (IStringHelper s : strings) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            if (removeStringSpaces) {
                buf.append(s.getValue().trim());
                continue;
            }
            buf.append(s.getValue());
        }
        return buf.toString();
    }

    public static List<IStringHelper> splitStringHelper(String strings, String delimiter) {
        return SystemDefinitionUtil.splitStringHelper(strings, delimiter, true);
    }

    public static List<IStringHelper> splitStringHelper(String strings, String delimiter, boolean removeStringSpaces) {
        if (strings == null || strings.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IStringHelper> list = new ArrayList<IStringHelper>();
        String[] stringArray = strings.split(delimiter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringHelper helper = ModelFactory.eINSTANCE.createStringHelper();
            if (removeStringSpaces) {
                helper.setValue(s.trim());
            } else {
                helper.setValue(s);
            }
            list.add(helper);
            ++n2;
        }
        return list;
    }

    public static boolean contains(List<IStringHelper> strings, String searchFor) {
        if (strings == null || strings.isEmpty()) {
            return false;
        }
        for (IStringHelper s : strings) {
            if (!(s.getValue() == null ? searchFor == null : s.getValue().equals(searchFor))) continue;
            return true;
        }
        return false;
    }

    public static List<String> toStringArray(List<IStringHelper> strings) {
        if (strings == null || strings.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> list = new ArrayList<String>(strings.size());
        for (IStringHelper s : strings) {
            list.add(s.getValue());
        }
        return list;
    }

    public static void remove(List<IStringHelper> strings, String toRemove) {
        Iterator<IStringHelper> it = strings.iterator();
        while (it.hasNext()) {
            IStringHelper s = it.next();
            if (s.getValue() == null) {
                if (toRemove != null) continue;
                it.remove();
                continue;
            }
            if (!s.getValue().equals(toRemove)) continue;
            it.remove();
        }
    }

    public static IItemType convertToItemType(String oldJFSType) {
        if ("languagedefinition".equals(oldJFSType)) {
            return ILanguageDefinition.ITEM_TYPE;
        }
        if ("translator".equals(oldJFSType)) {
            return ITranslator.ITEM_TYPE;
        }
        if ("searchpath".equals(oldJFSType)) {
            return ISearchPath.ITEM_TYPE;
        }
        if ("resourcedefinition".equals(oldJFSType)) {
            return IResourceDefinition.ITEM_TYPE;
        }
        if ("functiondefinition".equals(oldJFSType)) {
            return IFunctionDefinition.ITEM_TYPE;
        }
        if ("versiondefinition".equals(oldJFSType)) {
            return IVersionDefinition.ITEM_TYPE;
        }
        return null;
    }

    public static IItemType convertToItemType(String oldJFSType, String platform) {
        IItemType type;
        block17: {
            type = SystemDefinitionUtil.convertToItemType(oldJFSType);
            if (type == null || platform == null) break block17;
            switch (platform) {
                case "zos": {
                    if (SystemDefinitionUtil.isTypeOf(type, ILanguageDefinition.ITEM_TYPE)) {
                        return IZosLanguageDefinition.ITEM_TYPE;
                    }
                    if (SystemDefinitionUtil.isTypeOf(type, ITranslator.ITEM_TYPE)) {
                        return IZosTranslator.ITEM_TYPE;
                    }
                    if (SystemDefinitionUtil.isTypeOf(type, IResourceDefinition.ITEM_TYPE)) {
                        return IDataSetDefinition.ITEM_TYPE;
                    }
                    if (SystemDefinitionUtil.isTypeOf(type, IFunctionDefinition.ITEM_TYPE)) {
                        return IFunctionDefinition.ITEM_TYPE;
                    }
                    if (!SystemDefinitionUtil.isTypeOf(type, IVersionDefinition.ITEM_TYPE)) break;
                    return IVersionDefinition.ITEM_TYPE;
                }
                case "ibmi": {
                    if (SystemDefinitionUtil.isTypeOf(type, ILanguageDefinition.ITEM_TYPE)) {
                        return IIBMiLanguageDefinition.ITEM_TYPE;
                    }
                    if (SystemDefinitionUtil.isTypeOf(type, ITranslator.ITEM_TYPE)) {
                        return IIBMiTranslator.ITEM_TYPE;
                    }
                    if (SystemDefinitionUtil.isTypeOf(type, IResourceDefinition.ITEM_TYPE)) {
                        return IIBMiResourceDefinition.ITEM_TYPE;
                    }
                    if (!SystemDefinitionUtil.isTypeOf(type, ISearchPath.ITEM_TYPE)) break;
                    return IIBMiSearchPath.ITEM_TYPE;
                }
            }
        }
        return type;
    }

    public static String convertToJFSType(IItemType itemType) {
        if (SystemDefinitionUtil.isTypeOf(itemType, ILanguageDefinition.ITEM_TYPE)) {
            return "languagedefinition";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, ITranslator.ITEM_TYPE)) {
            return "translator";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, ISearchPath.ITEM_TYPE)) {
            return "searchpath";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, IResourceDefinition.ITEM_TYPE)) {
            return "resourcedefinition";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, IVersionDefinition.ITEM_TYPE)) {
            return "versiondefinition";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, IFunctionDefinition.ITEM_TYPE)) {
            return "functiondefinition";
        }
        return null;
    }

    public static String getTypeName(IItemType itemType) {
        if (SystemDefinitionUtil.isTypeOf(itemType, ILanguageDefinition.ITEM_TYPE)) {
            return "languagedefinition";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, ITranslator.ITEM_TYPE)) {
            return "translator";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, ISearchPath.ITEM_TYPE)) {
            return "searchpath";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, IResourceDefinition.ITEM_TYPE)) {
            return "resourcedefinition";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, IVersionDefinition.ITEM_TYPE)) {
            return "versiondefinition";
        }
        if (SystemDefinitionUtil.isTypeOf(itemType, IFunctionDefinition.ITEM_TYPE)) {
            return "functiondefinition";
        }
        return "";
    }

    public static IItemType getTypeFromName(String itemTypeName) {
        return IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, "com.ibm.team.enterprise.systemdefinition");
    }
}

