/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;

public class SystemDefinitionQueryGenerator {
    public static String getSystemDefinitionUuidsForProjectAreaQuery(String projectAreaUuid, String type, String platform, boolean includeArchived) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?uuid \n");
        buffer.append("WHERE { \n  ");
        buffer.append("GRAPH ?g {?resource sd:projectAreaUUID \"" + projectAreaUuid + "\"" + ".\n");
        buffer.append("?resource sd:type \"" + type + "\"" + ".\n");
        buffer.append("?resource sd:platform \"" + platform + "\"" + ".\n");
        buffer.append("?resource sd:uuid ?uuid .\n");
        if (!includeArchived) {
            buffer.append("?resource sd:archived  \"false\"  .\n");
        }
        buffer.append("}\n}\n");
        return buffer.toString();
    }

    public static String getResourceDefinitionUuidsForProjectAreaQuery(String projectAreaUuid, String platform, int usageType, boolean includeArchived) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("PREFIX rd: <" + SystemDefinitionUtil.RESOURCEDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?uuid \n");
        buffer.append("WHERE { \n  ");
        buffer.append("GRAPH ?g {?resource sd:projectAreaUUID \"" + projectAreaUuid + "\"" + ".\n");
        buffer.append("?resource sd:type \"resourcedefinition\".\n");
        buffer.append("?resource sd:platform \"" + platform + "\"" + ".\n");
        buffer.append("?resource sd:uuid ?uuid .\n");
        if (!includeArchived) {
            buffer.append("?resource sd:archived  \"false\"  .\n");
        }
        if (usageType != -1) {
            buffer.append("?resource rd:usageType \"" + usageType + "\"" + ".\n");
        }
        buffer.append("}\n}\n");
        return buffer.toString();
    }

    public static String getSystemDefinitionUUIDQuery(String name, String type) {
        return SystemDefinitionQueryGenerator.getSystemDefinitionUUIDQuery(name, type, null);
    }

    public static String getSystemDefinitionUUIDQuery(String name, String type, String platform) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?uuid ?projectAreaUUID \n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource sd:uuid ?uuid . \n");
        buffer.append("?resource sd:projectAreaUUID ?projectAreaUUID .\n");
        name = name.replace("\\", "\\\\");
        name = name.replace("\"", "\\\"");
        buffer.append("?resource sd:name \"" + name + "\" .\n");
        buffer.append("?resource sd:type \"" + type + "\" .\n");
        if (platform != null) {
            buffer.append("?resource sd:platform \"" + platform + "\" .\n");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getSystemDefinitionsWithDefaultOptionsQuery(String type, String defaultPattern, boolean includeArchived) {
        String defaultPatternLowerCase = null;
        if (defaultPattern != null) {
            defaultPatternLowerCase = defaultPattern.toLowerCase();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("PREFIX ld: <" + SystemDefinitionUtil.LANGUAGEDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("PREFIX fn: <" + SystemDefinitionUtil.XPATHFUNCTION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?name ?defaultPatterns ?uuid ?projectAreaUUID \n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource sd:uuid ?uuid .\n");
        buffer.append("?resource sd:type \"" + type + "\" .\n");
        if (!includeArchived) {
            buffer.append("?resource sd:archived  \"false\"  .\n");
        }
        buffer.append("?resource sd:name ?name .\n");
        buffer.append("?resource sd:projectAreaUUID ?projectAreaUUID .\n");
        buffer.append("{?resource ld:defaultPatterns ?defaultPatterns . FILTER (fn:contains(?defaultPatterns, \"" + defaultPatternLowerCase + "\"))}}");
        return buffer.toString();
    }

    public static String getSystemDefinitionsHaveDefaultOptionsQuery(String type, boolean includeArchived) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("PREFIX ld: <" + SystemDefinitionUtil.LANGUAGEDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("PREFIX fn: <" + SystemDefinitionUtil.XPATHFUNCTION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?name ?defaultPatterns ?uuid\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource sd:uuid ?uuid .\n");
        buffer.append("?resource sd:type \"" + type + "\" .\n");
        if (!includeArchived) {
            buffer.append("?resource sd:archived  \"false\"  .\n");
        }
        buffer.append("?resource sd:name ?name .\n");
        buffer.append("{?resource ld:defaultPatterns ?defaultPatterns . FILTER (?defaultPatterns != \"\")}}");
        return buffer.toString();
    }

    public static String getSystemDefinitionHandlesQuery(String projectAreaUuid, String type, String platform, boolean includeArchived) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?uuid ?name ?platform ?type\n");
        buffer.append("WHERE { \n  ");
        buffer.append("GRAPH ?g {");
        if (projectAreaUuid != null) {
            buffer.append("?resource sd:projectAreaUUID \"" + projectAreaUuid + "\"" + ".\n");
        }
        if (type != null) {
            buffer.append("?resource sd:type \"" + type + "\"" + ".\n");
        } else {
            buffer.append("?resource sd:type ?type .\n");
        }
        if (platform != null) {
            buffer.append("?resource sd:platform \"" + platform + "\"" + ".\n");
        } else {
            buffer.append("?resource sd:platform ?platform .\n");
        }
        buffer.append("?resource sd:uuid ?uuid .\n");
        buffer.append("?resource sd:name ?name .\n");
        if (!includeArchived) {
            buffer.append("?resource sd:archived  \"false\"  .\n");
        }
        buffer.append("}\n}\n");
        return buffer.toString();
    }

    public static String getSystemDefinitionHandlesQuery(String type) {
        return SystemDefinitionQueryGenerator.getSystemDefinitionHandlesQuery(type, true);
    }

    public static String getSystemDefinitionHandlesQuery(String type, boolean orderResultsByName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        if ("resourcedefinition".equals(type)) {
            buffer.append("PREFIX rd: <" + SystemDefinitionUtil.RESOURCEDEFINITION_NAMESPACE.getNamespace() + "> \n");
            buffer.append("SELECT ?uuid ?name ?platform ?type ?projectAreaUUID ?usageType ?archived \n");
        } else {
            buffer.append("SELECT ?uuid ?name ?platform ?type ?projectAreaUUID ?archived \n");
        }
        buffer.append("WHERE { \n  ");
        buffer.append("GRAPH ?g {");
        buffer.append("?resource sd:projectAreaUUID ?projectAreaUUID .\n");
        if (type != null) {
            buffer.append("?resource sd:type \"" + type + "\"" + ".\n");
        } else {
            buffer.append("?resource sd:type ?type .\n");
        }
        buffer.append("?resource sd:platform ?platform .\n");
        buffer.append("?resource sd:uuid ?uuid .\n");
        buffer.append("?resource sd:name ?name .\n");
        buffer.append("?resource sd:archived ?archived .\n");
        if ("resourcedefinition".equals(type)) {
            buffer.append("?resource rd:usageType ?usageType .\n");
        }
        buffer.append("}\n}\n");
        if (orderResultsByName) {
            buffer.append("ORDER BY ASC(?name)\n");
        }
        return buffer.toString();
    }

    public static String getSystemDefinitionUUIDsQuery(String type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX sd: <" + SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace() + "> \n");
        buffer.append("SELECT ?uuid\n");
        buffer.append("WHERE { \n  ");
        buffer.append("GRAPH ?g {");
        if (type != null) {
            buffer.append("?resource sd:type \"" + type + "\"" + ".\n");
        } else {
            buffer.append("?resource sd:type ?type .\n");
        }
        buffer.append("?resource sd:uuid ?uuid .\n");
        buffer.append("}\n}\n");
        return buffer.toString();
    }
}

