/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPathHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingExtension;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;

public class SystemDefinitionDtoString {
    private static final String indexItemString = "(%1$d) %2$s (%3$s)";
    private static final String itemString = "%1$s (%2$s)";
    private static final String labelString = "<br/>%s<br/>&nbsp;";

    private static String formatItem(IItem item, String name) {
        return String.format(itemString, LogString.valueOf((String)name), LogString.valueOf((String)item.getItemId().getUuidValue()));
    }

    private static String formatItemHandle(IItemHandle item) {
        return item.getItemId().getUuidValue();
    }

    private static String formatDefinition(ISystemDefinition item) {
        return String.format(itemString, LogString.valueOf((String)item.getName()), LogString.valueOf((String)item.getItemId().getUuidValue()));
    }

    private static String formatDefinition(ISystemDefinition item, int i) {
        return String.format(indexItemString, i, LogString.valueOf((String)item.getName()), LogString.valueOf((String)item.getItemId().getUuidValue()));
    }

    private static String formatDefinitionHandle(ISystemDefinitionHandle item) {
        return item.hasFullState() ? SystemDefinitionDtoString.formatDefinition((ISystemDefinition)item) : item.getItemId().getUuidValue();
    }

    private static String formatDefinitionHandle(ISystemDefinitionHandle item, int i) {
        return item.hasFullState() ? SystemDefinitionDtoString.formatDefinition((ISystemDefinition)item, i) : item.getItemId().getUuidValue();
    }

    public static String getLabelName(String name) {
        return String.format(labelString, LogString.valueOf((String)name));
    }

    public static String getPlatform(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof IZosPlatformObject) {
            return "zos";
        }
        if (o instanceof IIBMiPlatformObject) {
            return "ibmi";
        }
        return "";
    }

    public static String valueOf(Object o) {
        return o == null ? null : o.toString();
    }

    public static String valueOf(IContributor o) {
        return o == null ? null : SystemDefinitionDtoString.formatItem((IItem)o, o.getName());
    }

    public static String valueOf(IContributorHandle o) {
        return o == null ? null : (o.hasFullState() ? SystemDefinitionDtoString.valueOf((IContributor)o) : SystemDefinitionDtoString.formatItemHandle((IItemHandle)o));
    }

    public static String valueOf(IDataSetDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IDataSetDefinition o, int i) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o, i);
    }

    public static String valueOf(IDataSetDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(IDataSetDefinitionHandle o, int i) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o, i);
    }

    public static String valueOf(IFmidItemDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IFmidItemDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(IFunctionDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IFunctionDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(ILanguageDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(ILanguageDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(IPackagingDetailDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IPackagingDetailDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(IPackagingItemDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IPackagingItemDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(IProjectArea o) {
        return o == null ? null : SystemDefinitionDtoString.formatItem((IItem)o, o.getName());
    }

    public static String valueOf(IProjectAreaHandle o) {
        return o == null ? null : (o.hasFullState() ? SystemDefinitionDtoString.valueOf((IProjectArea)o) : SystemDefinitionDtoString.formatItemHandle((IItemHandle)o));
    }

    public static String valueOf(IPackagingExtension<?, ?> o) {
        return o == null ? null : o.toString();
    }

    public static String valueOf(IResourceDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IResourceDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(ISearchPath o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(ISearchPathHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(ITranslator o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(ITranslatorHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }

    public static String valueOf(IVersionDefinition o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinition(o);
    }

    public static String valueOf(IVersionDefinitionHandle o) {
        return o == null ? null : SystemDefinitionDtoString.formatDefinitionHandle(o);
    }
}

