/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchPathUtils {
    public static void setObjectLibrary(ISearchPath searchPath, IResourceDefinitionHandle libraryHandle) {
        SearchPathUtils.setLibrary(searchPath, libraryHandle, LibraryType.object);
    }

    public static String getObjectLibraryUUID(ISearchPath searchPath) {
        return SearchPathUtils.getLibraryUUID(searchPath, LibraryType.object);
    }

    public static void setSourceLibrary(ISearchPath searchPath, IResourceDefinitionHandle libraryHandle) {
        SearchPathUtils.setLibrary(searchPath, libraryHandle, LibraryType.source);
    }

    public static String getSourceLibraryUUID(ISearchPath searchPath) {
        return SearchPathUtils.getLibraryUUID(searchPath, LibraryType.source);
    }

    private static void setLibrary(ISearchPath searchPath, IResourceDefinitionHandle libraryHandle, LibraryType type) {
        if (searchPath != null) {
            StringHelper helper;
            ArrayList<String> refLibraries = new ArrayList<String>();
            refLibraries.addAll(SearchPathUtils.getReferencedLibrariesUUIDs(searchPath));
            String objectLibrary = SearchPathUtils.getObjectLibraryUUID(searchPath);
            String sourceLibrary = SearchPathUtils.getSourceLibraryUUID(searchPath);
            String propertyKey = null;
            if (type != null && type == LibraryType.object) {
                propertyKey = "object.library.key";
            } else if (type != null & type == LibraryType.source) {
                propertyKey = "source.library.key";
            } else {
                return;
            }
            if (libraryHandle != null) {
                String libraryUuid = libraryHandle.getItemId().getUuidValue();
                searchPath.getProperties().put(propertyKey, libraryUuid);
                if (type == LibraryType.object) {
                    objectLibrary = libraryUuid;
                } else {
                    sourceLibrary = libraryUuid;
                }
            } else {
                searchPath.getProperties().put(propertyKey, "");
                if (type == LibraryType.object) {
                    objectLibrary = null;
                } else {
                    sourceLibrary = null;
                }
            }
            searchPath.getPath().clear();
            if (objectLibrary != null) {
                helper = ModelFactory.eINSTANCE.createStringHelper();
                helper.setValue(objectLibrary);
                searchPath.getPath().add(helper);
            }
            if (sourceLibrary != null) {
                helper = ModelFactory.eINSTANCE.createStringHelper();
                helper.setValue(sourceLibrary);
                searchPath.getPath().add(helper);
            }
            for (String refLibrary : refLibraries) {
                StringHelper helper2 = ModelFactory.eINSTANCE.createStringHelper();
                helper2.setValue(refLibrary);
                searchPath.getPath().add(helper2);
            }
        }
    }

    private static String getLibraryUUID(ISearchPath searchPath, LibraryType type) {
        if (searchPath != null) {
            int index = -1;
            String propertyKey = null;
            if (type == LibraryType.object) {
                propertyKey = "object.library.key";
                index = 0;
            } else if (type == LibraryType.source) {
                propertyKey = "source.library.key";
                index = 1;
            } else {
                return null;
            }
            if (searchPath.getProperties().containsKey(propertyKey)) {
                String uuid = (String)searchPath.getProperties().get(propertyKey);
                if (uuid != null && !uuid.isEmpty()) {
                    if (SystemDefinitionUtil.contains(searchPath.getPath(), uuid)) {
                        return uuid;
                    }
                    searchPath.getProperties().put(propertyKey, "");
                    return null;
                }
                return null;
            }
            if (searchPath.getPath().size() > index) {
                IStringHelper helper = searchPath.getPath().get(index);
                return helper == null ? null : helper.getValue();
            }
            return null;
        }
        return null;
    }

    public static void setReferencedLibraries(ISearchPath searchPath, List<IResourceDefinitionHandle> referencedLibraries) {
        if (searchPath != null && referencedLibraries != null) {
            ArrayList<String> uuids = new ArrayList<String>();
            for (IResourceDefinitionHandle handle : referencedLibraries) {
                uuids.add(handle.getItemId().getUuidValue());
            }
            SearchPathUtils.setReferencedLibrariesByUUIDs(searchPath, uuids);
        }
    }

    public static void setReferencedLibrariesByUUIDs(ISearchPath searchPath, List<String> referencedLibrariesUuids) {
        if (searchPath != null && referencedLibrariesUuids != null) {
            StringHelper helper;
            String objLib = SearchPathUtils.getObjectLibraryUUID(searchPath);
            String srcLib = SearchPathUtils.getSourceLibraryUUID(searchPath);
            searchPath.getPath().clear();
            if (objLib != null && !objLib.isEmpty()) {
                helper = ModelFactory.eINSTANCE.createStringHelper();
                helper.setValue(objLib);
                searchPath.getPath().add(helper);
            } else {
                SearchPathUtils.setObjectLibrary(searchPath, null);
            }
            if (srcLib != null && !srcLib.isEmpty()) {
                helper = ModelFactory.eINSTANCE.createStringHelper();
                helper.setValue(srcLib);
                searchPath.getPath().add(helper);
            } else {
                SearchPathUtils.setSourceLibrary(searchPath, null);
            }
            for (String libraryUuid : referencedLibrariesUuids) {
                StringHelper helper2 = ModelFactory.eINSTANCE.createStringHelper();
                helper2.setValue(libraryUuid);
                searchPath.getPath().add(helper2);
            }
        }
    }

    public static List<String> getReferencedLibrariesUUIDs(ISearchPath searchPath) {
        return SearchPathUtils.getReferencedLibrariesUUIDs(searchPath, true);
    }

    public static List<String> getReferencedLibrariesUUIDs(ISearchPath searchPath, boolean modifiable) {
        if (searchPath != null) {
            List<String> totalList = SystemDefinitionUtil.toStringArray(searchPath.getPath());
            if (!totalList.isEmpty()) {
                String objLib = SearchPathUtils.getObjectLibraryUUID(searchPath);
                String srcLib = SearchPathUtils.getSourceLibraryUUID(searchPath);
                if (objLib != null) {
                    totalList.remove(objLib);
                }
                if (srcLib != null) {
                    totalList.remove(srcLib);
                }
            }
            if (modifiable) {
                return totalList;
            }
            return Collections.unmodifiableList(totalList);
        }
        return null;
    }

    private static enum LibraryType {
        source,
        object;

    }
}

