/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.repository.common.IItemHandle;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ItemHandleAwareHashSet<E>
implements Set<E> {
    private final HashSet fInternalSet = new HashSet();

    public ItemHandleAwareHashSet() {
    }

    public ItemHandleAwareHashSet(Collection collection) {
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.fInternalSet.size();
    }

    @Override
    public void clear() {
        this.fInternalSet.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fInternalSet.isEmpty();
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof IItemHandle) {
            return this.fInternalSet.add(new Entry((IItemHandle)o));
        }
        return this.fInternalSet.add(o);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IItemHandle) {
            return this.fInternalSet.contains(new Entry((IItemHandle)o));
        }
        return this.fInternalSet.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IItemHandle) {
            return this.fInternalSet.remove(new Entry((IItemHandle)o));
        }
        return this.fInternalSet.remove(o);
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            boolean bl = changed = this.add(e.next()) || changed;
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            boolean bl = changed = this.remove(e.next()) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean changed = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Iterator iterator() {
        return new ItemIterator(this.fInternalSet.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.fInternalSet.size()]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.fInternalSet.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            a[i] = e.next();
            ++i;
        }
        return a;
    }

    private static class Entry {
        public IItemHandle handle;

        public Entry() {
        }

        public Entry(IItemHandle handle) {
            this.handle = handle;
        }

        public int hashCode() {
            return this.handle.getItemId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            return this.handle.sameItemId(((Entry)obj).handle);
        }
    }

    private static class ItemIterator
    implements Iterator {
        private final Iterator fIterator;

        public ItemIterator(Iterator iterator) {
            this.fIterator = iterator;
        }

        @Override
        public void remove() {
            this.fIterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.fIterator.hasNext();
        }

        public Object next() {
            Object next = this.fIterator.next();
            if (next instanceof Entry) {
                Entry entry = (Entry)next;
                return entry.handle;
            }
            return next;
        }
    }
}

