/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    private static final String pathPrefix = "^.*/(";
    private static final String pathSuffix = ".*$)";
    private static final String zOSsrcPath = "zOSsrc/";
    private static final String zOSsrcDefault = "^zOSsrc/";
    private static final Pattern zOSsrcPattern = Pattern.compile("^.*/(zOSsrc/.*$)");

    public static String getProjectPath(File file, String projectName) {
        String result = null;
        Pattern p = Pattern.compile(pathPrefix + projectName + "/" + pathSuffix);
        Matcher m = null;
        try {
            String path = file.getCanonicalPath().replaceAll("\\\\", "/");
            m = p.matcher(path);
            if (m.find() && m.groupCount() > 0) {
                result = m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getProjectPath(String path, String projectName) {
        String result = null;
        Pattern p = Pattern.compile(pathPrefix + projectName + "/" + pathSuffix);
        Matcher m = null;
        try {
            m = p.matcher(path);
            if (m.find() && m.groupCount() > 0) {
                result = m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getProjectPattern(String pattern, String projectName) {
        String escapedName = projectName.replaceAll("\\.", "\\\\.").replaceAll("\\$", "\\\\\\$");
        String dflt = "^" + escapedName + "/";
        String proj = String.valueOf(escapedName) + "/";
        if (pattern.startsWith(dflt)) {
            return pattern;
        }
        if (pattern.startsWith(proj)) {
            return "^" + pattern;
        }
        return String.valueOf(dflt) + pattern.substring(pattern.startsWith("^") ? 1 : 0);
    }

    public static String getZOSsrcPath(File file) {
        String result = null;
        Matcher m = null;
        try {
            String path = file.getCanonicalPath().replaceAll("\\\\", "/");
            m = zOSsrcPattern.matcher(path);
            if (m.find() && m.groupCount() > 0) {
                result = m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getZOSsrcPath(String path) {
        String result = null;
        Matcher m = null;
        try {
            m = zOSsrcPattern.matcher(path);
            if (m.find() && m.groupCount() > 0) {
                result = m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getZOSsrcPattern(String pattern) {
        if (pattern.startsWith(zOSsrcDefault)) {
            return pattern;
        }
        if (pattern.startsWith(zOSsrcPath)) {
            return "^" + pattern;
        }
        return zOSsrcDefault + pattern.substring(pattern.startsWith("^") ? 1 : 0);
    }
}

