/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHistoryProcessor;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDelta;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingElements;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import java.util.List;

public class DefaultSystemDefinitionHistoryProcessor
implements ISystemDefinitionHistoryProcessor {
    @Override
    public void process(ISystemDefinition oldSystemDefinition, ISystemDefinition newSystemDefinition, ChangeLogDTO changeLog) {
        if (newSystemDefinition instanceof ILanguageDefinition) {
            DefaultSystemDefinitionHistoryProcessor.addLanguageDefinitionChangeLogDeltas(oldSystemDefinition, (ILanguageDefinition)newSystemDefinition, changeLog);
            if (newSystemDefinition instanceof IZosLanguageDefinition) {
                this.addZosLanguageDefinitionChangeLogDeltas(oldSystemDefinition, (IZosLanguageDefinition)newSystemDefinition, changeLog);
            }
        } else if (newSystemDefinition instanceof ITranslator) {
            DefaultSystemDefinitionHistoryProcessor.addTranslatorChangeLogDeltas(oldSystemDefinition, (ITranslator)newSystemDefinition, changeLog);
        }
    }

    private static void addLanguageDefinitionChangeLogDeltas(ISystemDefinition oldSystemDefinition, ILanguageDefinition newLanguageDefinition, ChangeLogDTO changeLog) {
        boolean isNew;
        ILanguageDefinition oldLang = null;
        boolean bl = isNew = oldSystemDefinition == null;
        if (oldSystemDefinition instanceof ILanguageDefinition) {
            oldLang = (ILanguageDefinition)oldSystemDefinition;
        }
        String oldLangeCode = null;
        String oldDefaultP = null;
        Boolean oldNonimpact = null;
        Boolean oldCalculate = null;
        Boolean oldConsolidate = null;
        List<ITranslatorEntry> oldTranslators = null;
        List<IStringHelper> oldScanners = null;
        List<IDependencyType> oldDependencyTypes = null;
        List<IScopedProperty> oldScopedProperties = null;
        if (oldLang != null) {
            oldLangeCode = oldLang.getLanguageCode();
            oldDefaultP = SystemDefinitionUtil.joinStringHelper(oldLang.getDefaultPatterns(), ",");
            oldNonimpact = oldLang.isNonImpacting();
            oldCalculate = oldLang.isCalculateImpacts();
            oldConsolidate = oldLang.isConsolidateLogs();
            oldTranslators = oldLang.getTranslators();
            oldScanners = oldLang.getSourceCodeDataScanners();
            oldDependencyTypes = oldLang.getDependencyTypes();
            oldScopedProperties = oldLang.getScopedProperties();
        }
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG.getWholeTagName(), oldLangeCode, newLanguageDefinition.getLanguageCode(), null, false, false);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG.getWholeTagName(), oldDefaultP, SystemDefinitionUtil.joinStringHelper(newLanguageDefinition.getDefaultPatterns(), ","), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), oldNonimpact, newLanguageDefinition.isNonImpacting(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.LANGUAGE_DEF_CALCULATE_IMPACTS_TAG.getWholeTagName(), oldCalculate, newLanguageDefinition.isCalculateImpacts(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG.getWholeTagName(), oldConsolidate, newLanguageDefinition.isConsolidateLogs(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateLangDefTranslatorCLD(changeLog.getChanges(), oldTranslators, newLanguageDefinition.getTranslators(), oldSystemDefinition == null, true);
        ChangeLogUtil.generateLangDefScannersCLD(changeLog.getChanges(), oldScanners, newLanguageDefinition.getSourceCodeDataScanners(), oldSystemDefinition == null);
        ChangeLogUtil.generateLangDefDependencyTypesCLD(changeLog.getChanges(), oldDependencyTypes, newLanguageDefinition.getDependencyTypes(), oldSystemDefinition == null);
        ChangeLogUtil.generateScopedPropertyListChangeLogDelta(changeLog, SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTIES_TAG.getWholeTagName(), oldScopedProperties, newLanguageDefinition.getScopedProperties(), oldSystemDefinition == null);
    }

    private void addZosLanguageDefinitionChangeLogDeltas(ISystemDefinition oldSystemDefinition, IZosLanguageDefinition newLanguageDefinition, ChangeLogDTO changeLog) {
        if (changeLog == null) {
            return;
        }
        if (newLanguageDefinition.hasSmpePackaging() && newLanguageDefinition.getSmpePackaging().hasFullState()) {
            IPackagingItemDefinition packagingItem = (IPackagingItemDefinition)newLanguageDefinition.getSmpePackaging();
            ISystemDefinition oldPackagingItem = null;
            int changeLogIndex = changeLog.getChanges().size();
            if (oldSystemDefinition != null && oldSystemDefinition instanceof IZosLanguageDefinition && ((IZosLanguageDefinition)oldSystemDefinition).hasSmpePackaging() && ((IZosLanguageDefinition)oldSystemDefinition).getSmpePackaging().hasFullState()) {
                oldPackagingItem = (ISystemDefinition)((Object)((IZosLanguageDefinition)oldSystemDefinition).getSmpePackaging());
            }
            packagingItem.generateChangeLogDTO(oldPackagingItem, newLanguageDefinition.getModifiedBy(), newLanguageDefinition.modified(), changeLog, true);
            if (changeLog.getChanges().size() > changeLogIndex) {
                ChangeLogDelta changeLogDelta = ChangeLogUtil.generateValuesChangeLogDelta(IPackagingElements.ELEMENT_LANGUAGE_LABEL_TAG.getWholeTagName(), null, LogString.valueOf((String)packagingItem.getName()), null, false, false);
                changeLog.getChanges().add(changeLogIndex, (Object)changeLogDelta);
            }
        }
    }

    private static void addTranslatorChangeLogDeltas(ISystemDefinition oldSystemDefinition, ITranslator newTranslator, ChangeLogDTO changeLog) {
        List<IVariable> oldVariables = null;
        ITranslator oldTrans = null;
        if (oldSystemDefinition instanceof ITranslator) {
            oldTrans = (ITranslator)oldSystemDefinition;
            oldVariables = oldTrans.getVariables();
        }
        ChangeLogUtil.generateVariableListChangeLogDelta(changeLog, SystemDefinitionUtil.TRANSLATOR_VARIABLES_TAG.getWholeTagName(), oldVariables, newTranslator.getVariables(), oldTrans == null);
    }
}

