/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStep;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DatasetCache {
    private Map<IImporterStep, List<List<IImporterDataset>>> tableDDCache = new HashMap<IImporterStep, List<List<IImporterDataset>>>();
    private Map<IImporterStep, List<String>> ddCache = new HashMap<IImporterStep, List<String>>();
    private Map<String, TokenName> tokenMap = new HashMap<String, TokenName>();
    private Map<String, Boolean> isCreatedMap;

    public void addDatasetLists(IImporterStep step, List<List<IImporterDataset>> datasets) {
        this.tableDDCache.put(step, datasets);
    }

    public void addDatasets(IImporterStep step, List<String> datasets) {
        this.ddCache.put(step, datasets);
    }

    public List<IImporterDataset> removeDupes(List<IImporterDataset> datasets) {
        if (this.isCreatedMap == null) {
            this.instantiateMap();
        }
        return datasets.stream().filter(d -> {
            boolean create = true;
            if (this.isCreatedMap.containsKey(d.getDataset())) {
                create = this.isCreatedMap.get(d.getDataset()) == false;
                this.isCreatedMap.put(d.getDataset(), true);
            }
            return create;
        }).collect(Collectors.toList());
    }

    private void instantiateMap() {
        HashMap flatMap = new HashMap();
        for (Map.Entry<IImporterStep, List<List<IImporterDataset>>> e2 : this.tableDDCache.entrySet()) {
            flatMap.put(e2.getKey(), e2.getValue().stream().flatMap(d -> d.stream()).collect(Collectors.toList()));
        }
        Map<IImporterStep, List> datasetNameMap = flatMap.entrySet().stream().collect(Collectors.toMap(e -> (IImporterStep)e.getKey(), e -> ((List)e.getValue()).stream().map(d -> d.getDataset()).collect(Collectors.toList())));
        List allDatasets = datasetNameMap.entrySet().stream().map(e -> (List)e.getValue()).flatMap(l -> l.stream()).collect(Collectors.toList());
        Set allDupes = allDatasets.stream().filter(s -> Collections.frequency(allDatasets, s) > 1).collect(Collectors.toSet());
        this.isCreatedMap = allDupes.stream().collect(Collectors.toMap(s -> s, s -> false));
    }

    public TokenName getTokensOrDefault(String dsn, String standardName, String personalName) {
        if (this.tokenMap.containsKey(dsn)) {
            return this.tokenMap.get(dsn);
        }
        TokenName newToken = new TokenName(standardName, personalName);
        this.tokenMap.put(dsn, newToken);
        return newToken;
    }

    public TokenName getTokenOrDefault(String dsn, String tokenName) {
        if (this.tokenMap.containsKey(dsn)) {
            return this.tokenMap.get(dsn);
        }
        TokenName newToken = new TokenName(tokenName, null);
        this.tokenMap.put(dsn, newToken);
        return newToken;
    }

    public class TokenName {
        private String standardName;
        private String personalName;

        public TokenName(String standardName, String personalName) {
            this.standardName = standardName;
            this.personalName = personalName;
        }

        public String getStandardName() {
            return this.standardName;
        }

        public String getPersonalName() {
            return this.personalName;
        }

        public String[] getTokens() {
            return new String[]{this.standardName, this.personalName};
        }
    }
}

