/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDelta;
import com.ibm.team.enterprise.systemdefinition.common.dto.DTOFactory;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class CompareListResult<T> {
    protected boolean sorted = false;

    public CompareListResult() {
    }

    public CompareListResult(boolean sorted) {
        this.sorted = sorted;
    }

    private EMFWrappedList getMissingItems(List<T> fromList, List<T> checkList, EMFWrappedList changeList) {
        if (fromList == null || checkList == null || changeList == null) {
            return null;
        }
        EMFWrappedList missing = new EMFWrappedList();
        for (T from : fromList) {
            boolean found = false;
            for (T check : checkList) {
                if (!changeList.contains(from) && !CompareListResult.equals(from, check)) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(from);
        }
        return missing;
    }

    public void generateListChangeLogDelta(List<ChangeLogDelta> changes, String id, List<T> oldValue, List<T> newValue, boolean isNew, DeltaType type) {
        if (changes == null || newValue == null) {
            return;
        }
        ChangeLogDelta changeDelta = null;
        if (isNew) {
            if (newValue.size() > 0) {
                changeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                changeDelta.setId(id);
                changeDelta.setType(DeltaType.LIST);
                for (T listItem : newValue) {
                    this.generateListItemChangLogDelta((List<ChangeLogDelta>)changeDelta.getSubChanges(), null, listItem, true, type == null ? DeltaType.ADD : type);
                }
                changes.add(changeDelta);
            }
        } else {
            EMFWrappedList oldChangeList = new EMFWrappedList();
            EMFWrappedList newChangeList = new EMFWrappedList();
            this.generateChangedLists(newValue, oldValue, newChangeList, oldChangeList);
            EMFWrappedList addList = this.getMissingItems(newValue, oldValue, newChangeList);
            EMFWrappedList deleteList = this.getMissingItems(oldValue, newValue, oldChangeList);
            ArrayList<ChangeLogDelta> subChangeDeltas = new ArrayList<ChangeLogDelta>();
            if (addList != null && addList.size() > 0) {
                for (Object listItem : addList) {
                    this.generateListItemChangLogDelta(subChangeDeltas, null, listItem, true, DeltaType.ADD);
                }
            }
            if (this.sorted && oldValue != null && oldValue.size() > 0 && newValue != null && newValue.size() > 0) {
                this.generateOrderedChangedLists(subChangeDeltas, oldValue, newValue, addList, deleteList);
            } else {
                int changeSize = newChangeList.size();
                if (newChangeList != null && changeSize > 0) {
                    int i = 0;
                    while (i < changeSize) {
                        Object oldOne = oldChangeList.get(i);
                        Object newOne = newChangeList.get(i);
                        this.generateListItemChangLogDelta(subChangeDeltas, oldOne, newOne, false, DeltaType.CHANGE);
                        ++i;
                    }
                }
            }
            if (deleteList != null && deleteList.size() > 0) {
                for (Object listItem : deleteList) {
                    this.generateListItemChangLogDelta(subChangeDeltas, null, listItem, true, DeltaType.DELETE);
                }
            }
            if (subChangeDeltas.size() > 0) {
                changeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                changeDelta.setId(id);
                changeDelta.setType(DeltaType.LIST);
                changeDelta.getSubChanges().addAll(subChangeDeltas);
                changes.add(changeDelta);
            }
            if (addList != null) {
                addList.clear();
                addList = null;
            }
            if (deleteList != null) {
                deleteList.clear();
                deleteList = null;
            }
            if (newChangeList != null) {
                newChangeList.clear();
                newChangeList = null;
            }
            if (oldChangeList != null) {
                oldChangeList.clear();
                oldChangeList = null;
            }
            if (subChangeDeltas != null) {
                subChangeDeltas.clear();
                subChangeDeltas = null;
            }
        }
    }

    private void generateOrderedChangedLists(List<ChangeLogDelta> subChangeDeltas, List<T> oldValue, List<T> newValue, EMFWrappedList addList, EMFWrappedList deleteList) {
        if (oldValue == null || newValue == null || new EMFWrappedList(newValue).equals(oldValue)) {
            return;
        }
        ChangeLogDelta delta = DTOFactory.eINSTANCE.createChangeLogDelta();
        delta.setId(null);
        delta.setType(DeltaType.ORDER_CHANGE);
        ChangeLogDelta oldDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
        oldDelta.setId(SystemDefinitionUtil.SYSTEM_DEF_PRELIST_TAG.getWholeTagName());
        oldDelta.setType(DeltaType.ORDER_CHANGE);
        for (T oldItem : oldValue) {
            this.generateListItemChangLogDelta((List<ChangeLogDelta>)oldDelta.getSubChanges(), null, oldItem, true, DeltaType.ADD);
        }
        delta.getSubChanges().add((Object)oldDelta);
        ChangeLogDelta newDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
        newDelta.setId(SystemDefinitionUtil.SYSTEM_DEF_CURLIST_TAG.getWholeTagName());
        newDelta.setType(DeltaType.ORDER_CHANGE);
        for (T newItem : newValue) {
            boolean isNew = true;
            if (addList.contains(newItem)) {
                isNew = false;
            }
            this.generateListItemChangLogDelta((List<ChangeLogDelta>)newDelta.getSubChanges(), null, newItem, isNew, DeltaType.ADD);
        }
        for (T deleteItem : deleteList) {
            this.generateListItemChangLogDelta((List<ChangeLogDelta>)newDelta.getSubChanges(), deleteItem, null, false, DeltaType.DELETE);
        }
        delta.getSubChanges().add((Object)newDelta);
        subChangeDeltas.add(delta);
    }

    protected abstract void generateListItemChangLogDelta(List<ChangeLogDelta> var1, T var2, T var3, boolean var4, DeltaType var5);

    protected abstract void generateChangedLists(List<T> var1, List<T> var2, EMFWrappedList var3, EMFWrappedList var4);

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (object1.equals(object2)) {
            return true;
        }
        if (object1 instanceof IStringHelper && object2 instanceof IStringHelper) {
            IStringHelper helper1 = (IStringHelper)object1;
            IStringHelper helper2 = (IStringHelper)object2;
            return CompareListResult.testStringsWithNull(helper1.getValue(), helper2.getValue());
        }
        if (object1 instanceof ITranslatorEntry && object2 instanceof ITranslatorEntry) {
            ITranslatorEntry entry1 = (ITranslatorEntry)object1;
            ITranslatorEntry entry2 = (ITranslatorEntry)object2;
            return CompareListResult.testStringsWithNull(entry1.getKind(), entry2.getKind()) && CompareListResult.testStringsWithNull(entry1.getCondition(), entry2.getCondition()) && CompareListResult.testStringsWithNull(entry1.getStepName(), entry2.getStepName()) && CompareListResult.testStringsWithNull(entry1.getValue(), entry2.getValue());
        }
        if (object1 instanceof IDependencyType && object2 instanceof IDependencyType) {
            IDependencyType depType1 = (IDependencyType)object1;
            IDependencyType depType2 = (IDependencyType)object2;
            return CompareListResult.testStringsWithNull(depType1.getName(), depType2.getName()) && depType1.getLevel() == depType2.getLevel();
        }
        if (object1 instanceof EObject && object2 instanceof EObject) {
            return EcoreUtil.equals((EObject)((EObject)object1), (EObject)((EObject)object2));
        }
        return false;
    }

    private static boolean testStringsWithNull(String left, String right) {
        boolean equal = false;
        if (left == null && right == null) {
            equal = true;
        } else if (left != null && right != null && left.equals(right)) {
            equal = true;
        }
        return equal;
    }

    protected class EMFWrappedList
    implements Iterable<T> {
        final List<T> innerList;

        public EMFWrappedList() {
            this(new ArrayList());
        }

        public EMFWrappedList(List<T> wrapped) {
            this.innerList = wrapped;
        }

        public boolean contains(T object) {
            if (object instanceof EObject) {
                for (Object object2 : this.innerList) {
                    if (!CompareListResult.equals(object, object2)) continue;
                    return true;
                }
                return false;
            }
            return this.innerList.contains(object);
        }

        public int size() {
            return this.innerList.size();
        }

        public T get(int i) {
            return this.innerList.get(i);
        }

        public boolean add(T object) {
            return this.innerList.add(object);
        }

        public void clear() {
            this.innerList.clear();
        }

        @Override
        public Iterator<T> iterator() {
            return this.innerList.iterator();
        }

        public boolean equals(Object o) {
            if (o instanceof List) {
                List list = (List)o;
                if (list.size() != this.innerList.size()) {
                    return false;
                }
                Iterator it1 = this.innerList.iterator();
                Iterator it2 = list.iterator();
                while (it1.hasNext()) {
                    Object object2;
                    Object object1 = it1.next();
                    if (CompareListResult.equals(object1, object2 = it2.next())) continue;
                    return false;
                }
                return true;
            }
            return super.equals(o);
        }
    }
}

