/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHistoryProcessor;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDelta;
import com.ibm.team.enterprise.systemdefinition.common.dto.DTOFactory;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.util.CompareListResult;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.textdifferencer.TextDifferencer;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ChangeLogUtil {
    private static final List<ISystemDefinitionHistoryProcessor> helpers = new ArrayList<ISystemDefinitionHistoryProcessor>();

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.systemdefinition.history");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("processor")) {
                try {
                    Object helper = element.createExecutableExtension("class");
                    if (helper instanceof ISystemDefinitionHistoryProcessor) {
                        helpers.add((ISystemDefinitionHistoryProcessor)helper);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static ChangeLogDTO computeChanges(ISystemDefinition oldSystemDefinition, ISystemDefinition newSystemDefinition) throws TeamRepositoryException {
        ChangeLogDTO result = DTOFactory.eINSTANCE.createChangeLogDTO();
        result.setModifiedBy(newSystemDefinition.getModifiedBy());
        Date modifiedDate = newSystemDefinition.modified();
        if (modifiedDate != null) {
            result.setModifiedDate(new Timestamp(modifiedDate.getTime()));
        }
        String oldName = null;
        String oldDesription = null;
        boolean desNeedDiff = false;
        Map<String, String> oldProperties = null;
        if (oldSystemDefinition != null) {
            oldName = oldSystemDefinition.getName();
            oldDesription = oldSystemDefinition.getDescription();
            desNeedDiff = true;
            oldProperties = oldSystemDefinition.getProperties();
        }
        boolean isNew = oldSystemDefinition == null;
        ChangeLogUtil.generateChangeLogDelta(result.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NAME_TAG.getWholeTagName(), oldName, newSystemDefinition.getName(), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(result.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_DESCRIPTION_TAG.getWholeTagName(), oldDesription, newSystemDefinition.getDescription(), desNeedDiff, isNew);
        for (ISystemDefinitionHistoryProcessor helper : helpers) {
            helper.process(oldSystemDefinition, newSystemDefinition, result);
        }
        ChangeLogUtil.generatePropertiesChangeLogDelta(result, SystemDefinitionUtil.SYSTEM_DEF_PROPERTIES_TAG.getWholeTagName(), newSystemDefinition.getProperties(), oldProperties, false, isNew);
        return result;
    }

    public static String getHTMLContent(Object oldValue, Object newValue, boolean needHTMLDiff, boolean isNew) {
        String result = null;
        if (oldValue == null && newValue == null) {
            return result;
        }
        StringBuilder buffer = new StringBuilder();
        if (newValue != null) {
            String newStr = ChangeLogUtil.getHTMLText(newValue);
            if (isNew || oldValue == null) {
                buffer.append(newStr);
            } else if (!CompareListResult.equals(newValue, oldValue)) {
                String oldStr = ChangeLogUtil.getHTMLText(oldValue);
                if (needHTMLDiff) {
                    buffer.append(TextDifferencer.diff((String)oldStr, (String)newStr, null));
                } else {
                    buffer.append(oldStr).append("&nbsp;&nbsp;&rarr;&nbsp;&nbsp;").append(newStr);
                }
            } else {
                buffer = null;
            }
        } else if (oldValue != null) {
            buffer.append(ChangeLogUtil.getHTMLText(oldValue));
        }
        if (buffer != null) {
            result = buffer.toString();
        }
        return result;
    }

    public static String getHTMLText(Object text) {
        String result = null;
        if (text != null) {
            result = XMLString.createFromPlainText((String)text.toString()).getXMLText();
        }
        return result;
    }

    public static ChangeLogDelta generateDefaultChangeLogDelta(String id, Object oldValue, Object newValue, boolean needHTMLDiff, boolean isNew) {
        String changeContent;
        ChangeLogDelta changeDelta = null;
        if (needHTMLDiff && !isNew) {
            if (oldValue == null) {
                oldValue = "";
            }
            if (newValue == null) {
                newValue = "";
            }
        }
        if ((changeContent = ChangeLogUtil.getHTMLContent(oldValue, newValue, needHTMLDiff, isNew)) != null) {
            changeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
            changeDelta.setId(id);
            changeDelta.setHtmlContent(changeContent);
            changeDelta.setType(ChangeLogUtil.getDeltaType(oldValue, newValue));
        }
        return changeDelta;
    }

    public static boolean addValuesChangeLogDelta(List<ChangeLogDelta> changes, String id, Object oldValue, Object newValue, DeltaType type, boolean sameNeeded, boolean needDiff) {
        boolean result = false;
        if (changes == null) {
            return result;
        }
        ChangeLogDelta changeDelta = null;
        changeDelta = ChangeLogUtil.generateValuesChangeLogDelta(id, oldValue, newValue, type, sameNeeded, needDiff);
        if (changeDelta != null) {
            changes.add(changeDelta);
            result = true;
        }
        return result;
    }

    public static ChangeLogDelta generateValuesChangeLogDelta(String id, Object oldValue, Object newValue, DeltaType type, boolean sameNeeded, boolean needDiff) {
        ChangeLogDelta changeDelta = null;
        if (id == null) {
            return changeDelta;
        }
        if (oldValue == null && newValue != null || newValue == null && oldValue != null || newValue != null && !CompareListResult.equals(newValue, oldValue) || newValue != null && sameNeeded && CompareListResult.equals(newValue, oldValue)) {
            changeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
            changeDelta.setId(id);
            changeDelta.setOldValue(oldValue == null ? null : oldValue.toString());
            changeDelta.setNewValue(newValue == null ? null : newValue.toString());
            changeDelta.setNeedDiff(needDiff);
            changeDelta.setType(type == null ? ChangeLogUtil.getDeltaType(oldValue, newValue) : type);
        }
        return changeDelta;
    }

    public static void generateVariableListChangeLogDelta(ChangeLogDTO changeLog, String id, List<IVariable> oldValue, List<IVariable> newValue, boolean isNew) {
        if (changeLog == null || newValue == null) {
            return;
        }
        CompareListResult<IVariable> variableResults = new CompareListResult<IVariable>(){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IVariable oldOne, IVariable newOne, boolean isNew, DeltaType type) {
                String valueHTML;
                if (newOne == null) {
                    return;
                }
                String oldValue = null;
                boolean isTextDiff = false;
                if (!isNew && oldOne != null) {
                    oldValue = oldOne.getValue();
                }
                if (DeltaType.CHANGE == type) {
                    isTextDiff = true;
                }
                if ((valueHTML = ChangeLogUtil.getHTMLContent(oldValue, newOne.getValue(), isTextDiff, isNew)) != null && valueHTML.length() > 0) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(null);
                    vChangeDelta.setType(type);
                    StringBuilder htmlBuilder = new StringBuilder();
                    htmlBuilder.append(newOne.getName()).append("&nbsp;").append(":").append("&nbsp;").append(valueHTML);
                    vChangeDelta.setHtmlContent(htmlBuilder.toString());
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IVariable> fromList, List<IVariable> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromChangeList == null || checkChangeList == null) {
                    return;
                }
                for (IVariable from : fromList) {
                    String name = from.getName();
                    IVariable founded = null;
                    for (IVariable check : checkList) {
                        if (name == null || !name.equals(check.getName()) || CompareListResult.equals(from, check)) continue;
                        founded = check;
                        break;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        variableResults.generateListChangeLogDelta((List<ChangeLogDelta>)changeLog.getChanges(), id, oldValue, newValue, isNew, null);
    }

    public static void generateHFSOutputListChangeLogDelta(ChangeLogDTO changeLog, String id, List<IHFSOutput> oldValue, List<IHFSOutput> newValue, boolean isNew) {
        if (changeLog == null || newValue == null) {
            return;
        }
        CompareListResult<IHFSOutput> outputResults = new CompareListResult<IHFSOutput>(){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IHFSOutput oldOne, IHFSOutput newOne, boolean isNew, DeltaType type) {
                if (newOne == null) {
                    return;
                }
                String newPath = newOne.getPath();
                String newCondition = newOne.getCondition();
                String newDeployType = newOne.getDeployType();
                String oldPath = null;
                String oldCondition = null;
                String oldDeployType = null;
                if (!isNew && oldOne != null) {
                    oldPath = oldOne.getPath();
                    oldCondition = oldOne.getCondition();
                    oldDeployType = oldOne.getDeployType();
                }
                boolean isTextDiff = DeltaType.CHANGE == type;
                ArrayList<ChangeLogDelta> subChanges = new ArrayList<ChangeLogDelta>();
                ChangeLogUtil.generateChangeLogDelta(subChanges, SystemDefinitionUtil.TRANSLATOR_OUTPUT_PATH_TAG.getWholeTagName(), oldPath, newPath, isTextDiff, isNew);
                ChangeLogUtil.generateChangeLogDelta(subChanges, SystemDefinitionUtil.TRANSLATOR_OUTPUT_CONDITION_TAG.getWholeTagName(), oldCondition, newCondition, isTextDiff, isNew);
                ChangeLogUtil.generateChangeLogDelta(subChanges, SystemDefinitionUtil.TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG.getWholeTagName(), oldDeployType, newDeployType, isTextDiff, isNew);
                if (!subChanges.isEmpty()) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(SystemDefinitionUtil.TRANSLATOR_OUTPUT_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    ChangeLogUtil.generateChangeLogDelta(vChangeDelta.getSubChanges(), null, null, newOne.getPath(), false, isNew);
                    vChangeDelta.getSubChanges().addAll(subChanges);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IHFSOutput> fromList, List<IHFSOutput> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromChangeList == null || checkChangeList == null) {
                    return;
                }
                for (IHFSOutput from : fromList) {
                    String path = from.getPath();
                    IHFSOutput founded = null;
                    for (IHFSOutput check : checkList) {
                        if (path == null || !path.equals(check.getPath()) || from.equals(check)) continue;
                        founded = check;
                        break;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        outputResults.generateListChangeLogDelta((List<ChangeLogDelta>)changeLog.getChanges(), id, oldValue, newValue, isNew, null);
    }

    public static void generateScopedPropertyListChangeLogDelta(ChangeLogDTO changeLog, String id, List<IScopedProperty> oldValue, List<IScopedProperty> newValue, boolean isNew) {
        if (changeLog == null || newValue == null) {
            return;
        }
        CompareListResult<IScopedProperty> scopedPropertyResults = new CompareListResult<IScopedProperty>(){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IScopedProperty oldOne, IScopedProperty newOne, boolean isNew, DeltaType type) {
                if (newOne == null) {
                    return;
                }
                String newValue = newOne.getValue();
                String newCondition = newOne.getCondition();
                String oldValue = null;
                String oldCondition = null;
                if (!isNew && oldOne != null) {
                    oldValue = oldOne.getValue();
                    oldCondition = oldOne.getCondition();
                }
                boolean isTextDiff = DeltaType.CHANGE == type;
                ArrayList<ChangeLogDelta> subChanges = new ArrayList<ChangeLogDelta>();
                ChangeLogUtil.generateChangeLogDelta(subChanges, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG.getWholeTagName(), oldValue, newValue, isTextDiff, isNew);
                ChangeLogUtil.generateChangeLogDelta(subChanges, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG.getWholeTagName(), oldCondition, newCondition, isTextDiff, isNew);
                if (!subChanges.isEmpty()) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTY_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    ChangeLogUtil.generateChangeLogDelta(vChangeDelta.getSubChanges(), null, null, newOne.getName(), false, isNew);
                    vChangeDelta.getSubChanges().addAll(subChanges);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IScopedProperty> fromList, List<IScopedProperty> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromChangeList == null || checkChangeList == null) {
                    return;
                }
                for (IScopedProperty from : fromList) {
                    String name = from.getName();
                    IScopedProperty founded = null;
                    for (IScopedProperty check : checkList) {
                        if (name == null || !name.equals(check.getName()) || CompareListResult.equals(from, check)) continue;
                        founded = check;
                        break;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        scopedPropertyResults.generateListChangeLogDelta((List<ChangeLogDelta>)changeLog.getChanges(), id, oldValue, newValue, isNew, null);
    }

    public static void generatePropertiesChangeLogDelta(ChangeLogDTO changeLog, String id, Map<String, String> oldValue, Map<String, String> newValue, boolean needHTMLDiff, boolean isNew) {
        if (changeLog == null || newValue == null) {
            return;
        }
        String changeContent = ChangeLogUtil.getHTMLContent(oldValue, newValue, needHTMLDiff, isNew);
    }

    public static void generateChangeLogDelta(List<ChangeLogDelta> changes, String id, Object oldValue, Object newValue, boolean needHTMLDiff, boolean isNew) {
        if (changes == null || oldValue == null && newValue == null) {
            return;
        }
        ChangeLogDelta changeDelta = ChangeLogUtil.generateDefaultChangeLogDelta(id, oldValue, newValue, needHTMLDiff, isNew);
        if (changeDelta != null) {
            changes.add(changeDelta);
        }
    }

    public static DeltaType getDeltaType(Object oldValue, Object newValue) {
        DeltaType result = DeltaType.ADD;
        if (oldValue != null && newValue == null) {
            result = DeltaType.DELETE;
        } else if (oldValue != null && newValue != null && !CompareListResult.equals(oldValue, newValue)) {
            result = DeltaType.CHANGE;
        } else if (oldValue == null && newValue != null) {
            result = DeltaType.ADD;
        }
        return result;
    }

    public static void generateLangDefTranslatorCLD(List<ChangeLogDelta> changes, List<ITranslatorEntry> oldTranslatoers, List<ITranslatorEntry> newTranslatoers, boolean isNew, boolean ordered) {
        CompareListResult<ITranslatorEntry> comparedTranslaters = new CompareListResult<ITranslatorEntry>(ordered){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, ITranslatorEntry oldOne, ITranslatorEntry newOne, boolean isNew, DeltaType type) {
                if (oldOne == null && newOne == null) {
                    return;
                }
                String newKind = null;
                if (newOne != null) {
                    newKind = newOne.getKind();
                }
                if (oldOne != null) {
                    newKind = oldOne.getKind();
                }
                ArrayList<ChangeLogDelta> subchanges = new ArrayList<ChangeLogDelta>();
                if ("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable".equals(newKind)) {
                    boolean needDiff = false;
                    if (this.sorted && !isNew) {
                        needDiff = true;
                    }
                    ChangeLogUtil.generateChangeLogDelta(subchanges, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG.getWholeTagName(), oldOne == null ? null : oldOne.getValue(), newOne == null ? null : newOne.getValue(), needDiff, isNew);
                } else {
                    ChangeLogUtil.addValuesChangeLogDelta(subchanges, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG.getWholeTagName(), oldOne == null ? null : oldOne.getValue(), newOne == null ? null : newOne.getValue(), DeltaType.UUID, false, !isNew);
                }
                ChangeLogUtil.generateChangeLogDelta(subchanges, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG.getWholeTagName(), oldOne == null ? null : oldOne.getCondition(), newOne == null ? null : newOne.getCondition(), true, isNew);
                ChangeLogUtil.generateChangeLogDelta(subchanges, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG.getWholeTagName(), oldOne == null ? null : oldOne.getStepName(), newOne == null ? null : newOne.getStepName(), true, isNew);
                if (subchanges.size() > 0) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    vChangeDelta.getSubChanges().addAll(subchanges);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<ITranslatorEntry> fromList, List<ITranslatorEntry> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromChangeList == null || checkChangeList == null) {
                    return;
                }
                for (ITranslatorEntry from : fromList) {
                    String name = from.getValue();
                    ITranslatorEntry founded = null;
                    for (ITranslatorEntry check : checkList) {
                        if (name == null || !name.equals(check.getValue()) || CompareListResult.equals(from, check)) continue;
                        founded = check;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        comparedTranslaters.generateListChangeLogDelta(changes, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG.getWholeTagName(), oldTranslatoers, newTranslatoers, isNew, null);
    }

    public static void generateLangDefScannersCLD(List<ChangeLogDelta> changes, List<IStringHelper> oldScanners, List<IStringHelper> newScanners, boolean isNew) {
        CompareListResult<IStringHelper> comparedScanners = new CompareListResult<IStringHelper>(true){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IStringHelper oldOne, IStringHelper newOne, boolean isNew, DeltaType type) {
                ArrayList<ChangeLogDelta> changeDeltas = new ArrayList<ChangeLogDelta>();
                String oldValue = oldOne == null ? null : oldOne.getValue();
                String newValue = newOne == null ? null : newOne.getValue();
                ChangeLogUtil.addValuesChangeLogDelta(changeDeltas, SystemDefinitionUtil.LANGUAGE_DEF_SCANNER_TAG.getWholeTagName(), oldValue, newValue, DeltaType.UUID, false, !isNew);
                if (changeDeltas.size() > 0) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(null);
                    vChangeDelta.setType(type);
                    vChangeDelta.getSubChanges().addAll(changeDeltas);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IStringHelper> fromList, List<IStringHelper> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
            }
        };
        comparedScanners.generateListChangeLogDelta(changes, SystemDefinitionUtil.LANGUAGE_DEF_SCANNERS_TAG.getWholeTagName(), oldScanners, newScanners, isNew, null);
    }

    public static void generateLangDefPatterns(List<ChangeLogDelta> changes, List<IStringHelper> oldPatterns, List<IStringHelper> newPatterns, boolean isNew) {
        CompareListResult<IStringHelper> comparedPatterns = new CompareListResult<IStringHelper>(true){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IStringHelper oldOne, IStringHelper newOne, boolean isNew, DeltaType type) {
                ArrayList<ChangeLogDelta> changeDeltas = new ArrayList<ChangeLogDelta>();
                String oldValue = oldOne == null ? null : oldOne.getValue();
                String newValue = newOne == null ? null : newOne.getValue();
                ChangeLogUtil.addValuesChangeLogDelta(changeDeltas, SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG.getWholeTagName(), oldValue, newValue, DeltaType.UUID, false, !isNew);
                if (changeDeltas.size() > 0) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(null);
                    vChangeDelta.setType(type);
                    vChangeDelta.getSubChanges().addAll(changeDeltas);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IStringHelper> fromList, List<IStringHelper> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
            }
        };
        comparedPatterns.generateListChangeLogDelta(changes, SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG.getWholeTagName(), oldPatterns, newPatterns, isNew, null);
    }

    public static void generateLangDefDependencyTypesCLD(List<ChangeLogDelta> changes, List<IDependencyType> oldDependencyTyps, List<IDependencyType> newDependencyTyps, boolean isNew) {
        CompareListResult<IDependencyType> comparedDepenTypes = new CompareListResult<IDependencyType>(){

            @Override
            protected void generateListItemChangLogDelta(List<ChangeLogDelta> resultDeltas, IDependencyType oldOne, IDependencyType newOne, boolean isNew, DeltaType type) {
                if (newOne == null) {
                    return;
                }
                Integer oldLevel = null;
                List<ITranslatorEntry> oldTranslatoers = null;
                if (oldOne != null) {
                    oldLevel = oldOne.getLevel();
                    oldTranslatoers = oldOne.getTranslators();
                }
                ArrayList<ChangeLogDelta> subChanges = new ArrayList<ChangeLogDelta>();
                ChangeLogUtil.addValuesChangeLogDelta(subChanges, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG.getWholeTagName(), oldLevel, newOne.getLevel(), null, false, false);
                ChangeLogUtil.generateLangDefTranslatorCLD(subChanges, oldTranslatoers, newOne.getTranslators(), isNew || DeltaType.ADD == type || DeltaType.DELETE == type, false);
                if (subChanges.size() > 0) {
                    ChangeLogDelta vChangeDelta = DTOFactory.eINSTANCE.createChangeLogDelta();
                    vChangeDelta.setId(SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_TAG.getWholeTagName());
                    vChangeDelta.setType(type);
                    ChangeLogUtil.generateChangeLogDelta(vChangeDelta.getSubChanges(), null, null, newOne.getName(), false, isNew);
                    vChangeDelta.getSubChanges().addAll(subChanges);
                    resultDeltas.add(vChangeDelta);
                }
            }

            @Override
            protected void generateChangedLists(List<IDependencyType> fromList, List<IDependencyType> checkList, CompareListResult.EMFWrappedList fromChangeList, CompareListResult.EMFWrappedList checkChangeList) {
                if (fromChangeList == null || checkChangeList == null) {
                    return;
                }
                for (IDependencyType from : fromList) {
                    IDependencyType founded = null;
                    String name = from.getName();
                    for (IDependencyType check : checkList) {
                        if (from == null || !name.equals(check.getName()) || CompareListResult.equals(from, check)) continue;
                        founded = check;
                    }
                    if (founded == null) continue;
                    fromChangeList.add(from);
                    checkChangeList.add(founded);
                }
            }
        };
        comparedDepenTypes.generateListChangeLogDelta(changes, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPES_TAG.getWholeTagName(), oldDependencyTyps, newDependencyTyps, isNew, null);
    }
}

