/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.parsers.ExtensionParserFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SystemDefinitionParserFactory {
    public ISystemDefinitionParser getSystemDefinitionParser(com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        String jfsType = SystemDefinitionUtil.convertToJFSType(systemDefinition.getItemType());
        if (jfsType != null) {
            String platform;
            String string = platform = systemDefinition instanceof IZosPlatformObject ? "zos" : "ibmi";
            if (SystemDefinitionUtil.isTypeOf(systemDefinition.getItemType(), com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition.ITEM_TYPE)) {
                com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition resdef = (com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition)systemDefinition;
                return this.getResourceDefinitionParser(platform, Integer.toString(resdef.getUsageType()));
            }
            return this.getSystemDefinitionParser(jfsType, platform);
        }
        return null;
    }

    public ISystemDefinitionParser getSystemDefinitionParser(String xmlContent) throws TeamRepositoryException {
        DiscoverTypePlatformContentHandler contentHandler = new DiscoverTypePlatformContentHandler();
        try {
            DefaultHandler handler = new DefaultHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(contentHandler);
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(new ByteArrayInputStream(xmlContent.getBytes("UTF-8"))));
        }
        catch (EnoughDataException e) {
            return this.getSystemDefinitionParser(contentHandler.getType(), contentHandler.getPlatform());
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return null;
    }

    public ISystemDefinitionParser getSystemDefinitionParser(String type, String platform) {
        return ExtensionParserFactory.getInstance().getSystemDefinitionParser(type, platform);
    }

    public ISystemDefinitionParser getSystemDefinitionParser(ISystemDefinition systemDefinition) {
        if (systemDefinition.getType().equals("resourcedefinition")) {
            return ExtensionParserFactory.getInstance().getResourceDefinitionParser(systemDefinition.getPlatform(), String.valueOf(((IResourceDefinition)systemDefinition).getUsageType()));
        }
        return ExtensionParserFactory.getInstance().getSystemDefinitionParser(systemDefinition.getType(), systemDefinition.getPlatform());
    }

    public ISystemDefinitionParser getResourceDefinitionParser(String xmlContent) throws TeamRepositoryException {
        DiscoverUsageTypePlatformContentHandler contentHandler = new DiscoverUsageTypePlatformContentHandler();
        try {
            DefaultHandler handler = new DefaultHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(contentHandler);
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(new ByteArrayInputStream(xmlContent.getBytes("UTF-8"))));
        }
        catch (EnoughDataException e) {
            return this.getResourceDefinitionParser(contentHandler.getPlatform(), contentHandler.getUsageType());
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return null;
    }

    public ISystemDefinitionParser getResourceDefinitionParser(String platform, String usageType) {
        return ExtensionParserFactory.getInstance().getResourceDefinitionParser(platform, usageType);
    }

    class DiscoverTypePlatformContentHandler
    implements ContentHandler {
        private String type;
        private String platform;
        private boolean inType = false;
        private boolean inPlatform = false;

        DiscoverTypePlatformContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("systemdefinition:type")) {
                this.inType = true;
            } else if (qName.equals("systemdefinition:platform")) {
                this.inPlatform = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inType) {
                this.type = new String(ch, start, length);
            } else if (this.inPlatform) {
                this.platform = new String(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("systemdefinition:type")) {
                this.inType = false;
            } else if (qName.equals("systemdefinition:platform")) {
                this.inPlatform = false;
            }
            if (this.type != null && this.platform != null) {
                throw new EnoughDataException();
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public String getType() {
            return this.type;
        }

        public String getPlatform() {
            return this.platform;
        }
    }

    class DiscoverUsageTypePlatformContentHandler
    implements ContentHandler {
        private String usageType;
        private String platform;
        private boolean inUsageType = false;
        private boolean inPlatform = false;

        DiscoverUsageTypePlatformContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("resourcedefinition:usageType")) {
                this.inUsageType = true;
            } else if (qName.equals("systemdefinition:platform")) {
                this.inPlatform = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inUsageType) {
                this.usageType = new String(ch, start, length);
            } else if (this.inPlatform) {
                this.platform = new String(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("resourcedefinition:usageType")) {
                this.inUsageType = false;
            } else if (qName.equals("systemdefinition:platform")) {
                this.inPlatform = false;
            }
            if (this.usageType != null && this.platform != null) {
                throw new EnoughDataException();
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public String getUsageType() {
            return this.usageType;
        }

        public String getPlatform() {
            return this.platform;
        }
    }

    class EnoughDataException
    extends SAXException {
    }
}

