/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandleParser;
import com.ibm.team.enterprise.systemdefinition.common.ResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.SystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.Reader;
import java.io.StringReader;

public class SystemDefinitionHandleParser
implements ISystemDefinitionHandleParser {
    @Override
    public JSONObject convertToJSON(ISystemDefinitionHandle systemDefinitionHandle) throws TeamRepositoryException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"uuid", (Object)systemDefinitionHandle.getUuid().getUuidValue());
        jsonObj.put((Object)"name", (Object)systemDefinitionHandle.getName());
        jsonObj.put((Object)"platform", (Object)systemDefinitionHandle.getPlatform().name());
        jsonObj.put((Object)"type", (Object)systemDefinitionHandle.getType());
        jsonObj.put((Object)"archived", (Object)String.valueOf(systemDefinitionHandle.isArchived()));
        if (systemDefinitionHandle.getProjectAreaUUID() != null) {
            jsonObj.put((Object)"projectAreaUUID", (Object)systemDefinitionHandle.getProjectAreaUUID().getUuidValue());
        }
        if (systemDefinitionHandle.getType().equals("resourcedefinition")) {
            jsonObj.put((Object)"usageType", (Object)String.valueOf(((IResourceDefinitionHandle)systemDefinitionHandle).getUsageType()));
        }
        return jsonObj;
    }

    public JSONObject convertToJSON(ISystemDefinition systemDefinition) throws TeamRepositoryException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"uuid", (Object)systemDefinition.getItemId().getUuidValue());
        jsonObj.put((Object)"name", (Object)systemDefinition.getName());
        if (systemDefinition instanceof IZosPlatformObject) {
            jsonObj.put((Object)"platform", (Object)"zos");
        } else {
            jsonObj.put((Object)"platform", (Object)"ibmi");
        }
        jsonObj.put((Object)"type", (Object)SystemDefinitionUtil.convertToJFSType(systemDefinition.getItemType()));
        jsonObj.put((Object)"archived", (Object)String.valueOf(systemDefinition.isArchived()));
        if (systemDefinition.getProjectArea() != null) {
            jsonObj.put((Object)"projectAreaUUID", (Object)systemDefinition.getProjectArea().getItemId().getUuidValue());
        }
        if (SystemDefinitionUtil.isTypeOf(systemDefinition.getItemType(), IResourceDefinition.ITEM_TYPE)) {
            jsonObj.put((Object)"usageType", (Object)String.valueOf(((IResourceDefinition)systemDefinition).getUsageType()));
        }
        return jsonObj;
    }

    @Override
    public ISystemDefinitionHandle parseJSON(String jsonContent) throws TeamRepositoryException {
        try {
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(jsonContent));
            return this.parseJSON(jsonObj);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public ISystemDefinitionHandle parseJSON(JSONObject jsonObj) throws TeamRepositoryException {
        try {
            String uuid = (String)jsonObj.get((Object)"uuid");
            String name = (String)jsonObj.get((Object)"name");
            String type = (String)jsonObj.get((Object)"type");
            String platform = (String)jsonObj.get((Object)"platform");
            String usageType = (String)jsonObj.get((Object)"usageType");
            String projectAreaUUIDValue = (String)jsonObj.get((Object)"projectAreaUUID");
            boolean isArchived = Boolean.parseBoolean((String)jsonObj.get((Object)"archived"));
            UUID projectAreaUUID = this.isValidUUID(projectAreaUUIDValue) ? UUID.valueOf((String)projectAreaUUIDValue) : null;
            SystemDefinitionHandle handle = type.equals("resourcedefinition") ? new ResourceDefinitionHandle(UUID.valueOf((String)uuid), name, ISystemDefinition.Platform.valueOf(platform), type, projectAreaUUID, Integer.parseInt(usageType), isArchived) : new SystemDefinitionHandle(UUID.valueOf((String)uuid), name, ISystemDefinition.Platform.valueOf(platform), type, projectAreaUUID, isArchived);
            return handle;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected boolean isValidUUID(String value) {
        if (value != null) {
            try {
                UUID.valueOf((String)value);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

