/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionParserFactory {
    private static ExtensionParserFactory instance;
    private final HashMap<String, IdParserPairs> systemDefinitionParserMap = new HashMap();
    private final HashMap<String, IdParserPairs> resourceDefinitionParserMap = new HashMap();

    private ExtensionParserFactory() {
    }

    public static ExtensionParserFactory getInstance() {
        if (instance == null) {
            instance = new ExtensionParserFactory();
            instance.init();
        }
        return instance;
    }

    public ISystemDefinitionParser getSystemDefinitionParser(String type, String platform) {
        IdParserPairs pairs = this.systemDefinitionParserMap.get(type);
        if (pairs != null) {
            return pairs.getParser(platform);
        }
        return null;
    }

    public List<String> getSystemDefinitionParserTypes(String platform) {
        return new ArrayList<String>(this.systemDefinitionParserMap.keySet());
    }

    public ISystemDefinitionParser getResourceDefinitionParser(String platform, String usageType) {
        IdParserPairs pairs = this.resourceDefinitionParserMap.get(platform);
        if (pairs != null) {
            return pairs.getParser(usageType);
        }
        return null;
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.getSystemDefinitionParserExtensions(registry);
        this.getResourceDefinitionParserExtensions(registry);
    }

    private void getSystemDefinitionParserExtensions(IExtensionRegistry registry) {
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.systemdefinition.parsers");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("parser")) {
                String type = element.getAttribute("type");
                String platform = element.getAttribute("platform");
                ISystemDefinitionParser parser = this.createSystemDefinitionParser(element);
                if (type != null && !type.equals("")) {
                    IdParserPairs pairs = this.systemDefinitionParserMap.get(type);
                    if (pairs == null) {
                        pairs = new IdParserPairs();
                        this.systemDefinitionParserMap.put(type, pairs);
                    }
                    pairs.addPair(new IdParserPair(platform, parser));
                }
            }
            ++i;
        }
    }

    private void getResourceDefinitionParserExtensions(IExtensionRegistry registry) {
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.resourcedefinition.parsers");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("parser")) {
                String usageType = element.getAttribute("usageType");
                String platform = element.getAttribute("platform");
                ISystemDefinitionParser parser = this.createSystemDefinitionParser(element);
                if (platform != null && !platform.equals("")) {
                    IdParserPairs pairs = this.resourceDefinitionParserMap.get(platform);
                    if (pairs == null) {
                        pairs = new IdParserPairs();
                        this.resourceDefinitionParserMap.put(platform, pairs);
                    }
                    pairs.addPair(new IdParserPair(usageType, parser));
                }
            }
            ++i;
        }
    }

    private ISystemDefinitionParser createSystemDefinitionParser(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension("class");
            if (object instanceof ISystemDefinitionParser) {
                return (ISystemDefinitionParser)object;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    class IdParserPair {
        protected String id;
        protected ISystemDefinitionParser parser;

        public IdParserPair(String id, ISystemDefinitionParser parser) {
            this.id = id;
            this.parser = parser;
        }
    }

    class IdParserPairs {
        List<IdParserPair> pairs = new ArrayList<IdParserPair>();

        public void addPair(IdParserPair aPair) {
            for (IdParserPair pair : this.pairs) {
                if (!pair.id.equals(aPair.id)) continue;
                return;
            }
            this.pairs.add(aPair);
        }

        public ISystemDefinitionParser getParser(String id) {
            for (IdParserPair pair : this.pairs) {
                if (!pair.id.equals(id)) continue;
                return pair.parser;
            }
            return null;
        }

        public List<IdParserPair> getPairs() {
            return this.pairs;
        }
    }
}

