/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.HFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Variable;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractSystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTranslatorParser
extends AbstractSystemDefinitionParser {
    @Override
    protected final ISystemDefinition newSystemDefinition() {
        return this.newTranslator();
    }

    protected abstract ITranslator newTranslator();

    @Override
    protected void parseSystemDefinition(Element rdfDescriptionElement, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.parseSystemDefinition(rdfDescriptionElement, systemDefinition);
        this.parseTranslator(rdfDescriptionElement, (ITranslator)systemDefinition);
    }

    protected void parseTranslator(Element rdfDescriptionElement, ITranslator translator) {
        NodeList outputNodes;
        NodeList variableNodes;
        String[] attrs = this.readAttributesFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.TRANSLATOR_ADDITIONAL_PATH_ENTRY_TAG);
        if (attrs != null) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                translator.getAdditionalPath().add(attr);
                ++n2;
            }
        }
        if ((variableNodes = rdfDescriptionElement.getElementsByTagNameNS(SystemDefinitionUtil.TRANSLATOR_VARIABLE_TAG.getNamespace(), SystemDefinitionUtil.TRANSLATOR_VARIABLE_TAG.getTagName())) != null) {
            int length = variableNodes.getLength();
            translator.getVariables().clear();
            int i = 0;
            while (i < length) {
                IVariable variable = this.readVariable(variableNodes.item(i));
                if (variable != null) {
                    translator.getVariables().add(variable);
                }
                ++i;
            }
        }
        if (translator.getHFSOutputs() != null && (outputNodes = rdfDescriptionElement.getElementsByTagNameNS(SystemDefinitionUtil.TRANSLATOR_OUTPUT_TAG.getNamespace(), SystemDefinitionUtil.TRANSLATOR_OUTPUT_TAG.getTagName())) != null) {
            int length = outputNodes.getLength();
            translator.getHFSOutputs().clear();
            int i = 0;
            while (i < length) {
                IHFSOutput output = this.readOutput(outputNodes.item(i));
                if (output != null) {
                    translator.getHFSOutputs().add(output);
                }
                ++i;
            }
        }
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.TRANSLATOR_NAMESPACE.getPrefix()).toString());
        attr.setValue(SystemDefinitionUtil.TRANSLATOR_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        ITranslator translator = (ITranslator)systemDefinition;
        Element additionalPathElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.TRANSLATOR_ADDITIONAL_PATH_TAG);
        List<String> addPath = translator.getAdditionalPath();
        if (addPath != null && addPath.size() > 0) {
            for (String p : addPath) {
                this.createPropertyElementNS(additionalPathElement, doc, SystemDefinitionUtil.TRANSLATOR_ADDITIONAL_PATH_ENTRY_TAG, p);
            }
        }
        List<IVariable> variables = translator.getVariables();
        Element variablesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLES_TAG);
        if (variables != null && variables.size() > 0) {
            for (IVariable v : variables) {
                Element variableElement = this.createPropertyElementNS(variablesElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_TAG, null);
                this.createPropertyElementNS(variableElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_NAME_TAG, v.getName());
                this.createPropertyElementNS(variableElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_VALUE_TAG, v.getValue());
                String type = null;
                type = v.getType() == 0 ? "predefined" : "fixed";
                this.createPropertyElementNS(variableElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_TYPE_TAG, type);
            }
        }
        List<IHFSOutput> outputs = translator.getHFSOutputs();
        Element outputsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUTS_TAG);
        if (outputs != null && outputs.size() > 0) {
            for (IHFSOutput o : outputs) {
                Element outputElement = this.createPropertyElementNS(outputsElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_TAG, null);
                this.createPropertyElementNS(outputElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_PATH_TAG, o.getPath());
                this.createPropertyElementNS(outputElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_CONDITION_TAG, o.getCondition());
                this.createPropertyElementNS(outputElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG, o.getDeployType());
            }
        }
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        com.ibm.team.enterprise.systemdefinition.common.model.ITranslator translator = (com.ibm.team.enterprise.systemdefinition.common.model.ITranslator)systemDefinition;
        List<com.ibm.team.enterprise.systemdefinition.common.model.IVariable> variables = translator.getVariables();
        Element variablesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLES_TAG);
        if (variables != null && variables.size() > 0) {
            for (com.ibm.team.enterprise.systemdefinition.common.model.IVariable v : variables) {
                Element variableElement = this.createPropertyElementNS(variablesElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_TAG, null);
                this.createPropertyElementNS(variableElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_NAME_TAG, v.getName());
                this.createPropertyElementNS(variableElement, doc, SystemDefinitionUtil.TRANSLATOR_VARIABLE_VALUE_TAG, v.getValue());
            }
        }
    }

    private IVariable readVariable(Node node) {
        Variable variable = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            variable = new Variable();
            String attr = this.readAttributeFromChildElement(element, SystemDefinitionUtil.TRANSLATOR_VARIABLE_NAME_TAG);
            if (attr != null) {
                variable.setName(attr);
            }
            if ((attr = this.readAttributeFromChildElement(element, SystemDefinitionUtil.TRANSLATOR_VARIABLE_VALUE_TAG)) != null) {
                variable.setValue(attr);
            }
            if ((attr = this.readAttributeFromChildElement(element, SystemDefinitionUtil.TRANSLATOR_VARIABLE_TYPE_TAG)) != null) {
                if (attr.equals("predefined")) {
                    variable.setType(0);
                } else {
                    variable.setType(1);
                }
            }
        }
        return variable;
    }

    private IHFSOutput readOutput(Node node) {
        HFSOutput output = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            output = new HFSOutput();
            String attr = this.readAttributeFromChildElement(element, SystemDefinitionUtil.TRANSLATOR_OUTPUT_PATH_TAG);
            if (attr != null) {
                output.setPath(attr);
            }
            if ((attr = this.readAttributeFromChildElement(element, SystemDefinitionUtil.TRANSLATOR_OUTPUT_CONDITION_TAG)) != null) {
                output.setCondition(attr);
            }
            if ((attr = this.readAttributeFromChildElement(element, SystemDefinitionUtil.TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG)) != null) {
                output.setDeployType(attr);
            }
        }
        return output;
    }
}

