/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractSystemDefinitionParser
implements ISystemDefinitionParser {
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    protected static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    @Override
    public ISystemDefinition parse(String xmlContent) throws TeamRepositoryException {
        ISystemDefinition systemDefinition = this.newSystemDefinition();
        try {
            Document doc = this.newDocument(xmlContent);
            Element rdfElement = this.parseRDF(doc);
            Element rdfDescriptionElement = this.parseRDFDescription(rdfElement);
            this.parseSystemDefinition(rdfDescriptionElement, systemDefinition);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return systemDefinition;
    }

    protected abstract ISystemDefinition newSystemDefinition();

    protected Element parseRDF(Document document) {
        NodeList rdfElements = document.getElementsByTagNameNS(SystemDefinitionUtil.RDF_RDF_TAG.getNamespace(), SystemDefinitionUtil.RDF_RDF_TAG.getTagName());
        if (rdfElements.getLength() > 0) {
            return (Element)rdfElements.item(0);
        }
        return null;
    }

    protected Element parseRDFDescription(Element rdfElement) {
        NodeList rdfDescriptionElements = rdfElement.getElementsByTagNameNS(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getNamespace(), SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getTagName());
        if (rdfDescriptionElements.getLength() > 0) {
            return (Element)rdfDescriptionElements.item(0);
        }
        return null;
    }

    protected void parseSystemDefinition(Element rdfDescriptionElement, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        Element propertiesElement;
        NodeList nodeList2;
        NodeList nodeList;
        String attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_NAME_TAG);
        if (attr != null) {
            systemDefinition.setName(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_UUID_TAG)) != null) {
            systemDefinition.setUuid(attr);
            systemDefinition.setIsNew(false);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_STATE_UUID_TAG)) != null) {
            systemDefinition.setStateId(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_DESCRIPTION_TAG)) != null) {
            systemDefinition.setDescription(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_PROJECT_AREA_UUID_TAG)) != null) {
            systemDefinition.setProjectAreaUuid(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_ARCHIVED_TAG)) != null) {
            systemDefinition.setArchived(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_MIGRATED_TAG)) != null) {
            systemDefinition.setMigrated(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG)) != null) {
            systemDefinition.setNonImpacting(Boolean.parseBoolean(attr));
        }
        if ((nodeList = rdfDescriptionElement.getElementsByTagNameNS(SystemDefinitionUtil.SYSTEM_DEF_PROPERTIES_TAG.getNamespace(), SystemDefinitionUtil.SYSTEM_DEF_PROPERTIES_TAG.getTagName())) != null && nodeList.getLength() > 0 && (nodeList2 = (propertiesElement = (Element)nodeList.item(0)).getElementsByTagNameNS(SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_TAG.getNamespace(), SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_TAG.getTagName())) != null && nodeList2.getLength() > 0) {
            int i = 0;
            while (i < nodeList2.getLength()) {
                Element propertyElement = (Element)nodeList2.item(i);
                String name = this.readAttributeFromChildElement(propertyElement, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_NAME_TAG);
                String value = this.readAttributeFromChildElement(propertyElement, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_VALUE_TAG);
                if (name != null && value != null) {
                    systemDefinition.getProperties().put(name, value);
                }
                ++i;
            }
        }
    }

    protected String readAttributeFromChildElement(Element element, TagWithNS tag) {
        String attribute = null;
        NodeList nodeList = element.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList != null && nodeList.getLength() > 0 && (attribute = nodeList.item(0).getTextContent()) != null) {
            attribute = attribute.intern();
        }
        return attribute;
    }

    protected String[] readAttributesFromChildElement(Element element, TagWithNS tag) {
        ArrayList<String> attributes = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String attribute = nodeList.item(i).getTextContent();
                if (attribute != null) {
                    attribute = attribute.intern();
                    attributes.add(attribute);
                }
                ++i;
            }
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    @Override
    public String convertToXml(ISystemDefinition systemDefinition) throws TeamRepositoryException {
        try {
            Document doc = this.newDocument();
            Element rdfElement = this.convertToRdfElement(doc, systemDefinition);
            Element rdfDescriptionElement = this.convertToRdfDescriptionElement(rdfElement, doc, systemDefinition);
            this.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
            return this.transformToString(doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public String convertToXml(com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        try {
            Document doc = this.newDocument();
            Element rdfElement = this.convertToRdfElement(doc, systemDefinition);
            Element rdfDescriptionElement = this.convertToRdfDescriptionElement(rdfElement, doc, systemDefinition);
            this.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
            return this.transformToString(doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = doc.createElementNS(SystemDefinitionUtil.RDF_RDF_TAG.getNamespace(), SystemDefinitionUtil.RDF_RDF_TAG.getTagName());
        rdfElement.setPrefix(SystemDefinitionUtil.RDF_RDF_TAG.getPrefix());
        doc.appendChild(rdfElement);
        Attr attrRdf = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.RDF_NAMESPACE.getPrefix()).toString());
        attrRdf.setValue(SystemDefinitionUtil.RDF_NAMESPACE.getNamespace());
        Attr attr = rdfElement.setAttributeNode(attrRdf);
        if (attr == null) {
            Attr attrSystemDefinition = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getPrefix()).toString());
            attrSystemDefinition.setValue(SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace());
            attr = rdfElement.setAttributeNode(attrSystemDefinition);
        }
        return rdfElement;
    }

    protected Element convertToRdfElement(Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) {
        Element rdfElement = doc.createElementNS(SystemDefinitionUtil.RDF_RDF_TAG.getNamespace(), SystemDefinitionUtil.RDF_RDF_TAG.getTagName());
        rdfElement.setPrefix(SystemDefinitionUtil.RDF_RDF_TAG.getPrefix());
        doc.appendChild(rdfElement);
        Attr attrRdf = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.RDF_NAMESPACE.getPrefix()).toString());
        attrRdf.setValue(SystemDefinitionUtil.RDF_NAMESPACE.getNamespace());
        Attr attr = rdfElement.setAttributeNode(attrRdf);
        if (attr == null) {
            Attr attrSystemDefinition = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getPrefix()).toString());
            attrSystemDefinition.setValue(SystemDefinitionUtil.SYSTEMDEFINITION_NAMESPACE.getNamespace());
            attr = rdfElement.setAttributeNode(attrSystemDefinition);
        }
        return rdfElement;
    }

    protected Element convertToRdfDescriptionElement(Element rdfElement, Document doc, ISystemDefinition systemDefinition) {
        Element rdfDescriptionElement = doc.createElementNS(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getNamespace(), SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getTagName());
        rdfDescriptionElement.setPrefix(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getPrefix());
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.RDF_ABOUT_TAG.getNamespace(), SystemDefinitionUtil.RDF_ABOUT_TAG.getTagName());
        attr.setPrefix(SystemDefinitionUtil.RDF_ABOUT_TAG.getPrefix());
        String uri = SystemDefinitionUtil.createSystemDefinitionSlug(systemDefinition);
        attr.setValue(uri);
        attr = rdfDescriptionElement.setAttributeNodeNS(attr);
        rdfElement.appendChild(rdfDescriptionElement);
        return rdfDescriptionElement;
    }

    protected Element convertToRdfDescriptionElement(Element rdfElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) {
        Element rdfDescriptionElement = doc.createElementNS(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getNamespace(), SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getTagName());
        rdfDescriptionElement.setPrefix(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getPrefix());
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.RDF_ABOUT_TAG.getNamespace(), SystemDefinitionUtil.RDF_ABOUT_TAG.getTagName());
        attr.setPrefix(SystemDefinitionUtil.RDF_ABOUT_TAG.getPrefix());
        String uri = SystemDefinitionUtil.createSystemDefinitionSlug(systemDefinition);
        attr.setValue(uri);
        attr = rdfDescriptionElement.setAttributeNodeNS(attr);
        rdfElement.appendChild(rdfDescriptionElement);
        return rdfDescriptionElement;
    }

    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_NAME_TAG, systemDefinition.getName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_UUID_TAG, systemDefinition.getUuid());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_DESCRIPTION_TAG, systemDefinition.getDescription());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROJECT_AREA_UUID_TAG, systemDefinition.getProjectAreaUuid());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_TYPE_TAG, systemDefinition.getType());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PLATFORM_TAG, systemDefinition.getPlatform());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_ARCHIVED_TAG, Boolean.toString(systemDefinition.isArchived()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_MIGRATED_TAG, Boolean.toString(systemDefinition.isMigrated()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG, Boolean.toString(systemDefinition.isNonImpacting()));
        if (systemDefinition.getProperties().size() > 0) {
            Element propertiesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTIES_TAG);
            for (String name : systemDefinition.getProperties().keySet()) {
                String value = systemDefinition.getProperties().get(name);
                Element propertyElement = this.createPropertyElementNS(propertiesElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_TAG, null);
                this.createPropertyElementNS(propertyElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_NAME_TAG, name);
                this.createPropertyElementNS(propertyElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_VALUE_TAG, value);
            }
        }
    }

    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_NAME_TAG, systemDefinition.getName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_UUID_TAG, systemDefinition.getItemId().getUuidValue());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_DESCRIPTION_TAG, systemDefinition.getDescription());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROJECT_AREA_UUID_TAG, systemDefinition.getProjectArea().getItemId().getUuidValue());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_TYPE_TAG, SystemDefinitionUtil.convertToJFSType(systemDefinition.getItemType()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PLATFORM_TAG, systemDefinition instanceof IZosPlatformObject ? "zos" : "ibmi");
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_ARCHIVED_TAG, Boolean.toString(systemDefinition.isArchived()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG, Boolean.toString(systemDefinition.isNonImpacting()));
        if (systemDefinition.getProperties().size() > 0) {
            Element propertiesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTIES_TAG);
            for (String name : systemDefinition.getProperties().keySet()) {
                String value = systemDefinition.getProperties().get(name);
                Element propertyElement = this.createPropertyElementNS(propertiesElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_TAG, null);
                this.createPropertyElementNS(propertyElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_NAME_TAG, name);
                this.createPropertyElementNS(propertyElement, doc, SystemDefinitionUtil.SYSTEM_DEF_PROPERTY_VALUE_TAG, value);
            }
        }
    }

    protected Element getPropertyElementNS(Document doc, TagWithNS tag, String value) {
        Element element = doc.createElementNS(tag.getNamespace(), tag.getTagName());
        element.setPrefix(tag.getPrefix());
        element.setTextContent(value);
        return element;
    }

    protected Element createPropertyElementNS(Element parentElement, Document doc, TagWithNS tag, String value) {
        Element element = this.getPropertyElementNS(doc, tag, value);
        return (Element)parentElement.appendChild(element);
    }

    protected Element createResourceElementNS(Element parentElement, Document doc, TagWithNS tag) {
        Element element = this.getPropertyElementNS(doc, tag, null);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.RDF_PARSETYPE_TAG.getNamespace(), SystemDefinitionUtil.RDF_PARSETYPE_TAG.getTagName());
        attr.setPrefix(SystemDefinitionUtil.RDF_PARSETYPE_TAG.getPrefix());
        attr.setValue("Resource");
        element.setAttributeNodeNS(attr);
        return (Element)parentElement.appendChild(element);
    }

    protected Element createLiteralElementNS(Element parentElement, Document doc, TagWithNS tag) {
        Element element = this.getPropertyElementNS(doc, tag, null);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.RDF_PARSETYPE_TAG.getNamespace(), SystemDefinitionUtil.RDF_PARSETYPE_TAG.getTagName());
        attr.setPrefix(SystemDefinitionUtil.RDF_PARSETYPE_TAG.getPrefix());
        attr.setValue("Literal");
        element.setAttributeNodeNS(attr);
        return (Element)parentElement.appendChild(element);
    }

    protected Document newDocument() throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException {
        return this.newDocument(null);
    }

    protected Document newDocument(String xmlContent) throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        if (xmlContent == null) {
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        return documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xmlContent.getBytes(UTF_8)));
    }

    private String transformToString(Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        try {
            String content;
            StreamResult result = new StreamResult(outputStream);
            DOMSource source = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty(INDENT_AMOUNT, THREE);
            transformer.transform(source, result);
            String string = content = outputStream.toString(UTF_8);
            return string;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean canParseToInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected Element getDirectElementByTagNameNS(Element parentElement, TagWithNS tagWithNS) {
        String namespaceURI = tagWithNS.getNamespace();
        String localName = tagWithNS.getTagName();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNamespaceURI().equals(namespaceURI) && child.getLocalName().equals(localName)) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }
}

