/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractSystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractSearchPathParser
extends AbstractSystemDefinitionParser {
    @Override
    protected ISystemDefinition newSystemDefinition() {
        return this.newSearchPath();
    }

    protected abstract ISearchPath newSearchPath();

    @Override
    protected void parseSystemDefinition(Element rdfDescriptionElement, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.parseSystemDefinition(rdfDescriptionElement, systemDefinition);
        this.parseSearchPath(rdfDescriptionElement, (ISearchPath)systemDefinition);
    }

    protected void parseSearchPath(Element rdfDescriptionElement, ISearchPath searchPath) {
        String[] attrs = this.readAttributesFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.SEARCH_PATH_PATH_ENTRY_TAG);
        if (attrs != null) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                searchPath.getPath().add(attr);
                ++n2;
            }
        }
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.SEARCHPATH_NAMESPACE.getPrefix()).toString());
        attr.setValue(SystemDefinitionUtil.SEARCHPATH_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        ISearchPath searchPath = (ISearchPath)systemDefinition;
        Element searchPathElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SEARCH_PATH_PATH_TAG);
        List<String> addPath = searchPath.getPath();
        if (addPath != null && addPath.size() > 0) {
            for (String p : addPath) {
                this.createPropertyElementNS(searchPathElement, doc, SystemDefinitionUtil.SEARCH_PATH_PATH_ENTRY_TAG, p);
            }
        }
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath searchPath = (com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath)systemDefinition;
        Element searchPathElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.SEARCH_PATH_PATH_TAG);
        List<IStringHelper> addPath = searchPath.getPath();
        if (addPath != null && addPath.size() > 0) {
            for (IStringHelper p : addPath) {
                this.createPropertyElementNS(searchPathElement, doc, SystemDefinitionUtil.SEARCH_PATH_PATH_ENTRY_TAG, p.getValue());
            }
        }
    }
}

