/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractSystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractResourceDefinitionParser
extends AbstractSystemDefinitionParser {
    @Override
    protected ISystemDefinition newSystemDefinition() {
        return this.newResourceDefinition();
    }

    protected abstract IResourceDefinition newResourceDefinition();

    @Override
    protected void parseSystemDefinition(Element rdfDescriptionElement, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.parseSystemDefinition(rdfDescriptionElement, systemDefinition);
        this.parseResourceDefinition(rdfDescriptionElement, (IResourceDefinition)systemDefinition);
    }

    protected void parseResourceDefinition(Element rdfDescriptionElement, IResourceDefinition resourceDefinition) {
        String resourceName = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.RESOURCE_DEF_RESOURCE_NAME_TAG);
        if (resourceName != null) {
            resourceDefinition.setResourceName(resourceName);
        }
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.RESOURCEDEFINITION_NAMESPACE.getPrefix()).toString());
        attr.setValue(SystemDefinitionUtil.RESOURCEDEFINITION_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        IResourceDefinition resourceDefinition = (IResourceDefinition)systemDefinition;
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.RESOURCE_DEF_RESOURCE_NAME_TAG, resourceDefinition.getResourceName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.RESOURCE_DEF_USAGE_TYPE_TAG, Integer.toString(resourceDefinition.getUsageType()));
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition resourceDefinition = (com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition)systemDefinition;
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.RESOURCE_DEF_RESOURCE_NAME_TAG, resourceDefinition.getResourceName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.RESOURCE_DEF_USAGE_TYPE_TAG, Integer.toString(resourceDefinition.getUsageType()));
    }
}

