/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageExtensionParser;
import com.ibm.team.enterprise.systemdefinition.common.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.SystemDefinitionFactory;
import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemLanguage;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractSystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.parsers.ExtensionParserFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractLanguageDefinitionParser
extends AbstractSystemDefinitionParser
implements ISystemDefinitionParser {
    private static String LEVEL_ALL = "all";
    private static String LEVEL_NONE = "none";
    private static String LEVEL_PARTIAL = "some";

    @Override
    protected final ISystemDefinition newSystemDefinition() {
        return this.newLanguageDefinition();
    }

    protected abstract ILanguageDefinition newLanguageDefinition();

    @Override
    protected void parseSystemDefinition(Element rdfDescriptionElement, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.parseSystemDefinition(rdfDescriptionElement, systemDefinition);
        this.parseLanguageDefinition(rdfDescriptionElement, (ILanguageDefinition)systemDefinition);
    }

    protected void parseLanguageDefinition(Element rdfDescriptionElement, ILanguageDefinition languageDefinition) throws TeamRepositoryException {
        Element translatorsElement;
        Element scopedPropertiesElement;
        String[] attrs;
        String attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG);
        if (attr != null) {
            languageDefinition.setLanguageCode(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG)) != null) {
            languageDefinition.setDefaultPatterns(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_CALCULATE_IMPACTS_TAG)) != null && !attr.trim().isEmpty()) {
            languageDefinition.setCalculateImpacts(Boolean.parseBoolean(attr));
        } else {
            languageDefinition.setCalculateImpacts(true);
        }
        attr = this.readAttributeFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG);
        if (attr != null && !attr.trim().isEmpty()) {
            languageDefinition.setConsolidateLogs(Boolean.parseBoolean(attr));
        }
        if ((attrs = this.readAttributesFromChildElement(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_SCANNER_TAG)) != null) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                languageDefinition.getSourceCodeDataScanners().add(s);
                ++n2;
            }
        }
        if ((scopedPropertiesElement = this.getDirectElementByTagNameNS(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTIES_TAG)) != null) {
            this.readLanguageDefinitionScopedPropertiesXML(scopedPropertiesElement, languageDefinition.getScopedProperties());
        }
        if ((translatorsElement = this.getDirectElementByTagNameNS(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG)) != null) {
            this.readLanguageDefinitionTranslatorsXml(translatorsElement, languageDefinition.getTranslators());
        }
        this.readLanguageDefinitionDependencyTypesXml(rdfDescriptionElement, languageDefinition);
        Element languageExtensionsElement = this.getDirectElementByTagNameNS(rdfDescriptionElement, SystemDefinitionUtil.LANGUAGE_DEF_EXTENSIONS_TAG);
        if (languageExtensionsElement != null) {
            this.readLanguageDefinitionExtensionsXml(languageExtensionsElement, languageDefinition);
        }
    }

    protected void readLanguageDefinitionDependencyTypesXml(Element rdfDescriptionElement, ILanguageDefinition languageDefinition) {
        Element dependenciesElement;
        NodeList dependencyList;
        Node dependenciesNode;
        TagWithNS tag = SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPES_TAG;
        NodeList nodeList = rdfDescriptionElement.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList != null && nodeList.getLength() > 0 && (dependenciesNode = nodeList.item(0)) instanceof Element && (dependencyList = (dependenciesElement = (Element)dependenciesNode).getElementsByTagNameNS((tag = SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_TAG).getNamespace(), tag.getTagName())) != null && dependencyList.getLength() > 0) {
            int i = 0;
            while (i < dependencyList.getLength()) {
                Node dependencyNode = dependencyList.item(i);
                if (dependencyNode instanceof Element) {
                    Element dependencyElement = (Element)dependencyNode;
                    String name = this.readAttributeFromChildElement(dependencyElement, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG);
                    String level = this.readAttributeFromChildElement(dependencyElement, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG);
                    if (name != null && level != null) {
                        IDependencyType t = SystemDefinitionFactory.createDependencyType();
                        t.setName(name);
                        if (level.equals(LEVEL_NONE)) {
                            t.setLevel(1);
                        } else if (level.equals(LEVEL_PARTIAL)) {
                            t.setLevel(2);
                            Element translatorsElement = this.getDirectElementByTagNameNS(dependencyElement, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG);
                            if (translatorsElement != null) {
                                this.readLanguageDefinitionTranslatorsXml(translatorsElement, t.getTranslators());
                            }
                        } else {
                            t.setLevel(0);
                        }
                        languageDefinition.getDependencyTypes().add(t);
                    }
                }
                ++i;
            }
        }
    }

    protected void readLanguageDefinitionScopedPropertiesXML(Element scopedPropertiesElement, List<IScopedProperty> scopedProperties) {
        NodeList propList = scopedPropertiesElement.getElementsByTagNameNS(SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTY_TAG.getNamespace(), SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTY_TAG.getTagName());
        if (propList == null) {
            return;
        }
        int i = 0;
        while (i < propList.getLength()) {
            Node propNode = propList.item(i);
            if (propNode instanceof Element) {
                Element prop = (Element)propNode;
                String name = this.readAttributeFromChildElement(prop, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG);
                String value = this.readAttributeFromChildElement(prop, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG);
                String condition = null;
                try {
                    condition = this.readAttributeFromChildElement(prop, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (name != null && value != null) {
                    IScopedProperty sProp = SystemDefinitionFactory.createScopedProperty();
                    sProp.setName(name);
                    sProp.setValue(value);
                    if (condition != null) {
                        sProp.setCondition(condition);
                    }
                    scopedProperties.add(sProp);
                }
            }
            ++i;
        }
    }

    protected void readLanguageDefinitionTranslatorsXml(Element translatorsElement, List<ITranslatorEntry> translators) {
        TagWithNS tag = SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TAG;
        NodeList translatorList = translatorsElement.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (translatorList != null && translatorList.getLength() > 0) {
            int i = 0;
            while (i < translatorList.getLength()) {
                Node translatorNode = translatorList.item(i);
                if (translatorNode instanceof Element) {
                    Element translator = (Element)translatorNode;
                    String type = this.readAttributeFromChildElement(translator, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TYPE_TAG);
                    String value = this.readAttributeFromChildElement(translator, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG);
                    String condition = null;
                    String stepname = null;
                    try {
                        condition = this.readAttributeFromChildElement(translator, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG);
                        stepname = this.readAttributeFromChildElement(translator, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (type != null && value != null) {
                        ITranslatorEntry t = SystemDefinitionFactory.createTranslatorEntry();
                        t.setKind(type);
                        t.setValue(value);
                        t.setCondition(condition);
                        t.setStepName(stepname);
                        translators.add(t);
                    }
                }
                ++i;
            }
        }
    }

    protected void readLanguageDefinitionExtensionsXml(Element rdfDescriptionElement, ILanguageDefinition languageDefinition) throws TeamRepositoryException {
        NodeList languageExtenstionNodes = rdfDescriptionElement.getChildNodes();
        if (languageExtenstionNodes != null && languageExtenstionNodes.getLength() > 0) {
            int i = 0;
            while (i < languageExtenstionNodes.getLength()) {
                Node languageExtenstionNode = languageExtenstionNodes.item(i);
                if (languageExtenstionNode instanceof Element) {
                    Element languageExtensionElement = (Element)languageExtenstionNode;
                    String type = languageExtensionElement.getLocalName();
                    ISystemDefinitionParser parser = ExtensionParserFactory.getInstance().getSystemDefinitionParser(type, languageDefinition.getPlatform());
                    if (parser != null && parser instanceof ILanguageExtensionParser) {
                        ILanguageExtensionParser extensionParser = (ILanguageExtensionParser)parser;
                        ISystemDefinition languageExtensionDefinition = extensionParser.newLanguageExtension();
                        languageDefinition.getLanguageExtensionMap().put(type, languageExtensionDefinition);
                        extensionParser.parseSystemDefinition(languageExtensionElement, languageExtensionDefinition);
                    } else {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.getCommonString("LanguageDefinitionError.8"), (Object)languageDefinition.getName(), (Object)type));
                    }
                }
                ++i;
            }
        }
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.LANGUAGEDEFINITION_NAMESPACE.getPrefix()).toString());
        attr.setValue(SystemDefinitionUtil.LANGUAGEDEFINITION_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        ILanguageDefinition languageDefinition = (ILanguageDefinition)systemDefinition;
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG, languageDefinition.getLanguageCode());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG, languageDefinition.getDefaultPatterns());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_CALCULATE_IMPACTS_TAG, Boolean.toString(languageDefinition.isCalculateImpacts()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG, Boolean.toString(languageDefinition.isConsolidateLogs()));
        Element scannersElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCANNERS_TAG);
        List<String> scanners = languageDefinition.getSourceCodeDataScanners();
        if (scanners != null && scanners.size() > 0) {
            for (String s : scanners) {
                this.createPropertyElementNS(scannersElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCANNER_TAG, s);
            }
        }
        Element dependencyTypesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPES_TAG);
        List<IDependencyType> types = languageDefinition.getDependencyTypes();
        if (types != null && types.size() > 0) {
            for (IDependencyType t : types) {
                Element dependencyTypeElement = this.createPropertyElementNS(dependencyTypesElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_TAG, null);
                this.createPropertyElementNS(dependencyTypeElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG, t.getName());
                Object level = LEVEL_ALL;
                switch (t.getLevel()) {
                    case 1: {
                        level = LEVEL_NONE;
                        break;
                    }
                    case 2: {
                        level = LEVEL_PARTIAL;
                    }
                }
                this.createPropertyElementNS(dependencyTypeElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG, (String)level);
                if (t.getLevel() != 2) continue;
                this.createLanguageDefinitionTranslatorsElement(dependencyTypeElement, doc, t.getTranslators(), true);
            }
        }
        Element scopedPropertiesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTIES_TAG);
        List<IScopedProperty> scopedProps = languageDefinition.getScopedProperties();
        if (scopedProps != null && !scopedProps.isEmpty()) {
            for (IScopedProperty s : scopedProps) {
                Element property = this.createPropertyElementNS(scopedPropertiesElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTY_TAG, null);
                this.createPropertyElementNS(property, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG, s.getName());
                this.createPropertyElementNS(property, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG, s.getValue());
                if (s.getCondition() == null || s.getCondition().trim().isEmpty()) continue;
                this.createPropertyElementNS(property, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG, s.getCondition());
            }
        }
        this.createLanguageDefinitionTranslatorsElement(rdfDescriptionElement, doc, languageDefinition.getTranslators(), false);
        Element languageExtensionsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_EXTENSIONS_TAG);
        Element languageExtensionQueriesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_EXTENSIONQUERIES_TAG);
        if (languageDefinition.getLanguageExtensionMap() != null && !languageDefinition.getLanguageExtensionMap().isEmpty()) {
            for (String type : languageDefinition.getLanguageExtensionMap().keySet()) {
                ISystemDefinitionParser parser = ExtensionParserFactory.getInstance().getSystemDefinitionParser(type, languageDefinition.getPlatform());
                if (parser != null && parser instanceof ILanguageExtensionParser) {
                    ILanguageExtensionParser extensionParser = (ILanguageExtensionParser)parser;
                    Element languageExtensionElement = extensionParser.createLanguageExtensionElement(languageExtensionsElement, doc);
                    extensionParser.convertToSystemDefinitionXml(languageExtensionElement, doc, languageDefinition.getLanguageExtensionMap().get(type));
                    extensionParser.convertQueriesToSystemDefinitionXml(languageExtensionQueriesElement, doc, languageDefinition.getLanguageExtensionMap().get(type));
                    continue;
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.getCommonString("LanguageDefinitionError.8"), (Object)languageDefinition.getName(), (Object)type));
            }
        }
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        IZosLanguageDefinition zosLanguage;
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition languageDefinition = (com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition)systemDefinition;
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG, languageDefinition.getLanguageCode());
        StringBuilder strb = new StringBuilder();
        List<IStringHelper> patterns = languageDefinition.getDefaultPatterns();
        for (IStringHelper helper : patterns) {
            if (strb.length() > 0) {
                strb.append(",");
            }
            strb.append(helper.getValue());
        }
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG, strb.toString());
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_CALCULATE_IMPACTS_TAG, Boolean.toString(languageDefinition.isCalculateImpacts()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG, Boolean.toString(languageDefinition.isConsolidateLogs()));
        Element scannersElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCANNERS_TAG);
        List<IStringHelper> scanners = languageDefinition.getSourceCodeDataScanners();
        if (scanners != null && scanners.size() > 0) {
            for (IStringHelper s : scanners) {
                this.createPropertyElementNS(scannersElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCANNER_TAG, s.getValue());
            }
        }
        Element dependencyTypesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPES_TAG);
        List<com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType> types = languageDefinition.getDependencyTypes();
        if (types != null && types.size() > 0) {
            for (com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType t : types) {
                Element dependencyTypeElement = this.createPropertyElementNS(dependencyTypesElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_TAG, null);
                this.createPropertyElementNS(dependencyTypeElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG, t.getName());
                Object level = LEVEL_ALL;
                switch (t.getLevel()) {
                    case 1: {
                        level = LEVEL_NONE;
                        break;
                    }
                    case 2: {
                        level = LEVEL_PARTIAL;
                    }
                }
                this.createPropertyElementNS(dependencyTypeElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG, (String)level);
                if (t.getLevel() != 2) continue;
                this.createLanguageDefinitionModelTranslatorsElement(dependencyTypeElement, doc, t.getTranslators(), true);
            }
        }
        Element scopedPropertiesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTIES_TAG);
        List<com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty> scopedProps = languageDefinition.getScopedProperties();
        if (scopedProps != null && !scopedProps.isEmpty()) {
            for (com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty s : scopedProps) {
                Element property = this.createPropertyElementNS(scopedPropertiesElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTY_TAG, null);
                this.createPropertyElementNS(property, doc, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_NAME_TAG, s.getName());
                this.createPropertyElementNS(property, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG, s.getValue());
                if (s.getCondition() == null || s.getCondition().trim().isEmpty()) continue;
                this.createPropertyElementNS(property, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG, s.getCondition());
            }
        }
        this.createLanguageDefinitionModelTranslatorsElement(rdfDescriptionElement, doc, languageDefinition.getTranslators(), false);
        if (languageDefinition instanceof IZosLanguageDefinition && (zosLanguage = (IZosLanguageDefinition)languageDefinition).getSmpePackaging() != null) {
            Element languageExtensionsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_EXTENSIONS_TAG);
            Element languageExtensionQueriesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_EXTENSIONQUERIES_TAG);
            ISystemDefinitionParser parser = ExtensionParserFactory.getInstance().getSystemDefinitionParser("languageExtensionSmpe", "zos");
            if (parser != null && parser instanceof ILanguageExtensionParser) {
                ILanguageExtensionParser extensionParser = (ILanguageExtensionParser)parser;
                Element languageExtensionElement = extensionParser.createLanguageExtensionElement(languageExtensionsElement, doc);
                IPackagingItemDefinition smpePackaging = (IPackagingItemDefinition)zosLanguage.getSmpePackaging();
                PackagingItemLanguage packagingItem = new PackagingItemLanguage(smpePackaging);
                extensionParser.convertToSystemDefinitionXml(languageExtensionElement, doc, packagingItem);
                extensionParser.convertQueriesToSystemDefinitionXml(languageExtensionQueriesElement, doc, packagingItem);
            } else {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getCommonString("LanguageDefinitionError.8"), (Object)languageDefinition.getName(), (Object)"languageExtensionSmpe"));
            }
        }
    }

    protected void createLanguageDefinitionTranslatorsElement(Element parentElement, Document doc, List<ITranslatorEntry> translators, boolean includeInDependencyType) {
        Element translatorsElement = includeInDependencyType ? this.createPropertyElementNS(parentElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG, null) : this.createLiteralElementNS(parentElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG);
        if (translators != null && translators.size() > 0) {
            for (ITranslatorEntry t : translators) {
                Element translatorElement = this.createPropertyElementNS(translatorsElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TAG, null);
                this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TYPE_TAG, t.getKind());
                this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG, t.getValue());
                if (t.getCondition() != null) {
                    this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG, t.getCondition());
                }
                if (t.getStepName() == null) continue;
                this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG, t.getStepName());
            }
        }
    }

    protected void createLanguageDefinitionModelTranslatorsElement(Element parentElement, Document doc, List<com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry> translators, boolean includeInDependencyType) {
        Element translatorsElement = includeInDependencyType ? this.createPropertyElementNS(parentElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG, null) : this.createLiteralElementNS(parentElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG);
        if (translators != null && translators.size() > 0) {
            for (com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry t : translators) {
                Element translatorElement = this.createPropertyElementNS(translatorsElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TAG, null);
                this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_TYPE_TAG, t.getKind());
                this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG, t.getValue());
                if (t.getCondition() != null) {
                    this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG, t.getCondition());
                }
                if (t.getStepName() == null) continue;
                this.createPropertyElementNS(translatorElement, doc, SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG, t.getStepName());
            }
        }
    }
}

