/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.packaging;

import com.ibm.team.build.extensions.common.util.FileUtilities;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IVersionable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PackagingItemTools {
    private PackagingItemTools() {
    }

    public static IVersionable findMember(List<IVersionable> fileList, Map<String, IVersionable> folderMap, String member, IDataSetDefinition dataset) {
        IVersionable result = null;
        String mbr = member.toUpperCase();
        for (IVersionable item : fileList) {
            String dsnUuid;
            IVersionable parent;
            if (!item.getName().toUpperCase().startsWith(mbr) || !FileUtilities.toFileName((String)item.getName()).equalsIgnoreCase(mbr) || (parent = folderMap.get(item.getParent().getItemId().getUuidValue())) == null || (dsnUuid = (String)parent.getUserProperties().get("team.enterprise.resource.definition")) == null || !dsnUuid.equals(dataset.getUuid())) continue;
            result = item;
            break;
        }
        return result;
    }

    public static String getPath(Map<String, IVersionable> folderMap, IPackagingItem item) {
        IVersionable current = item.getFileVersionable();
        StringBuilder result = new StringBuilder();
        ArrayList<IVersionable> parts = new ArrayList<IVersionable>();
        do {
            parts.add(current);
        } while ((current = folderMap.get(PackagingItemTools.getUuid((IItemHandle)current.getParent()))) != null);
        Collections.reverse(parts);
        for (IVersionable part : parts) {
            result.append("/");
            result.append(part.getName());
        }
        return result.toString();
    }

    public static String getPath(Map<String, IVersionable> folderMap, IVersionable item) {
        IVersionable current = item;
        StringBuilder result = new StringBuilder();
        ArrayList<IVersionable> parts = new ArrayList<IVersionable>();
        do {
            parts.add(current);
        } while ((current = folderMap.get(PackagingItemTools.getUuid((IItemHandle)current.getParent()))) != null);
        Collections.reverse(parts);
        for (IVersionable part : parts) {
            result.append("/");
            result.append(part.getName());
        }
        return result.toString();
    }

    private static final String getUuid(IItemHandle itemHandle) {
        return itemHandle.getItemId().getUuidValue();
    }
}

