/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.packaging;

import com.ibm.team.build.extensions.common.util.StringParser;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PackagingBinderOptions {
    private static final String OPTION_AC0 = "AC=0";
    private static final String OPTION_AC0_AF = "AC(0)";
    private static final String OPTION_AC1 = "AC=1";
    private static final String OPTION_AC1_AF = "AC(1)";
    private static final String OPTION_ALIASES = "ALIASES=ALL";
    private static final String OPTION_ALIASES_AF = "ALIASES(ALL)";
    private static final String OPTION_ALIGN2 = "ALIGN2";
    private static final String OPTION_AMOD_24 = "AMOD=24";
    private static final String OPTION_AMOD_24_AF = "AMOD(24)";
    private static final String OPTION_AMOD_31 = "AMOD=31";
    private static final String OPTION_AMOD_31_AF = "AMOD(31)";
    private static final String OPTION_AMOD_64 = "AMOD=64";
    private static final String OPTION_AMOD_64_AF = "AMOD(64)";
    private static final String OPTION_AMOD_ANY = "AMOD=ANY";
    private static final String OPTION_AMOD_ANY_AF = "AMOD(ANY)";
    private static final String OPTION_AMOD_MIN = "AMOD=MIN";
    private static final String OPTION_AMOD_MIN_AF = "AMOD(MIN)";
    private static final String OPTION_AMODE_24 = "AMODE=24";
    private static final String OPTION_AMODE_24_AF = "AMODE(24)";
    private static final String OPTION_AMODE_31 = "AMODE=31";
    private static final String OPTION_AMODE_31_AF = "AMODE(31)";
    private static final String OPTION_AMODE_64 = "AMODE=64";
    private static final String OPTION_AMODE_64_AF = "AMODE(64)";
    private static final String OPTION_AMODE_ANY = "AMODE=ANY";
    private static final String OPTION_AMODE_ANY_AF = "AMODE(ANY)";
    private static final String OPTION_AMODE_MIN = "AMODE=MIN";
    private static final String OPTION_AMODE_MIN_AF = "AMODE(MIN)";
    private static final String OPTION_CALL = "CALL";
    private static final String OPTION_CASE_MIXED = "CASE=MIXED";
    private static final String OPTION_CASE_MIXED_AF = "CASE(MIXED)";
    private static final String OPTION_CASE_UPPER = "CASE=UPPER";
    private static final String OPTION_CASE_UPPER_AF = "CASE(UPPER)";
    private static final String OPTION_COMPAT_CURR = "CURR";
    private static final String OPTION_COMPAT_CURRENT = "CURRENT";
    private static final String OPTION_COMPAT_LKED = "COMPAT=LKED";
    private static final String OPTION_COMPAT_LKED_AF = "COMPAT(LKED)";
    private static final String OPTION_COMPAT_PM1 = "COMPAT=PM1";
    private static final String OPTION_COMPAT_PM1_AF = "COMPAT(PM1)";
    private static final String OPTION_COMPAT_PM2 = "COMPAT=PM2";
    private static final String OPTION_COMPAT_PM2_AF = "COMPAT(PM2)";
    private static final String OPTION_COMPAT_PM3 = "COMPAT=PM3";
    private static final String OPTION_COMPAT_PM3_AF = "COMPAT(PM3)";
    private static final String OPTION_COMPAT_PM4 = "COMPAT=PM4";
    private static final String OPTION_COMPAT_PM4_AF = "COMPAT(PM4)";
    private static final String OPTION_DC = "DC";
    private static final String OPTION_DCBS = "DCBS";
    private static final String OPTION_DCBSNO = "NODCBS";
    private static final String OPTION_DCBS_NO = "DCBS=NO";
    private static final String OPTION_DCBS_NO_AF = "DCBS(NO)";
    private static final String OPTION_DYNAM = "DYNAM=DLL";
    private static final String OPTION_DYNAM_AF = "DYNAM(DLL)";
    private static final String OPTION_FETCHOPT_PP = "FETCHOPT(PACK,PRIME)";
    private static final String OPTION_FETCHOPT_NP = "FETCHOPT(NOPACK,PRIME)";
    private static final String OPTION_FETCHOPT_PN = "FETCHOPT(PACK,NOPRIME)";
    private static final String OPTION_FETCHOPT_NN = "FETCHOPT(NOPACK,NOPRIME)";
    private static final String OPTION_FILL = "FILL=";
    private static final String OPTION_FILL_AF = "FILL(";
    private static final String OPTION_HOBSET = "HOBSET";
    private static final String OPTION_LET = "LET";
    private static final String OPTION_LET_0 = "LET=0";
    private static final String OPTION_LET_0_AF = "LET(0)";
    private static final String OPTION_LET_4 = "LET=4";
    private static final String OPTION_LET_4_AF = "LET(4)";
    private static final String OPTION_LET_8 = "LET=8";
    private static final String OPTION_LET_8_AF = "LET(8)";
    private static final String OPTION_LET_12 = "LET=12";
    private static final String OPTION_LET_12_AF = "LET(12)";
    private static final String OPTION_LET_NO = "NOLET";
    private static final String OPTION_LIST = "LIST";
    private static final String OPTION_LIST_NO = "NOLIST";
    private static final String OPTION_LIST_OPT = "LIST=";
    private static final String OPTION_LIST_OPT_AF = "LIST(";
    private static final String OPTION_MAXBLK = "MAXBLK=";
    private static final String OPTION_MAXBLK_AF = "MAXBLK(";
    private static final String OPTION_NE = "NE";
    private static final String OPTION_NOCALL = "NOCALL";
    private static final String OPTION_NCAL = "NCAL";
    private static final String OPTION_OL = "OL";
    private static final String OPTION_OPTIONS = "OPTIONS=";
    private static final String OPTION_OPTIONS_AF = "OPTIONS(";
    private static final String OPTION_OVLY = "OVLY";
    private static final String OPTION_REFR = "REFR";
    private static final String OPTION_RENT = "RENT";
    private static final String OPTION_REUS = "REUS";
    private static final String OPTION_REUS_NONE = "REUS=NONE";
    private static final String OPTION_REUS_NONE_AF = "REUS(NONE)";
    private static final String OPTION_REUS_REFR = "REUS=REFR";
    private static final String OPTION_REUS_REFR_AF = "REUS(REFR)";
    private static final String OPTION_REUS_RENT = "REUS=RENT";
    private static final String OPTION_REUS_RENT_AF = "REUS(RENT)";
    private static final String OPTION_REUS_SERIAL = "REUS=SERIAL";
    private static final String OPTION_REUS_SERIAL_AF = "REUS(SERIAL)";
    private static final String OPTION_RMOD_24 = "RMOD=24";
    private static final String OPTION_RMOD_24_AF = "RMOD(24)";
    private static final String OPTION_RMOD_31 = "RMOD=31";
    private static final String OPTION_RMOD_31_AF = "RMOD(31)";
    private static final String OPTION_RMOD_ANY = "RMOD=ANY";
    private static final String OPTION_RMOD_ANY_AF = "RMOD(ANY)";
    private static final String OPTION_RMOD_SPLIT = "RMOD=SPLIT";
    private static final String OPTION_RMOD_SPLIT_AF = "RMOD(SPLIT)";
    private static final String OPTION_RMODE_24 = "RMODE=24";
    private static final String OPTION_RMODE_24_AF = "RMODE(24)";
    private static final String OPTION_RMODE_31 = "RMODE=31";
    private static final String OPTION_RMODE_31_AF = "RMODE(31)";
    private static final String OPTION_RMODE_ANY = "RMODE=ANY";
    private static final String OPTION_RMODE_ANY_AF = "RMODE(ANY)";
    private static final String OPTION_RMODE_SPLIT = "RMODE=SPLIT";
    private static final String OPTION_RMODE_SPLIT_AF = "RMODE(SPLIT)";
    private static final String OPTION_SCTR = "SCTR";
    private static final String OPTION_UPCASE_YES = "UPCASE=YES";
    private static final String OPTION_UPCASE_YES_AF = "UPCASE(YES)";
    private static final String OPTION_UPCASE_NO = "UPCASE=NO";
    private static final String OPTION_UPCASE_NO_AF = "UPCASE(NO)";
    private static final String OPTION_XCAL = "XCAL";
    private static final String OPTION_XCALNO = "NOXCAL";
    private static final String OPTION_XCAL_NO = "XCAL=NO";
    private static final String OPTION_XCAL_NO_AF = "XCAL(NO)";
    private static final String OPTION_XREF = "XREF";
    private static final String OPTION_XREFNO = "NOXREF";
    private static final String OPTION_XREF_NO = "XREF=NO";
    private static final String OPTION_XREF_NO_AF = "XREF(NO)";
    private static final int FLAG_AC1 = 1;
    private static final int FLAG_ALIASES = 2;
    private static final int FLAG_ALIGN2 = 4;
    private static final int FLAG_AMODE_31 = 8;
    private static final int FLAG_AMODE_64 = 16;
    private static final int FLAG_AMODE_ANY = 32;
    private static final int FLAG_AMODE_MIN = 64;
    private static final int FLAG_CASE = 128;
    private static final int FLAG_COMPAT_LKED = 256;
    private static final int FLAG_COMPAT_PM1 = 512;
    private static final int FLAG_COMPAT_PM2 = 1024;
    private static final int FLAG_COMPAT_PM3 = 2048;
    private static final int FLAG_COMPAT_PM4 = 4096;
    private static final int FLAG_DC = 8192;
    private static final int FLAG_DYNAM = 16384;
    private static final int FLAG_FETCHOPT_PP = 32768;
    private static final int FLAG_FETCHOPT_PN = 65536;
    private static final int FLAG_FETCHOPT_NP = 131072;
    private static final int FLAG_HOBSET = 262144;
    private static final int FLAG_NE = 0x100000;
    private static final int FLAG_NOCALL = 0x100000;
    private static final int FLAG_OL = 0x400000;
    private static final int FLAG_OVLY = 0x800000;
    private static final int FLAG_REUS_SERIAL = 0x1000000;
    private static final int FLAG_REUS_RENT = 0x2000000;
    private static final int FLAG_REUS_REFR = 0x4000000;
    private static final int FLAG_RMODE_31 = 0x8000000;
    private static final int FLAG_RMODE_ANY = 0x10000000;
    private static final int FLAG_RMODE_SPLIT = 0x20000000;
    private static final int FLAG_SCTR = 0x40000000;
    private static final int FLAG_UPCASE = Integer.MIN_VALUE;
    private int flags;
    private final ILanguageDefinition language;
    private final String itemid;
    private final String leparm;
    private String fill;
    private String maxblk;
    private String options;
    private final List<String> binderOptions;

    public PackagingBinderOptions(IPackagingItem item) throws TeamRepositoryException {
        this.language = item.getLanguage();
        this.itemid = item.getLanguage().getItemId().getUuidValue();
        this.leparm = item.getLeparm();
        this.binderOptions = StringParser.parseArguments((String)this.leparm);
        Collections.sort(this.binderOptions);
        Iterator<String> iterator = this.binderOptions.iterator();
        while (iterator.hasNext()) {
            String binderOption;
            switch (binderOption = iterator.next()) {
                case "AC=1": 
                case "AC(1)": {
                    this.flags |= 1;
                    break;
                }
                case "ALIASES=ALL": 
                case "ALIASES(ALL)": {
                    this.flags |= 2;
                    break;
                }
                case "ALIGN2": {
                    this.flags |= 4;
                    break;
                }
                case "AMODE(31)": 
                case "AMOD(31)": 
                case "AMODE=31": 
                case "AMOD=31": {
                    this.flags |= 8;
                    break;
                }
                case "AMODE(64)": 
                case "AMOD(64)": 
                case "AMODE=64": 
                case "AMOD=64": {
                    this.flags |= 0x10;
                    break;
                }
                case "AMOD(ANY)": 
                case "AMODE=ANY": 
                case "AMOD=ANY": 
                case "AMODE(ANY)": {
                    this.flags |= 0x20;
                    break;
                }
                case "AMOD(MIN)": 
                case "AMODE=MIN": 
                case "AMOD=MIN": 
                case "AMODE(MIN)": {
                    this.flags |= 0x40;
                    break;
                }
                case "CASE(MIXED)": 
                case "CASE=MIXED": {
                    this.flags |= 0x80;
                    break;
                }
                case "COMPAT(LKED)": 
                case "COMPAT=LKED": {
                    this.flags |= 0x100;
                    break;
                }
                case "COMPAT=PM1": 
                case "COMPAT(PM1)": {
                    this.flags |= 0x200;
                    break;
                }
                case "COMPAT=PM2": 
                case "COMPAT(PM2)": {
                    this.flags |= 0x400;
                    break;
                }
                case "COMPAT=PM3": 
                case "COMPAT(PM3)": {
                    this.flags |= 0x800;
                    break;
                }
                case "COMPAT=PM4": 
                case "COMPAT(PM4)": {
                    this.flags |= 0x1000;
                    break;
                }
                case "DC": {
                    this.flags |= 0x2000;
                    break;
                }
                case "DYNAM(DLL)": 
                case "DYNAM=DLL": {
                    this.flags |= 0x4000;
                    break;
                }
                case "FETCHOPT(PACK,PRIME)": {
                    this.flags |= 0x8000;
                    break;
                }
                case "FETCHOPT(NOPACK,PRIME)": {
                    this.flags |= 0x20000;
                    break;
                }
                case "FETCHOPT(PACK,NOPRIME)": {
                    this.flags |= 0x10000;
                    break;
                }
                case "HOBSET": {
                    this.flags |= 0x40000;
                    break;
                }
                case "NE": {
                    this.flags |= 0x100000;
                    break;
                }
                case "NOCALL": 
                case "NCAL": {
                    this.flags |= 0x100000;
                    break;
                }
                case "OL": {
                    this.flags |= 0x400000;
                    break;
                }
                case "OVLY": {
                    this.flags |= 0x800000;
                    break;
                }
                case "REUS=REFR": 
                case "REFR": 
                case "REUS(REFR)": {
                    this.flags |= 0x4000000;
                    break;
                }
                case "REUS=RENT": 
                case "RENT": 
                case "REUS(RENT)": {
                    this.flags |= 0x2000000;
                    break;
                }
                case "REUS=SERIAL": 
                case "REUS(SERIAL)": 
                case "REUS": {
                    this.flags |= 0x1000000;
                    break;
                }
                case "RMODE(31)": 
                case "RMOD(31)": 
                case "RMODE=31": 
                case "RMOD=31": {
                    this.flags |= 0x8000000;
                    break;
                }
                case "RMOD(ANY)": 
                case "RMODE=ANY": 
                case "RMOD=ANY": 
                case "RMODE(ANY)": {
                    this.flags |= 0x10000000;
                    break;
                }
                case "RMODE(SPLIT)": 
                case "RMODE=SPLIT": 
                case "RMOD(SPLIT)": 
                case "RMOD=SPLIT": {
                    this.flags |= 0x20000000;
                    break;
                }
                case "SCTR": {
                    this.flags |= 0x40000000;
                    break;
                }
                case "UPCASE(NO)": 
                case "UPCASE=NO": {
                    this.flags |= Integer.MIN_VALUE;
                    break;
                }
                default: {
                    if (!binderOption.startsWith(OPTION_LIST_OPT) && !binderOption.startsWith(OPTION_LIST_OPT_AF)) {
                        if (binderOption.startsWith(OPTION_FILL) || binderOption.startsWith(OPTION_FILL_AF)) {
                            this.fill = StringParser.parseArgument((String)binderOption);
                        } else if (binderOption.startsWith(OPTION_MAXBLK) || binderOption.startsWith(OPTION_MAXBLK_AF)) {
                            this.maxblk = StringParser.parseArgument((String)binderOption);
                        } else if (binderOption.startsWith(OPTION_OPTIONS) || binderOption.startsWith(OPTION_OPTIONS_AF)) {
                            this.options = StringParser.parseArgument((String)binderOption);
                        }
                    }
                    throw new TeamRepositoryException(NLS.bind((String)Messages.PKG_BINDER_OPTIONS_UNKNOWN, (Object)binderOption, (Object[])new Object[0]));
                }
                case "DCBS=NO": 
                case "LET(0)": 
                case "LET(4)": 
                case "LET(8)": 
                case "LET=12": 
                case "RMODE(24)": 
                case "NODCBS": 
                case "NOLIST": 
                case "NOXCAL": 
                case "NOXREF": 
                case "UPCASE(YES)": 
                case "REUS=NONE": 
                case "UPCASE=YES": 
                case "XCAL=NO": 
                case "AMODE(24)": 
                case "RMOD(24)": 
                case "RMODE=24": 
                case "XREF=NO": 
                case "AMOD(24)": 
                case "AMODE=24": 
                case "DCBS(NO)": 
                case "CASE(UPPER)": 
                case "CASE=UPPER": 
                case "AMOD=24": 
                case "LET": 
                case "AC=0": 
                case "CALL": 
                case "CURR": 
                case "DCBS": 
                case "LIST": 
                case "XCAL": 
                case "XREF": 
                case "XCAL(NO)": 
                case "AC(0)": 
                case "LET=0": 
                case "LET=4": 
                case "LET=8": 
                case "NOLET": 
                case "XREF(NO)": 
                case "REUS(NONE)": 
                case "LET(12)": 
                case "FETCHOPT(NOPACK,NOPRIME)": 
                case "CURRENT": 
                case "RMOD=24": 
            }
        }
    }

    public final boolean equal(PackagingBinderOptions other) {
        return this.getFlags() == other.getFlags() && this.getItemid().equals(other.getItemid()) && (this.getFill() == null && other.getFill() == null || this.getFill().equals(other.getFill())) && (this.getMaxblk() == null && other.getMaxblk() == null || this.getMaxblk().equals(other.getMaxblk())) && (this.getOptions() == null && other.getOptions() == null || this.getOptions().equals(other.getOptions()));
    }

    public final String getBinderParm() {
        StringBuilder result = new StringBuilder();
        String separator = "";
        Iterator<String> iterator = this.binderOptions.iterator();
        while (iterator.hasNext()) {
            String binderOption;
            switch (binderOption = iterator.next()) {
                case "REUS=NONE": 
                case "REUS(NONE)": {
                    binderOption = OPTION_REUS_NONE_AF;
                    break;
                }
                case "REUS=REFR": 
                case "REFR": 
                case "REUS(REFR)": {
                    binderOption = OPTION_REUS_REFR_AF;
                    break;
                }
                case "REUS=RENT": 
                case "RENT": 
                case "REUS(RENT)": {
                    binderOption = OPTION_REUS_RENT_AF;
                    break;
                }
                case "REUS=SERIAL": 
                case "REUS(SERIAL)": 
                case "REUS": {
                    binderOption = OPTION_REUS_SERIAL_AF;
                }
            }
            result.append(separator);
            result.append(binderOption);
            separator = ",";
        }
        return result.toString();
    }

    public final List<String> getBinderOptions() {
        return this.binderOptions;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final String getItemid() {
        return this.itemid;
    }

    public final ILanguageDefinition getLanguage() {
        return this.language;
    }

    public final String getLeparm() {
        return this.leparm;
    }

    public final String getFill() {
        return this.fill;
    }

    public final void setFill(String fill) {
        this.fill = fill;
    }

    public final String getMaxblk() {
        return this.maxblk;
    }

    public final void setMaxblk(String maxblk) {
        this.maxblk = maxblk;
    }

    public final String getOptions() {
        return this.options;
    }

    public final void setOptions(String options) {
        this.options = options;
    }
}

