/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.model.mapper;

import com.ibm.team.enterprise.common.common.EnterpriseLog;
import com.ibm.team.enterprise.systemdefinition.common.model.mapper.ISystemDefinitionModelMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SystemDefinitionModelMapperRegistry {
    private static final EnterpriseLog logger = new EnterpriseLog(SystemDefinitionModelMapperRegistry.class);
    private static final String MODEL_MAPPERS_EXTENSIONPOINT_ID = "com.ibm.team.enterprise.systemdefinition.model.mappers";
    private static SystemDefinitionModelMapperRegistry INSTANCE;
    private final Map<String, TypeMappersMap> registeredMappers = new HashMap<String, TypeMappersMap>();

    public static SystemDefinitionModelMapperRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemDefinitionModelMapperRegistry();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    private SystemDefinitionModelMapperRegistry() {
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.getSystemDefinitionMapperExtensions(registry);
    }

    private void getSystemDefinitionMapperExtensions(IExtensionRegistry registry) {
        IExtensionPoint extensionPoint = registry.getExtensionPoint(MODEL_MAPPERS_EXTENSIONPOINT_ID);
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("mapper")) {
                String type = element.getAttribute("type");
                String platform = element.getAttribute("platform");
                ISystemDefinitionModelMapper mapper = this.createSystemDefinitionMapper(element);
                if (type != null && !type.equals("")) {
                    TypeMappersMap typesPairs = this.registeredMappers.get(type);
                    if (typesPairs == null) {
                        typesPairs = new TypeMappersMap();
                        this.registeredMappers.put(type, typesPairs);
                    }
                    typesPairs.addPair(new PlatformMapperPair(platform, mapper));
                }
            }
            ++i;
        }
    }

    private ISystemDefinitionModelMapper createSystemDefinitionMapper(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension("class");
            if (object instanceof ISystemDefinitionModelMapper) {
                return (ISystemDefinitionModelMapper)object;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public List<ISystemDefinitionModelMapper> getRegisteredMappers() {
        Collection<TypeMappersMap> definedByPtf = this.registeredMappers.values();
        ArrayList<ISystemDefinitionModelMapper> registeredMappersList = new ArrayList<ISystemDefinitionModelMapper>();
        if (definedByPtf != null) {
            for (TypeMappersMap mapByPtf : definedByPtf) {
                List<PlatformMapperPair> ptfpairs = mapByPtf.pairs;
                for (PlatformMapperPair ptfpair : ptfpairs) {
                    registeredMappersList.add(ptfpair.mapper);
                }
            }
        }
        return Collections.unmodifiableList(registeredMappersList);
    }

    public List<ISystemDefinitionModelMapper> getMapperForType(String type) {
        TypeMappersMap mappedTypes = this.registeredMappers.get(type);
        ArrayList<ISystemDefinitionModelMapper> registeredMappersList = new ArrayList<ISystemDefinitionModelMapper>();
        if (mappedTypes != null) {
            for (PlatformMapperPair pair : mappedTypes.pairs) {
                if (pair.mapper == null) continue;
                registeredMappersList.add(pair.mapper);
            }
        }
        return Collections.unmodifiableList(registeredMappersList);
    }

    public ISystemDefinitionModelMapper getMapperForTypePlatform(String type, String platform) {
        TypeMappersMap mappedType = this.registeredMappers.get(type);
        if (mappedType != null) {
            return mappedType.getMapper(platform);
        }
        return null;
    }

    class PlatformMapperPair {
        protected String platform;
        protected ISystemDefinitionModelMapper mapper;

        public PlatformMapperPair(String platform, ISystemDefinitionModelMapper mapper) {
            this.platform = platform;
            this.mapper = mapper;
        }
    }

    class TypeMappersMap {
        List<PlatformMapperPair> pairs = new ArrayList<PlatformMapperPair>();

        public void addPair(PlatformMapperPair aPair) {
            Iterator<PlatformMapperPair> it = this.pairs.iterator();
            while (it.hasNext()) {
                PlatformMapperPair pair = it.next();
                if (!pair.platform.equals(aPair.platform)) continue;
                it.remove();
                break;
            }
            this.pairs.add(aPair);
        }

        public ISystemDefinitionModelMapper getMapper(String platform) {
            for (PlatformMapperPair pair : this.pairs) {
                if (!pair.platform.equals(platform)) continue;
                return pair.mapper;
            }
            return null;
        }

        public List<PlatformMapperPair> getPairs() {
            return this.pairs;
        }
    }
}

