/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class EngineType
extends AbstractEnumerator {
    public static final int JBE = 0;
    public static final int RBA = 1;
    public static final int RBF = 2;
    public static final int HDSN = 3;
    public static final EngineType JBE_LITERAL = new EngineType(0, "JBE", "Jazz Build Engine");
    public static final EngineType RBA_LITERAL = new EngineType(1, "RBA", "Rational Build Agent");
    public static final EngineType RBF_LITERAL = new EngineType(2, "RBF", "Rational Build Forge");
    public static final EngineType HDSN_LITERAL = new EngineType(3, "HDSN", "Hudson Jenkins");
    private static final EngineType[] VALUES_ARRAY = new EngineType[]{JBE_LITERAL, RBA_LITERAL, RBF_LITERAL, HDSN_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    private static List<EngineType> ValueList = new ArrayList<EngineType>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(null);
            EngineType[] engineTypeArray = EngineType.values();
            int n = engineTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EngineType code = engineTypeArray[n2];
                this.add(code);
                ++n2;
            }
        }
    };
    private static List<String> LabelList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("");
            EngineType[] engineTypeArray = EngineType.values();
            int n = engineTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EngineType code = engineTypeArray[n2];
                this.add(code.getLiteral());
                ++n2;
            }
        }
    };

    public static EngineType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EngineType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EngineType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EngineType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EngineType get(int value) {
        switch (value) {
            case 0: {
                return JBE_LITERAL;
            }
            case 1: {
                return RBA_LITERAL;
            }
            case 2: {
                return RBF_LITERAL;
            }
            case 3: {
                return HDSN_LITERAL;
            }
        }
        return null;
    }

    private EngineType(int value, String name, String literal) {
        super(value, name, literal);
    }

    public static final List<EngineType> getList() {
        return ValueList;
    }

    public static final EngineType[] getArray() {
        return ValueList.toArray(new EngineType[ValueList.size()]);
    }

    public static final int getIndex(EngineType code) {
        return ValueList.indexOf((Object)code);
    }

    public static final String[] getLabels() {
        return LabelList.toArray(new String[LabelList.size()]);
    }

    public static final boolean isValid(String s) {
        EngineType[] engineTypeArray = EngineType.values();
        int n = engineTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EngineType code = engineTypeArray[n2];
            if (code.getName().equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final String toString(EngineType code) {
        return EngineType.toString(code, "null");
    }

    public static final String toString(EngineType item, String s) {
        return item == null ? s : item.toString();
    }

    public static final EngineType[] values() {
        return VALUES_ARRAY;
    }
}

