/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.mapping.impl;

import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMappingPair;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class SystemDefinitionMapping
implements ISystemDefinitionMapping {
    private String type;
    private List<ISystemDefinitionMappingPair> pairs;
    private long lastModified;

    public SystemDefinitionMapping(String type) {
        this.type = type;
        this.pairs = new ArrayList<ISystemDefinitionMappingPair>();
        this.lastModified = 0L;
    }

    @Override
    public void addPair(ISystemDefinitionMappingPair pair) {
        this.pairs.add(pair);
    }

    @Override
    public List<ISystemDefinitionMappingPair> getPairs() {
        return this.pairs;
    }

    @Override
    public int indexOf(UUID srcUuid, String srcName) {
        int i = 0;
        while (i < this.pairs.size()) {
            ISystemDefinitionMappingPair pair = this.pairs.get(i);
            if (pair.getSrcUUID().equals((Object)srcUuid) && pair.getSrcName().equals(srcName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public UUID getTargetUuid(UUID srcUuid) {
        int i = 0;
        while (i < this.pairs.size()) {
            ISystemDefinitionMappingPair pair = this.pairs.get(i);
            if (pair.getSrcUUID().equals((Object)srcUuid)) {
                return pair.getTargetUUID();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }
}

