/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.mapping;

import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMappingPair;
import com.ibm.team.enterprise.systemdefinition.common.mapping.impl.SystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.impl.SystemDefinitionMappingPair;
import com.ibm.team.enterprise.systemdefinition.common.util.Namespace;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SystemDefinitionMappingParser {
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    protected static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final Namespace MAPPING_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/systemdefinition/mappings", "sdm");
    public static final TagWithNS TAG_MAPPINGS = new TagWithNS(MAPPING_NAMESPACE, "mappings");
    public static final TagWithNS TAG_PAIR = new TagWithNS(MAPPING_NAMESPACE, "pair");
    public static final TagWithNS TAG_SOURCE_UUID = new TagWithNS(MAPPING_NAMESPACE, "sourceUuid");
    public static final TagWithNS TAG_TARGET_UUID = new TagWithNS(MAPPING_NAMESPACE, "targetUuid");
    public static final TagWithNS TAG_SOURCE_NAME = new TagWithNS(MAPPING_NAMESPACE, "sourceName");
    public static final TagWithNS TAG_TARGET_NAME = new TagWithNS(MAPPING_NAMESPACE, "targetName");
    public static final TagWithNS ATTR_TYPE = new TagWithNS(MAPPING_NAMESPACE, "type");

    public ISystemDefinitionMapping parse(String xmlContent) throws TeamRepositoryException {
        Element rdfDescriptionElement;
        block5: {
            Element rdfElement;
            block4: {
                try {
                    Document doc = this.newDocument(xmlContent);
                    rdfElement = this.parseRDF(doc);
                    if (rdfElement != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            rdfDescriptionElement = this.parseRDFDescription(rdfElement, null);
            if (rdfDescriptionElement != null) break block5;
            return null;
        }
        return this.parseRDFDescriptionElement(rdfDescriptionElement);
    }

    public List<ISystemDefinitionMapping> parse(String xmlContent, List<String> types) throws TeamRepositoryException {
        Element rdfElement;
        ArrayList<ISystemDefinitionMapping> mappings;
        block4: {
            mappings = new ArrayList<ISystemDefinitionMapping>(types.size());
            Document doc = this.newDocument(xmlContent);
            rdfElement = this.parseRDF(doc);
            if (rdfElement != null) break block4;
            return null;
        }
        try {
            for (String type : types) {
                ISystemDefinitionMapping mapping;
                Element rdfDescriptionElement = this.parseRDFDescription(rdfElement, type);
                if (rdfDescriptionElement == null || (mapping = this.parseRDFDescriptionElement(rdfDescriptionElement)) == null) continue;
                mappings.add(mapping);
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return mappings;
    }

    public String toXML(ISystemDefinitionMapping mappings) throws TeamRepositoryException {
        try {
            Document doc = this.newDocument();
            if (mappings != null) {
                Element rdfElement = this.convertToRdfElement(doc);
                this.mappingToXML(rdfElement, doc, mappings);
            }
            return this.transformToString(doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public String toXML(List<ISystemDefinitionMapping> mappingsList) throws TeamRepositoryException {
        try {
            Document doc = this.newDocument();
            Element rdfElement = this.convertToRdfElement(doc);
            for (ISystemDefinitionMapping mappings : mappingsList) {
                if (mappings == null) continue;
                this.mappingToXML(rdfElement, doc, mappings);
            }
            return this.transformToString(doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private ISystemDefinitionMapping parseRDFDescriptionElement(Element rdfDescriptionElement) {
        String typeValue = this.readAttributeFromChildElement(rdfDescriptionElement, ATTR_TYPE);
        SystemDefinitionMapping mapping = new SystemDefinitionMapping(typeValue);
        NodeList pairList = rdfDescriptionElement.getElementsByTagNameNS(TAG_PAIR.getNamespace(), TAG_PAIR.getTagName());
        if (pairList != null) {
            int i = 0;
            while (i < pairList.getLength()) {
                String srcName;
                Element pairElement = (Element)pairList.item(i);
                String srcUuid = this.readAttributeFromChildElement(pairElement, TAG_SOURCE_UUID);
                if (srcUuid != null && this.isValidUUID(srcUuid) && (srcName = this.readAttributeFromChildElement(pairElement, TAG_SOURCE_NAME)) != null) {
                    String targetUuid = this.readAttributeFromChildElement(pairElement, TAG_TARGET_UUID);
                    String targetName = this.readAttributeFromChildElement(pairElement, TAG_TARGET_NAME);
                    SystemDefinitionMappingPair pair = new SystemDefinitionMappingPair(this.parseUUID(srcUuid), srcName, this.parseUUID(targetUuid), targetName);
                    mapping.addPair(pair);
                }
                ++i;
            }
        }
        return mapping;
    }

    private void mappingToXML(Element rdfElement, Document doc, ISystemDefinitionMapping mappings) {
        Element rdfDescriptionElement = this.convertToRdfDescriptionElement(rdfElement, doc, mappings.getType());
        this.saveAttributeToChildElement(doc, rdfDescriptionElement, ATTR_TYPE, mappings.getType());
        for (ISystemDefinitionMappingPair pair : mappings.getPairs()) {
            Element pairElement = this.createResourceElementNS(doc, rdfDescriptionElement, TAG_PAIR);
            this.saveAttributeToChildElement(doc, pairElement, TAG_SOURCE_UUID, pair.getSrcUUID().getUuidValue());
            this.saveAttributeToChildElement(doc, pairElement, TAG_SOURCE_NAME, pair.getSrcName());
            if (pair.getTargetUUID() == null) {
                this.saveAttributeToChildElement(doc, pairElement, TAG_TARGET_UUID, "");
                this.saveAttributeToChildElement(doc, pairElement, TAG_TARGET_NAME, "");
                continue;
            }
            this.saveAttributeToChildElement(doc, pairElement, TAG_TARGET_UUID, pair.getTargetUUID().getUuidValue());
            if (pair.getTargetName() == null) {
                this.saveAttributeToChildElement(doc, pairElement, TAG_TARGET_NAME, "");
                continue;
            }
            this.saveAttributeToChildElement(doc, pairElement, TAG_TARGET_NAME, pair.getTargetName());
        }
    }

    protected Element getElement(Document doc, TagWithNS tag) {
        NodeList nodeList = doc.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    protected String readAttributeFromChildElement(Element element, TagWithNS tag) {
        String attribute = null;
        NodeList nodeList = element.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList != null && nodeList.getLength() > 0 && (attribute = nodeList.item(0).getTextContent()) != null) {
            attribute = attribute.intern();
        }
        return attribute;
    }

    protected Element saveAttributeToChildElement(Document doc, Element parentElement, TagWithNS tag, String value) {
        Element element = doc.createElementNS(tag.getNamespace(), tag.getTagName());
        element.setPrefix(tag.getPrefix());
        element.setTextContent(value);
        parentElement.appendChild(element);
        return element;
    }

    protected Document newDocument() throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException {
        return this.newDocument(null);
    }

    protected Document newDocument(String xmlContent) throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        if (xmlContent == null) {
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        return documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xmlContent.getBytes(UTF_8)));
    }

    private String transformToString(Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        try {
            String content;
            StreamResult result = new StreamResult(outputStream);
            DOMSource source = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty(INDENT_AMOUNT, THREE);
            transformer.transform(source, result);
            String string = content = outputStream.toString(UTF_8);
            return string;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private UUID parseUUID(String value) {
        try {
            return UUID.valueOf((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isValidUUID(String value) {
        try {
            UUID.valueOf((String)value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Element convertToRdfElement(Document doc) {
        Element rdfElement = doc.createElementNS(SystemDefinitionUtil.RDF_RDF_TAG.getNamespace(), SystemDefinitionUtil.RDF_RDF_TAG.getTagName());
        rdfElement.setPrefix(SystemDefinitionUtil.RDF_RDF_TAG.getPrefix());
        doc.appendChild(rdfElement);
        Attr attrRdf = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(SystemDefinitionUtil.RDF_NAMESPACE.getPrefix()).toString());
        attrRdf.setValue(SystemDefinitionUtil.RDF_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attrRdf);
        Attr attrMappings = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(MAPPING_NAMESPACE.getPrefix()).toString());
        attrMappings.setValue(MAPPING_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attrMappings);
        return rdfElement;
    }

    protected Element convertToRdfDescriptionElement(Element rdfElement, Document doc, String type) {
        Element rdfDescriptionElement = doc.createElementNS(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getNamespace(), SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getTagName());
        rdfDescriptionElement.setPrefix(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getPrefix());
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.RDF_ABOUT_TAG.getNamespace(), SystemDefinitionUtil.RDF_ABOUT_TAG.getTagName());
        attr.setPrefix(SystemDefinitionUtil.RDF_ABOUT_TAG.getPrefix());
        String uri = SystemDefinitionUtil.createSystemDefinitionMappingSlug(type);
        attr.setValue(uri);
        attr = rdfDescriptionElement.setAttributeNodeNS(attr);
        rdfElement.appendChild(rdfDescriptionElement);
        return rdfDescriptionElement;
    }

    protected Element createResourceElementNS(Document doc, Element parentElement, TagWithNS tag) {
        Element element = doc.createElementNS(tag.getNamespace(), tag.getTagName());
        element.setPrefix(tag.getPrefix());
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.RDF_PARSETYPE_TAG.getNamespace(), SystemDefinitionUtil.RDF_PARSETYPE_TAG.getTagName());
        attr.setPrefix(SystemDefinitionUtil.RDF_PARSETYPE_TAG.getPrefix());
        attr.setValue("Resource");
        element.setAttributeNodeNS(attr);
        return (Element)parentElement.appendChild(element);
    }

    protected Element parseRDF(Document document) {
        NodeList rdfElements = document.getElementsByTagNameNS(SystemDefinitionUtil.RDF_RDF_TAG.getNamespace(), SystemDefinitionUtil.RDF_RDF_TAG.getTagName());
        if (rdfElements.getLength() > 0) {
            return (Element)rdfElements.item(0);
        }
        return null;
    }

    protected Element parseRDFDescription(Element rdfElement, String type) {
        NodeList rdfDescriptionElements = rdfElement.getElementsByTagNameNS(SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getNamespace(), SystemDefinitionUtil.RDF_DESCRIPTION_TAG.getTagName());
        if (rdfDescriptionElements.getLength() > 0) {
            if (type != null) {
                int i = 0;
                while (i < rdfDescriptionElements.getLength()) {
                    Element rdfDescriptionElement = (Element)rdfDescriptionElements.item(i);
                    String value = rdfDescriptionElement.getAttributeNS(SystemDefinitionUtil.RDF_NAMESPACE.getNamespace(), "about");
                    if (value != null && value.equals("_type=" + type)) {
                        return rdfDescriptionElement;
                    }
                    ++i;
                }
            }
            return (Element)rdfDescriptionElements.item(0);
        }
        return null;
    }
}

