/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class Processor
extends AbstractEnumerator {
    public static final int COPY = 0;
    public static final int GENER = 1;
    public static final int LKED = 2;
    public static final int UPDTE = 3;
    public static final Processor COPY_LITERAL = new Processor(0, "COPY", "Copy");
    public static final Processor GENER_LITERAL = new Processor(1, "GENER", "IEBGENER");
    public static final Processor LKED_LITERAL = new Processor(2, "LKED", "Link edit");
    public static final Processor UPDTE_LITERAL = new Processor(3, "UPDTE", "IEBUPDATE");
    private static final Processor[] VALUES_ARRAY = new Processor[]{COPY_LITERAL, GENER_LITERAL, LKED_LITERAL, UPDTE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    private static List<Processor> ValueList = new ArrayList<Processor>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(null);
            Processor[] processorArray = Processor.values();
            int n = processorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Processor process = processorArray[n2];
                this.add(process);
                ++n2;
            }
        }
    };
    private static List<String> LabelList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("");
            Processor[] processorArray = Processor.values();
            int n = processorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Processor process = processorArray[n2];
                this.add(process.getLiteral());
                ++n2;
            }
        }
    };

    public static Processor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Processor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Processor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Processor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Processor getByString(String string) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Processor result = VALUES_ARRAY[i];
            if (result.toString().equalsIgnoreCase(string)) {
                return result;
            }
            if (result.getName().equalsIgnoreCase(string)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Processor get(int value) {
        switch (value) {
            case 0: {
                return COPY_LITERAL;
            }
            case 1: {
                return GENER_LITERAL;
            }
            case 2: {
                return LKED_LITERAL;
            }
            case 3: {
                return UPDTE_LITERAL;
            }
        }
        return null;
    }

    public static final List<Processor> getList() {
        return ValueList;
    }

    public static final Processor[] getArray() {
        return ValueList.toArray(new Processor[ValueList.size()]);
    }

    public static final int getIndex(Processor item) {
        return ValueList.indexOf((Object)item);
    }

    public static final String[] getLabels() {
        return LabelList.toArray(new String[LabelList.size()]);
    }

    public static final boolean isValid(String s) {
        Processor[] processorArray = Processor.values();
        int n = processorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Processor process = processorArray[n2];
            if (process.getName().equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final String toString(Processor item) {
        return Processor.toString(item, "null");
    }

    public static final String toString(Processor item, String s) {
        return item == null ? s : item.toString();
    }

    public static final Processor[] values() {
        return VALUES_ARRAY;
    }

    private Processor(int value, String name, String literal) {
        super(value, name, literal);
    }
}

