/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class LevelType
extends AbstractEnumerator {
    public static final int RAW = 0;
    public static final int FUNCTION = 1;
    public static final int USERMOD = 2;
    public static final int APAR = 3;
    public static final int PTF = 4;
    public static final LevelType RAW_LITERAL = new LevelType(0, "RAW", "RAW");
    public static final LevelType FUNCTION_LITERAL = new LevelType(1, "FUNCTION", "FUNCTION");
    public static final LevelType USERMOD_LITERAL = new LevelType(2, "USERMOD", "USERMOD");
    public static final LevelType APAR_LITERAL = new LevelType(3, "APAR", "APAR");
    public static final LevelType PTF_LITERAL = new LevelType(4, "PTF", "PTF");
    private static final LevelType[] VALUES_ARRAY = new LevelType[]{RAW_LITERAL, FUNCTION_LITERAL, USERMOD_LITERAL, APAR_LITERAL, PTF_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    private static List<LevelType> ValueList = new ArrayList<LevelType>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(null);
            LevelType[] levelTypeArray = LevelType.values();
            int n = levelTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LevelType levelType = levelTypeArray[n2];
                this.add(levelType);
                ++n2;
            }
        }
    };
    private static List<String> LabelList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("");
            LevelType[] levelTypeArray = LevelType.values();
            int n = levelTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LevelType levelType = levelTypeArray[n2];
                this.add(levelType.getLiteral());
                ++n2;
            }
        }
    };

    public static LevelType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LevelType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LevelType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LevelType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LevelType getByString(String string) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LevelType result = VALUES_ARRAY[i];
            if (result.toString().equalsIgnoreCase(string)) {
                return result;
            }
            if (result.getName().equalsIgnoreCase(string)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LevelType get(int value) {
        switch (value) {
            case 0: {
                return RAW_LITERAL;
            }
            case 1: {
                return FUNCTION_LITERAL;
            }
            case 2: {
                return USERMOD_LITERAL;
            }
            case 3: {
                return APAR_LITERAL;
            }
            case 4: {
                return PTF_LITERAL;
            }
        }
        return null;
    }

    public static final List<LevelType> getList() {
        return ValueList;
    }

    public static final LevelType[] getArray() {
        return ValueList.toArray(new LevelType[ValueList.size()]);
    }

    public static final int getIndex(LevelType item) {
        return ValueList.indexOf((Object)item);
    }

    public static final String[] getLabels() {
        return LabelList.toArray(new String[LabelList.size()]);
    }

    public static final boolean isValid(String s) {
        LevelType[] levelTypeArray = LevelType.values();
        int n = levelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LevelType levelType = levelTypeArray[n2];
            if (levelType.getName().equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final String toString(LevelType item) {
        return LevelType.toString(item, "null");
    }

    public static final String toString(LevelType item, String s) {
        return item == null ? s : item.toString();
    }

    public static final LevelType[] values() {
        return VALUES_ARRAY;
    }

    private LevelType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

