/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class LanguageCode
extends AbstractEnumerator {
    public static final int ASM = 0;
    public static final int BIN = 1;
    public static final int BND = 2;
    public static final int C = 3;
    public static final int CPP = 4;
    public static final int COB = 5;
    public static final int EASY = 6;
    public static final int JCL = 7;
    public static final int LNK = 8;
    public static final int PLI = 9;
    public static final int REXX = 10;
    public static final int OTH = 11;
    public static final LanguageCode ASM_LITERAL = new LanguageCode(0, "ASM", "Assembler");
    public static final LanguageCode BIN_LITERAL = new LanguageCode(1, "BIN", "Binary");
    public static final LanguageCode BND_LITERAL = new LanguageCode(2, "BND", "Bind");
    public static final LanguageCode C_LITERAL = new LanguageCode(3, "C", "C");
    public static final LanguageCode CPP_LITERAL = new LanguageCode(4, "CPP", "C++");
    public static final LanguageCode COB_LITERAL = new LanguageCode(5, "COB", "Cobol");
    public static final LanguageCode EASY_LITERAL = new LanguageCode(6, "EASY", "CA Easytrieve");
    public static final LanguageCode JCL_LITERAL = new LanguageCode(7, "JCL", "JCL");
    public static final LanguageCode LNK_LITERAL = new LanguageCode(8, "LNK", "Link Edit");
    public static final LanguageCode PLI_LITERAL = new LanguageCode(9, "PLI", "PL/I");
    public static final LanguageCode REXX_LITERAL = new LanguageCode(10, "REXX", "Restructured Extended Executor");
    public static final LanguageCode OTH_LITERAL = new LanguageCode(11, "OTH", "Other");
    private static final LanguageCode[] VALUES_ARRAY = new LanguageCode[]{ASM_LITERAL, BIN_LITERAL, BND_LITERAL, C_LITERAL, CPP_LITERAL, COB_LITERAL, EASY_LITERAL, JCL_LITERAL, LNK_LITERAL, PLI_LITERAL, REXX_LITERAL, OTH_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    private static List<LanguageCode> ValueList = new ArrayList<LanguageCode>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(null);
            LanguageCode[] languageCodeArray = LanguageCode.values();
            int n = languageCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageCode code = languageCodeArray[n2];
                this.add(code);
                ++n2;
            }
        }
    };
    private static List<String> LabelList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("");
            LanguageCode[] languageCodeArray = LanguageCode.values();
            int n = languageCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageCode code = languageCodeArray[n2];
                this.add(code.getLiteral());
                ++n2;
            }
        }
    };

    public static LanguageCode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageCode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageCode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageCode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageCode get(int value) {
        switch (value) {
            case 0: {
                return ASM_LITERAL;
            }
            case 1: {
                return BIN_LITERAL;
            }
            case 2: {
                return BND_LITERAL;
            }
            case 3: {
                return C_LITERAL;
            }
            case 4: {
                return CPP_LITERAL;
            }
            case 5: {
                return COB_LITERAL;
            }
            case 6: {
                return EASY_LITERAL;
            }
            case 7: {
                return JCL_LITERAL;
            }
            case 8: {
                return LNK_LITERAL;
            }
            case 9: {
                return PLI_LITERAL;
            }
            case 10: {
                return REXX_LITERAL;
            }
            case 11: {
                return OTH_LITERAL;
            }
        }
        return null;
    }

    public static final List<LanguageCode> getList() {
        return ValueList;
    }

    public static final LanguageCode[] getArray() {
        return ValueList.toArray(new LanguageCode[ValueList.size()]);
    }

    public static final int getIndex(LanguageCode code) {
        return ValueList.indexOf((Object)code);
    }

    public static final String[] getLabels() {
        return LabelList.toArray(new String[LabelList.size()]);
    }

    public static final boolean isValid(String s) {
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode code = languageCodeArray[n2];
            if (code.getName().equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final String toString(LanguageCode code) {
        return LanguageCode.toString(code, "null");
    }

    public static final String toString(LanguageCode item, String s) {
        return item == null ? s : item.toString();
    }

    public static final LanguageCode[] values() {
        return VALUES_ARRAY;
    }

    private LanguageCode(int value, String name, String literal) {
        super(value, name, literal);
    }
}

